@extends('layouts.default')

@section('title', 'Import Customers')

@section('content')

    <div class="box box-success">

        {!! Form::open(['url' => 'incomes/customers', 'role' => 'form']) !!}

        <div class="box-body">

        	<table class="table table-striped table-hover" id="tbl-customers">
                <thead>
                    <tr>
                        <th class="col-md-2">
                        {{ Form::selectGroup('payment_method', null, null, $rows,null) }}</th>
                        <th class="col-md-2">{{ Form::selectGroup('payment_method', trans_choice('general.payment_methods', 1), 'credit-card', $rows, setting('general.default_payment_method')) }}</th>
                    </tr>
                </thead>
                <tbody>  
	                @foreach($rows as $row)
	                	<tr>
	                		<td>
	                			{{ $row->active_status }}
	                		</td><td>
	                			{{ $row->active_status }}
	                		</td>
	                	</tr>      
					@endforeach       	
                </tbody>
            </table>
        	
        </div>
        <!-- /.box-body -->
        
        <div class="box-footer">
            {{ Form::saveButtons('incomes/customers') }}
        </div>
        <!-- /.box-footer -->

        {!! Form::close() !!}
    </div>

@endsection