@extends('layouts.default')

@section('title', trans('general.title.edit', ['type' => trans_choice('general.customers', 1)]))
@section('new_button')
<a href="{{ url('incomes/customers')}}" class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>{{ trans_choice('general.customers', 1) . ' List'}} </a>

<a href="{{ url('incomes/customers/' . $customer->id)}}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">remove_red_eye</i>show</a>

<a href="{{ url('incomes/customers/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Customers"><i class="material-icons left">add</i>{{ trans_choice('general.customers', 1)}} </a>

@endsection
@section('content')
<!-- Default box -->
<div class="card">
    {!! Form::model($customer, [
        'method' => 'PATCH',
        'url' => ['incomes/customers', $customer->id],
        'role' => 'form'
    ]) !!}

    <div class="row">
        <div class="col-md-3">
            {{  Form::selectGroup('customer_type','Customer Type', ['customer'=>'Customer','job'=>'Job','w2c'=>'W2C'], null, []) }}
        </div>
        <div class="col-md-3">
            {{ Form::textGroup('name', trans('general.company_name'), null, ['id'=>'name','required'=>'required']) }}
        </div>
        
        {{-- Sub Customer Code --}}      
            <div class="col-lg-3 col-md-4 col-sm-6" >
                <small>Customer</small>
                <select id="customer" name="customer"  class="selectpicker" disabled="disabled">
                  @include('accounts.common.subloop',[ 'customer_id' => $customer->parent_id ,'name' => trans('general.form.select.field', ['field' => 'Customer'])])     
                </select>
                <div class="help-block ">
                     <div class="custom-controls-stacked d-block">
                        <label class="custom-control overflow-checkbox" >
                        <input type="checkbox"  name="subcustomer" id="subcustomer" value="1" class="overflow-control-input" {{ isset($customer->parent_id)?'checked':'' }}>
                        <span class="overflow-control-indicator"></span> <span class="overflow-control-description">  Is sub-customer</span> </label>
                    </div> 
                 </div> 

            </div>
            <input name="parent_id"  type="hidden" value="{{ $customer->parent_id }}">
            
            <div class="col-lg-3 col-md-4 col-sm-6" >
                <small>Customer</small>
                <select class="selectpicker"  id="bill_to" name="bill_to" disabled="disabled">
                    <option {{ ($customer->bill_to == 'parent') ? 'selected="selected"' : '' }}  value="parent"> Bill With Parent</option>
                    <option {{ ($customer->bill_to == 'customer') ? 'selected="selected"' : '' }}  value="customer"> Bill With Customer</option>  
                </select>
            </div>
        {{-- Sub Customer  Code --}}

        <div class="col-lg-3 col-md-4 col-sm-6"  id="consultant_dropdown" style="display: none">
            <small>Select Consultant</small>
            <select id="consultant" name="consultant" class="selectpicker" data-live-search="true">
                <option value="">Select Consultant</option>
                @foreach($consultants as $key => $value)
                <option value="{{ $key }}" {{ ($customer->consultant == $key)?'selected':'' }}>{{ $value }}</option>
                @endforeach    
            </select>
            <div class="help-block">
                <div class="custom-controls-stacked d-block">
                    <label class="custom-control overflow-checkbox" >
                    <input type="checkbox"  name="timesheet" id="timesheet" 
                    value="1" {{ isset($customer->timesheet)?'checked':"" }} class="overflow-control-input">
                    <span class="overflow-control-indicator"></span> <span class="overflow-control-description">Time Sheet</span> </label>
                </div> 
            </div>
        </div>

        <div class="col-md-3">
            {{ Form::textGroup('customer_email', trans('general.email'), null, [] ) }}  
        </div>
        <div class="col-md-3">
            {{ Form::textGroup('cc_email', trans('general.ccemail'), null, []) }}
        </div>
        <div class="col-md-3">
            {{ Form::textGroup('phone', trans('general.phone'), null, []) }}
        </div>
        <div class="col-md-3">
            {{ Form::textGroup('website', trans('general.website'), null, []) }}
        </div>
        <div class="col-md-3">
            {{ Form::textGroup('company', trans('general.coustomer_name'), 'company', []) }} 
        </div>
        <div class="col-md-3">
            {{ Form::selectGroup('payment_method', trans_choice('general.payment_methods', 1), $payment_methods, null, []) }}
        </div>
        
        {{ Form::hidden('currency_code', setting('general.default_currency'), ['id' => 'currency_code']) }}        
        {{--  {{ Form::textGroup('mobile', trans('general.mobile'), 'phone', [],null,'col-md-3' ) }} --}} 

        <div class="col-lg-3 col-md-4 col-sm-6 required {{ $errors->has('net_term') ? 'has-error' : ''}}">
            <small>{{ trans_choice('general.net_term', 1) }}</small>
            {!! Form::select('net_term', $terms, null, array_merge(['class' => 'selectpicker','data-live-search'=>'true','placeholder' => trans('general.form.select.field', ['field' => trans_choice('general.net_term', 1)])])) !!}
        </div>
        {!! $errors->first('net_term', '<p class="help-block">:message</p>') !!}
            
        {{ Form::textareaGroup('address', trans('general.billingaddress') , null, ['rows' => '3']) }}
    
        <div class="col-md-6">
            <div class="form-groupTextArea">
                    {{ Form::textarea('shipping_address', null,['class'=>'form-ControlTextArea',  'id'=> 'shipping_address' ,'rows' => 3]) }}
                <label for="shipping_address" class="form-label">Shipping Address</label>
                 <span class="form-controlBrd"></span>
            </div>
             <div class="help-block">
                <div class="custom-controls-stacked d-block">
                        <label class="custom-control overflow-checkbox" >
                    <input type="checkbox"  name="same_as_billing" id="same_as_billing" value="1" class="overflow-control-input" {{ isset($customer->same_as_billing)?'checked':'' }}>
                    <span class="overflow-control-indicator"></span> <span class="overflow-control-description"> Same as billing address </span> </label>
                </div> 
             </div>
        </div>
        {{ Form::radioGroup('enabled', trans('general.enabled')) }}

    </div>
    <!-- /.box-body -->
    
    <div class="box-footer">
        {{ Form::saveButton('Update incomes/customers') }}
    </div>
    <!-- /.box-footer -->

    {!! Form::close() !!}
</div>
@endsection



@push('scripts')
    <script type="text/javascript">
        var text_yes = '{{ trans('general.yes') }}';
        var text_no = '{{ trans('general.no') }}';

        $(window).on("load", function(){
           
           $("#subcustomer").change(function() {
                if(this.checked) {
                  $('#customer').removeAttr('disabled');
                  $('#bill_to').removeAttr('disabled');
                } 
                else{
                    $('#customer').attr('disabled','disabled');
                    $('input[name="parent_id"]').val();
                    $('#bill_to').attr('disabled','disabled');
                    $('#bill_to').val();
                }  
                $('#customer').selectpicker('refresh');
                $('#bill_to').selectpicker('refresh');             
            });

            if($('#same_as_billing').is(':checked') == true){
                $('#shipping_address').prop('disabled', true);
            }
        });

        $(document).ready(function(){
            var customer_type =  $('#customer_type').val();
            if(customer_type){
                if(customer_type == 'job'){
                    $("label[for='name']").html('Consultant Name <span class="RED-Star"> *</span>');
                    $('#consultant_dropdown').show();
                }else{
                    $("label[for='name']").html('Customer Company Name <span class="RED-Star"> *</span>');
                    $('#consultant_dropdown').hide();
                }
            }

             $('#customer_type').change(function(){
                if($(this).val() == 'job'){
                    $("label[for='name']").html('Consultant Name <span class="RED-Star"> *</span>');
                    $('#consultant_dropdown').show();
                }else{
                    $("label[for='name']").html('Customer Company Name <span class="RED-Star"> *</span>');
                    $('#consultant_dropdown').hide();
                }
            });
           
            

           $('#same_as_billing').change(function(){
                var c = this.checked;
                $('#shipping_address').prop('disabled', c);
                if(c){
                $('#shipping_address').val($('#address').val());
                }else{
                 $('#shipping_address').val('');
                }
            });

            $("#subcustomer").change(function() {
                if(this.checked) {
                  $('#customer').removeAttr('disabled');
                  $('#bill_to').removeAttr('disabled');
                } 
                else{
                    $('#customer').attr('disabled','disabled');
                    $('input[name="parent_id"]').val();
                    $('#bill_to').attr('disabled','disabled');
                    $('#bill_to').val();
                }               
            });





            /*$("#net_term").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('general.net_term', 1)]) }}"
            });

            $("#customer").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('general.customers', 1)]) }}"
            });*/

            $('#create_user').on('ifClicked', function (event) {
                $('input[name="user_id"]').remove();

                if ($(this).prop('checked')) {
                    $('.col-md-6.password').remove();

                    $('input[name="email"]').parent().parent().removeClass('has-error');
                    $('input[name="email"]').parent().parent().find('.help-block').remove();
                } else {
                    var email = $('input[name="email"]').val();

                    if (!email) {
                        $('input[name="email"]').parent().parent().removeClass('has-error');
                        $('input[name="email"]').parent().parent().find('.help-block').remove();

                        $('input[name="email"]').parent().parent().addClass('has-error');
                        $('input[name="email"]').parent().after('<p class="help-block">{{ trans('validation.required', ['attribute' => 'email']) }}</p>');
                        $('input[name="email"]').focus();

                        unselect();

                        return false;
                    }

                    $.ajax({
                        url: '{{ url("auth/users/autocomplete") }}',
                        type: 'GET',
                        dataType: 'JSON',
                        data: {column: 'email', value: $('input[name="email"]').val()},
                        beforeSend: function() {
                            $('.iCheck-helper').parent().after('<i class="fa fa-spinner fa-pulse fa-fw loading" style="margin-left: 10px;"></i>');

                            $('input[name="email"]').parent().parent().removeClass('has-error');
                            $('input[name="email"]').parent().parent().find('.help-block').remove();

                            $('.box-footer .btn').attr('disabled', true);
                        },
                        success: function(json) {
                            if (json['errors']) {
                                if (json['data']) {
                                    $('input[name="email"]').parent().parent().addClass('has-error');
                                    $('input[name="email"]').parent().after('<p class="help-block">' + json['data'] + '</p>');
                                    $('input[name="email"]').focus();

                                    return false;
                                }

                                fields = [];

                                fields[0] = 'password';
                                fields[1] = 'password_confirmation';

                                $.ajax({
                                    url: '{{ url("incomes/customers/field") }}',
                                    type: 'POST',
                                    dataType: 'JSON',
                                    data: {fields: fields},
                                    headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
                                    complete: function() {
                                        $('.box-footer .btn').attr('disabled', false);
                                        $('.loading').remove();
                                    },
                                    success: function(json) {
                                        $('#customer-create-user').after(json['html']);
                                    }
                                });
                            }

                            if (json['success']) {
                                $('input[name="password_confirmation"]').after('<input name="user_id" type="hidden" value="' + json['data']['id'] + '" id="user-id">');
                            }
                        }
                    });
                }
            });
        });

        function unselect() {
            setTimeout(function(){
                $('#create_user').iCheck('uncheck');
            }, 550);
        }
    </script>
@endpush
