@extends('layouts.default')

@section('title', trans('general.title.new', ['type' => trans_choice('general.customers', 1)]))
@section('new_button')
<a href="{{ url('incomes/customers')}}" class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>{{ trans_choice('general.customers', 1) . ' List'}} </a>
@endsection
<style>
     .bootstrap-select.btn-group .dropdown-menu.inner {
    max-height: 400px !important;
}
</style>
@section('content')
    <!-- Default box -->
    <div class="card">

        {!! Form::open(['url' => 'incomes/customers', 'role' => 'form']) !!}

        <div class="row">
            {{  Form::selectGroup('customer_type',' Type',null,['customer'=>'Customer','job'=>'Job','w2c'=>'W2C']) }}

            {{ Form::textGroup('name', trans('general.company_name'), 'id-card-o',['id'=>'name','required'=>'required']) }}

            {{-- Sub Customer Code --}}
            <div class="form-group col-md-6 row">
                <div class=" col-md-8" >
                    <small>Select Customer</small>
                        <select id="customer" name="customer"  class="selectpicker" data-live-search="true" disabled="disabled">
                          @include('accounts.common.subloop' ,[ 'customer_id' => '' , 'name' => trans('general.form.select.field', ['field' => 'Customer'])])     
                        </select>
                        <div class="help-block">
                            <div class="custom-controls-stacked d-block">
                                <label class="custom-control overflow-checkbox" >
                                <input type="checkbox"  name="subcustomer" id="subcustomer" value="1" class="overflow-control-input">
                                <span class="overflow-control-indicator"></span> <span class="overflow-control-description">  Is sub-customer</span> </label>
                            </div> 
                        </div>
                    <input name="parent_id"  type="hidden">
                </div>
                <div class=" col-md-4" >
                    <small>Bill To</small>
                    <select class="selectpicker"  id="bill_to" name="bill_to" disabled="disabled">
                        <option selected="selected" value="parent"> Bill With Parent</option>
                        <option  value="customer"> Bill With Customer</option>  
                    </select>
                </div> 
            </div>
            {{-- Sub Customer  Code --}}            

            <div class="col-lg-3 col-md-4 col-sm-6" id="consultant_dropdown" style="display: none">
                <small>Select Consultant</small>
                <select id="consultant" name="consultant" class="selectpicker" data-live-search="true">
                    <option value="">Select Consultant</option>
                    @foreach($consultants as $key => $value)
                    <option value="{{ $key }}">{{ $value }}</option>
                    @endforeach    
                </select>
                <div class="help-block">
                    <div class="custom-controls-stacked d-block">
                        <label class="custom-control overflow-checkbox" >
                        <input type="checkbox"  name="timesheet" id="timesheet" value="1" class="overflow-control-input">
                        <span class="overflow-control-indicator"></span> <span class="overflow-control-description">Time Sheet</span> </label>
                    </div> 
                </div>
            </div>

            {{ Form::textGroup('customer_email', trans('general.email'), 'envelope', [],null,'col-md-3') }}

            {{ Form::textGroup('cc_email', trans('general.ccemail'), 'envelope', [],null,'col-md-3') }}

            {{ Form::hidden('currency_code', setting('general.default_currency'),['id' => 'currency_code']) }} 

            {{ Form::textGroup('phone', trans('general.phone'), 'phone', [],null,'col-md-3' ) }}

            {{-- {{ Form::textGroup('mobile', trans('general.mobile'), 'phone', [],null,'col-md-3' ) }} --}}
           
            {{ Form::textGroup('website', trans('general.website'), 'globe', []) }}
           
            {{ Form::textGroup('company',  trans('general.coustomer_name'), 'company',[],null) }}
            
            {{ Form::selectGroup('payment_method', trans_choice('general.payment_methods', 1), 'credit-card', $payment_methods, setting('general.default_payment_method')) }}
            
            <div class="col-lg-3 col-md-4 col-sm-6 required {{ $errors->has('net_term') ? 'has-error' : ''}}">
                <div class="row">
                <div class="col-md-10 pr-0">
                        <div class="add-cust">
                    <small>{{ trans_choice('general.net_term', 1) }}</small>
                    {!! Form::select('net_term', $terms, setting('general.default_netterm'), array_merge(['class' => 'selectpicker','data-live-search'=>'true','placeholder' => trans('general.form.select.field', ['field' => trans_choice('general.net_term', 1)])])) !!}
                    </div>
                </div>
                <div class="col-md-2 pl-0 pr-0">
                    <div class="add-bttn">
                     <button type="button" data-toggle="modal" id="modal-create-term-button" data-target="#modal-create-term"   class="btn btn-xs btn-primary" data-original-title="Add"><i class="material-icons" style="font-size:14px;padding:0px;">add </i></button>
                    </div>
                </div>
                    {!! $errors->first('net_term', '<p class="help-block">:message</p>') !!}
                </div>
            </div>
            {{  Form::hidden('currency_code',setting('general.default_currency')) }}

            {{ Form::textareaGroup('address', trans('general.billingaddress') ,null,['rows' => '3','id'=>'address'],'col-md-6' )}}
            
            <div class="col-md-6">
                <div class="form-groupTextArea">     
                    {{ Form::textarea('shipping_address', null ,['class'=>'form-ControlTextArea', 'id'=> 'shipping_address' ,'rows' => 3]) }}
                    <label for="shipping_address" class="form-label">Shipping Address</label>
                     <span class="form-controlBrd"></span>
                </div>
                    <div class="help-block ">
                         <div class="custom-controls-stacked d-block">
                            <label class="custom-control overflow-checkbox" >
                            <input type="checkbox"  name="same_as_billing" id="same_as_billing" value="1" class="overflow-control-input">
                            <span class="overflow-control-indicator"></span> <span class="overflow-control-description"> Same as billing address </span> </label>
                        </div> 
                    </div>
            </div>
            {{ Form::radioGroup('enabled', trans('general.status')) }}

        </div>
        <!-- /.box-body -->


        
        <div class="box-footer">
            {{ Form::saveButtons('incomes/customers') }}
        </div>
        <!-- /.box-footer -->

      

        {!! Form::close() !!}
    </div>
  <!-- Create Net Term Model -->
<div class="modal fade" id="modal-create-term" >
  <div class="modal-dialog ">
      <div class="modal-content">
          <div class="modal-header">
              <h4 class="modal-title">{{ trans('general.title.new', ['type' => trans_choice('general.net_term', 1)]) }}</h4>
          </div>
          <div class="modal-body">
              {!! Form::open(['id' => 'form-create-term', 'role' => 'form']) !!}
              <div class="row">
                    <div class="col-md-6 "> 
                      <div class="form-group required">      
                            <input class="form-control" required name="name" type="text" id="name">
                            <label for="name" class="form-label">{{ trans('general.name') }}</label>
                            <span class="form-controlBrd"></span>
                      </div>
                    </div>
                    <div class="col-md-6 required">
                        <div class="form-group ">
                            <input class="form-control" required name="term_days" type="text" id="term_days"> 
                            <label for="name" class="form-label">Due in fixed number of days</label>
                            <span class="form-controlBrd"></span>
                        </div>
                    </div>
              </div>
              {!! Form::close() !!}
          </div>
          <div class="modal-footer">
              <div class="pull-left">
              <button type="button" id="close-modal-create-term" class="btn mr-3 btn-default waves-effect waves-gray" data-dismiss="modal"><span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</button>
              {!! Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'button', 'id' =>'button-create-term', 'class' => 'btn btn-primary waves-effect waves-light']) !!}
              </div>
          </div>
      </div>
  </div>
</div>

<script type="text/javascript">
    var text_yes = '{{ trans('general.yes') }}';
    var text_no = '{{ trans('general.no') }}';

    $(document).ready(function(){
        $('#enabled_1').prev().trigger('click');

        $('#name').focus();

        $('#address').on('keyup',function(){
            if($('#same_as_billing').is(":checked")){
                $('#shipping_address').val(''); 
                $('#shipping_address').addClass('has-value');
                $('#shipping_address').val($('#address').val());
            }
        });
        $('#customer_type').change(function(){
            if($(this).val() == 'job'){
                $("label[for='name']").html('Consultant Name <span class="RED-Star"> *</span>');
                $('#consultant_dropdown').show();
            }else{
                $("label[for='name']").html('Customer Company Name <span class="RED-Star"> *</span>');
                $('#consultant_dropdown').hide();
            }
        });

        $('#same_as_billing').change(function(){
            var c = this.checked;
            $('#shipping_address').prop('disabled', c);
            if(c){ 
                $('#shipping_address').val($('#address').val());
                $('#shipping_address').addClass('has-value');
            }else{
                    $('#shipping_address').val('');
            }
        });

        $("#subcustomer").change(function() {
            if(this.checked) {
                $('#customer').removeAttr('disabled');
                $('#bill_to').removeAttr('disabled');
            } 
            else{
                $('#customer').attr('disabled','disabled');
                $('input[name="parent_id"]').val();
                $('#bill_to').attr('disabled','disabled');
                $('#bill_to').val();
            }  
            $('#customer').selectpicker('refresh');
            $('#bill_to').selectpicker('refresh');             
        });

        $('#customer').on('change',function(){
            var customer_id = $(this).val();
            $.ajax({
                url: '{{ url('incomes/parent_customer_id/') }}'+'/'+customer_id,
                success:function(data){
                    $('#customer option:selected').html(data.full_name);
                    $('#select2-customer-container').html(data.full_name);
                    $('input[name="parent_id"]').val(customer_id);
                },
                error:function(data){
                        console.log(data)
                }
            });
        });
    });

    
    
        $(document).on('click', '#button-create-term', function (e) {
        $('#modal-create-term .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="{{ url('acs/custom/images/loader.gif') }}" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');

        $.ajax({
            url: '{{ url("/netterms/terms") }}',
            type: 'POST',
            dataType: 'JSON',
            data: $("#form-create-term").serialize(),
            beforeSend: function () {
                $(".form-group").removeClass("has-error");
                $(".help-block").remove();
            },
            success: function(data) {
                $('#span-loader').remove();
                $('#close-modal-create-term').trigger('click');
                $("#net_term").append('<option value="' + data.id + '" selected="selected">' + data.name + '</option>');
                $("#net_term").selectpicker('refresh');
            },
            error: function(error, textStatus, errorThrown) {
                $('#span-loader').remove();
            }
        });
    });
</script>    
@endsection
