@extends('layouts.default')
@section('title', trans_choice('general.creditmemo', 2))
@section('new_button')
<a href="{{ url('incomes/creditmemo') }}" class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>{{ trans_choice('general.creditmemo', 1) .' List'}} </a>
<a  href="{{ url('incomes/creditmemo/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data toggle="tooltip" title="Create Credit Memos"><i class="material-icons left">add</i>{{ trans_choice('general.creditmemo', 2)}}</a>
@endsection
@section('content')
<style>
    .invoice{padding:15px;}
    .table th{padding:1rem !important;}
    </style>
 <div class="card">
        <section class="invoice">
            
              <div class="row">
                <div class="col-lg-4 col-md-4">
                    <span class="depst-head">Customer  : </span>    {{ $creditmemo->customer_name }}
                </div>
                <div class="col-lg-4 col-md-4">
                    <span class="depst-head">Email  :</span> {{ $creditmemo->customer_email }} 
                </div> 
                <div class="col-lg-4 col-md-4">
                    <span class="depst-head">Address  :</span> {{ $creditmemo->customer_address }} 
                </div>
                
                <div class="col-lg-4 col-md-4">
                    <span class="depst-head">Credit Memo : </span>  {{ Date::parse($creditmemo->creditmemo_at)->format($date_format) }}
                </div>
            </div> 
            </section>
            </div> 
            <h3>Items</h3> 
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Quantity</th>
                                <th>Price</th>
                                <th>Total</th>
                            </tr>
                        </thead>

                            <tbody>
                            @foreach($creditmemo->items as $item)
                            <tr>
                                <td>{{ $item->products->name}}</td>
                                <td>{{ $item->quantity }}</td>
                                <td>@money($item->price,'USD',true)</td>
                                <td>@money($item->total,"USD",true)</td>
                            </tr>
                            @endforeach
                        
                        </tbody>
                    </table>
                </div>
            </div>
            <h3>Invoices</h3>
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Invoice Number</th>
                                <th>Amount</th>
                            </tr>
                        </thead>

                            <tbody>
                            @foreach($creditmemo->invoices as $invoice)
                            <tr>
                                <td>{{ $invoice->invoice_num}}</td>
                                <td>@money($invoice->amount,'USD',true)</td>
                            </tr>
                            @endforeach
                        
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-6">
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <div class="">
                        <table class="table">
                            <tbody>
                                <tr>
                                    <th>Total</th>
                                    <td class="text-right">@money($creditmemo->total,'USD',true)</td>
                                </tr>
                              
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="box-footer row no-print">
                <div class="col-md-12">
                   
                    <div class="col-lg-4 col-md-6">
                        <a href="#" class="btn btn-primary">
                              {{ trans('general.edit') }}
                        </a>
                    </div>
                    <div style="display:flex;">
                    
                        @if($creditmemo->attachment)
                        <span class="attachment">
                            <a href="{{ url('uploads/' . $creditmemo->attachment->id . '/download') }}">
                                <span id="download-attachment" class="text-primary">
                                    <i class="fa fa-file-{{ $creditmemo->attachment->aggregate_type }}-o"></i> {{ $creditmemo->attachment->basename }}
                                </span>
                            </a>
                        </span>
                    @endif
                   
                    </div>    
                  
                </div>
            </div>

       



@endsection