@extends('layouts.default')
@section('header-links')
    @include('accounts.incomes.header')
@endsection

@section('title', trans_choice('general.creditmemo', 2))

@section('new_button')
<div class="searchBox mr-2">
   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => trans('general.search_placeholder')]) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
<a  href="{{ url('incomes/creditmemo/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data toggle="tooltip" title="Create Credit Memos"><i class="material-icons left">add</i>{{ trans_choice('general.creditmemo', 2)}}</a>

@endsection

@section('content')
<!-- Default box -->
<div class="box box-success">
    <div class="">
        <div class="">
            <table class="table table-show table-striped table-hover table-bordered table-filter" id="tbl-items">
                
                <thead>
                    <tr>
                        <th>{{  trans_choice('general.customers',1) }}</th>
                        <th>{{  trans('general.date') }}</th>
                        <th>{{  trans_choice('general.totals',1) }}</th>
                        <th>{{  trans('general.status') }}</th>
                        <th>{{  trans('general.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                  @foreach($creditmemo as $credit)
          				<tr>
          					<td>{{ $credit->customer_name }}</td>
                    <td>{{ Date::parse($credit->creditmemo_at)->format($date_format) }}</td>
                    <td>@money($credit->total,'USD',true)</td>
                    <td>
                      <span class="badge badge-success">{{ ucwords($credit->status) }}</span>
                    </td>
                    <td>
                         {{-- <a  class="btn btn-outline-info btn-circle-iconic btn34" href="#"><i class="material-icons">create</i></a> --}}

                          <a class="btn btn-outline-info btn-circle-iconic btn34" href="{{url('incomes/creditmemo/'.$credit->id)}}"><i class="material-icons"> remove_red_eye </i></a>
                    </td>
          				</tr>
                  @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <!-- /.box-body -->

     <div class="box-footer">
    </div> 
       
    <!-- /.box-footer -->
</div>

@endsection