
<table class="table table-striped table-hover table-bordered tabl-input" id="tbl-invoices" style="table-layout:auto;">
<thead >
    <tr>
        <th>{{  trans_choice('general.numbers', 1) }}</th>
        <th>{{  trans_choice('general.customers', 1) }} </th>
        <th>{{  trans('general.totalamount') }} </th>
        <th>{{  trans('general.recivedamount') }} </th>
        <th>{{  trans_choice('general.balance',2)}} </th>
        <th>{{  trans('invoices.invoice_date')}} </th>
        <th>{{  trans('invoices.due_date')}} </th>
        <th>{{  trans_choice('general.statuses', 1)}} </th>
        <th>{{ trans('general.actions') }}</th>
    </tr>
</thead>
<tbody>
        <?php foreach($invoices as $item){
        
            if( !($item->payments_total->isEmpty()) ){

               $paid_amount = isset($item->payments_total[0]['paid_amount'])?$item->payments_total[0]['paid_amount']:0;
            }
            else{
                $paid_amount = 0;
            }
        ?>
            <tr> 
                <td><a href="{{ url('incomes/invoices/' . $item->id . ' ') }}">{{ $item->invoice_number }}</a></td>
                <td>
                        {{ $item->customer_name_with_parent }}
                </td>

                <td>@money($item->amount, $item->currency_code, true)</td>
                
                <td>@money($paid_amount, $item->currency_code, true)</td>
               
                <td>@money(($item->amount - $paid_amount),$item->currency_code, true)</td>
                <td>{{ Date::parse($item->invoiced_at)->format($date_format) }}</td>
                <td>{{ Date::parse($item->due_at)->format($date_format) }}</td>
                <td><span class="badge {{ $item->status->label }}">{{ $item->status->name }}</span></td>
                <td class="text-center">
                    <div class="form-group">
                        <input type="hidden" name="invoice[{{$item->id}}][invoice_id]" value="{{ $item->id }}">
                        <input class="form-control invoice_price"  name="invoice[{{$item->id}}][invoice_amount]" id="invoice_amount" type="number" min="1" max="{{ ($item->amount - $paid_amount)}}">
                        <label for="invoice_amount" class="form-label">Amount</label>
                        <span class="form-controlBrd"></span>
                    </div>
                </td>
            </tr>
        <?php } ?>
    </tbody>
</table>