@extends('layouts.default')
@section('header-links')
    @include('accounts.expenses.header')
@endsection
@section('title', trans_choice('general.vendors', 2))

@section('new_button')


<div class="searchBox mr-2">
   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => trans('general.search_placeholder')]) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>

<a href="{{ url('common/import/expenses/vendors') }}" class="btn mr-2 btn-default btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left rotate90deg">
last_page
</i> {{ trans('import.import') }}</a>

<a href="{{ url('expenses/vendors/billcenter') }}" class="btn mr-2 btn-default btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">star</i> {{ trans('customers.bill_center') }}</a>
<a href="{{ url('expenses/vendors/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Vendors"><i class="material-icons left">add</i> {{ trans_choice('general.vendors', 2) }}</a>

@endsection


@section('content')
<!-- Default box -->
<div class="box box-success">
    

    <div class="">
        <div class="wid100-Hidden">
            <table class="table table-show table-striped table-hover table-bordered table-filter" id="tbl-vendors">
            
                <thead>
                    <tr>
                        <th >@sortablelink('name', trans('general.name'))</th>
                        <th >@sortablelink('email', trans('general.email'))</th>
                        <th >@sortablelink('phone', trans('general.phone'))</th>
                        <th >@sortablelink('enabled', trans_choice('general.statuses', 1))</th>
                        <th >{{ trans('general.actions') }}</th>
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($vendors as $item)
                    <tr>
                        <td><a href="{{ url('expenses/vendors/' . $item->id . '/edit') }}">{{ $item->name }}</a></td>
                        <td class="hidden-xs">{{ !empty($item->vendor_email) ? $item->vendor_email : trans('general.na') }}</td>
                        <td>{{ $item->phone }}</td>
                        <td class="hidden-xs">
                            @if ($item->enabled)
                                <span class="label label-success">{{ trans('general.enabled') }}</span>
                            @else
                                <span class="label label-danger">{{ trans('general.disabled') }}</span>
                            @endif
                        </td>
                        <td>
                            <div class="pull-center">
                                <a href="{{url('/expenses/bills/vendor_expense')}}/{{$item->id}}">{{ trans('general.create_expense') }}</a>
                                
                            </div>
                        </td>
                        <td>
                            <div class="position-relative">
                                <div class="btn-group ">
                                    <div class="dropdown moreIcon" >
                                        <a  data-toggle="dropdown" class="dropdown-toggle"> <i class="material-icons"> more_horiz </i></a>
                                        <ul class="dropdown-menu dropdown-menu-right">
                                            <li><a href="{{url('/expenses/vendor_cheque')}}/{{$item->id}}">Write cheque</a></li>
                                            <li><a href="{{ url('expenses/vendors/' . $item->id . '/edit') }}">{{ trans('general.edit') }}</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                    </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <!-- /.box-body -->
    {{-- <div class="box-footer">
        @include('accounts.partials.admin.pagination', ['items' => $vendors, 'type' => 'vendors'])
    </div> --}}
</div>

@endsection

