@extends('layouts.default')

@section('title', trans('general.title.edit', ['type' => trans_choice('general.vendors', 1)]))
@section('new_button')
<a href="{{ url('expenses/vendors') }}" class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>{{ trans_choice('general.vendors', 1) . ' List' }} </a>

<a href="{{ url('expenses/vendors/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Vendors"><i class="material-icons left">add</i> {{ trans_choice('general.vendors', 2) }}</a>
@endsection
@section('content')
    <!-- Default box -->
    <div class="card">
        {!! Form::model($vendor, [
            'method' => 'PATCH',
            'files' => true,
            'url' => ['expenses/vendors', $vendor->id],
            'role' => 'form'
        ]) !!}

        <div class="row">
            <div class="col-md-3">
                {{ Form::textGroup('name', trans('general.name'), null, ['required'=>'required']) }}
            </div>
            <div class="col-md-3">
                {{ Form::textGroup('company',  'Vendor Company Name', null) }}
            </div>
            <div class="col-md-3">
                {{ Form::textGroup('vendor_email', trans('general.email'), null, ['required'=>'required']) }}
            </div>
            <div class="col-md-3">
                {{ Form::textGroup('cc_email', trans('general.ccemail'), null) }}
            </div>
            <div class="col-md-3"> 
                {{ Form::textGroup('phone', trans('general.phone'), null) }}
            </div>
            <div class="col-md-3">
                {{ Form::textGroup('mobile', trans('general.mobile'), null) }}
            </div>
            <div class="col-md-3">
                {{ Form::textGroup('website', trans('general.website'), null) }}
            </div>

            {{ Form::hidden('currency_code', setting('general.default_currency'), ['id' => 'currency_code']) }}

            <div class="col-lg-3 col-md-4 col-sm-6 required {{ $errors->has('net_term') ? 'has-error' : ''}}">
                <small>{{ trans_choice('general.net_term', 1) }}</small>
              
                    {!! Form::select('net_term', $terms, null, array_merge(['class' => 'selectpicker','data-live-search'=>'true','placeholder' => trans('general.form.select.field', ['field' => trans_choice('general.net_term', 1)])])) !!}
               
                {!! $errors->first('net_term', '<p class="help-block">:message</p>') !!}
            </div>



            {{ Form::textareaGroup('address', trans('general.billingaddress') ,null,['rows' => '3'],'col-md-6' )}}
            <!-- <label style="margin-left: 5px;  " for="same_as_billing">
                <input type="checkbox" {{ ($vendor->same_as_billing=='1') ? 'checked="checked" ' : '' }}  name="same_as_billing" id="same_as_billing" >Same as billing address 
            </label>  -->
            <div class="col-md-6">
                <div class="form-groupTextArea ">                        
                    {{ Form::textarea('shipping_address', null ,['class'=>'form-ControlTextArea' , 'id'=> 'shipping_address' ,'rows' => 3]) }}
                        <label class="form-label">Shipping Address</label>
                        <span class="form-controlBrd"></span>
                </div>
            </div>

            {{ Form::radioGroup('enabled', trans('general.status')) }}
        </div>
        <!-- /.box-body -->
        
        <div class="box-footer">
            {{ Form::saveButton('expenses/vendors') }}
        </div>
        <!-- /.box-footer -->
        {!! Form::close() !!}
    </div>
@endsection


@push('scripts')
    <script type="text/javascript">
        var text_yes = '{{ trans('general.yes') }}';
        var text_no = '{{ trans('general.no') }}';

        $(document).ready(function(){


        $(window).on("load", function(){
            if($('#same_as_billing').is(':checked') == true){
                $('#shipping_address').prop('disabled', true);
            }
        });


            /*$("#net_term").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('general.net_term', 1)]) }}"
            });*/

            $('#same_as_billing').change(function(){
                var c = this.checked;
                $('#shipping_address').prop('disabled', c);
                if(c){
                $('#shipping_address').val($('#address').val());
                }else{
                 $('#shipping_address').val('');
                }
            });
           

            @if($vendor->logo)
            logo_html  = '<span class="logo">';
            logo_html += '    <a href="{{ url('uploads/' . $vendor->logo->id . '/download') }}">';
            logo_html += '        <span id="download-logo" class="text-primary">';
            logo_html += '            <i class="fa fa-file-{{ $vendor->logo->aggregate_type }}-o"></i> {{ $vendor->logo->basename }}';
            logo_html += '        </span>';
            logo_html += '    </a>';
            logo_html += '    {!! Form::open(['id' => 'logo-' . $vendor->logo->id, 'method' => 'DELETE', 'url' => [url('uploads/' . $vendor->logo->id)], 'style' => 'display:inline']) !!}';
            logo_html += '    <a id="remove-logo" href="javascript:void();">';
            logo_html += '        <span class="text-danger"><i class="fa fa fa-times"></i></span>';
            logo_html += '    </a>';
            logo_html += '    {!! Form::close() !!}';
            logo_html += '</span>';

            $('.fancy-file .fake-file').append(logo_html);

            $(document).on('click', '#remove-logo', function (e) {
                confirmDelete("#logo-{!! $vendor->logo->id !!}", "{!! trans('general.attachment') !!}", "{!! trans('general.delete_confirm', ['name' => '<strong>' . $vendor->logo->basename . '</strong>', 'type' => strtolower(trans('general.attachment'))]) !!}", "{!! trans('general.cancel') !!}", "{!! trans('general.delete')  !!}");
            });
            @endif
        });
    </script>
@endpush
