@extends('layouts.default')
@section('title', trans('general.title.new', ['type' => trans_choice('general.vendors', 1)]))
@section('new_button')
<a href="{{ url('expenses/vendors') }}" class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>{{ trans_choice('general.vendors', 1) . ' List' }} </a>

@endsection
@section('content')
{{-- <button type="button" onclick="createNetTerm();" class="btn btn-primary">{{ trans('general.add_new') }}</button>  --}}   
    <!-- Default box -->
    <div class="card">
        {!! Form::open(['url' => 'expenses/vendors', 'files' => true, 'role' => 'form']) !!}

        <div class="row">
            <div class="col-md-3">
                {{ Form::textGroup('name', trans('general.name'), null, ['required'=>'required']) }}
            </div>
            <div class="col-md-3">
                {{ Form::textGroup('company',  'Vendor Company Name', null) }}
            </div>
            <div class="col-md-3">
                {{ Form::textGroup('vendor_email', trans('general.email'), null, ['required'=>'required']) }}
            </div>
            <div class="col-md-3">
                {{ Form::textGroup('cc_email', trans('general.ccemail'), null) }}
            </div>
            <div class="col-md-3"> 
                {{ Form::textGroup('phone', trans('general.phone'), null) }}
            </div>
            <div class="col-md-3">
                {{ Form::textGroup('mobile', trans('general.mobile'), null) }}
            </div>
            <div class="col-md-3">
                {{ Form::textGroup('website', trans('general.website'), null) }}
            </div>
            
            {{ Form::hidden('currency_code', setting('general.default_currency'), ['id' => 'currency_code']) }}
                
            <div class="col-lg-3 col-md-4 col-sm-6 required {{ $errors->has('net_term') ? 'has-error' : ''}}">
                <div class="row">
                    <div class="col-md-10 pr-0">
                        <div class="add-cust">
                        <small>{{ trans_choice('general.net_term', 1) }}</small>
                        {!! Form::select('net_term', $terms, setting('general.default_netterm'), array_merge(['class' => 'selectpicker','id'=>'net_term','data-live-search'=>'true','placeholder' => trans('general.form.select.field', ['field' => trans_choice('general.net_term', 1)])])) !!}
                        {!! $errors->first('net_term', '<p class="help-block">:message</p>') !!}
                        </div> 
                    </div> 
                    <div class="col-md-2 pl-0 pr-0">
                        <div class="add-bttn">
                         <button type="button" data-toggle="modal" data-target="#modal-create-term"   class="btn btn-xs btn-primary" data-original-title="Add"><i class="material-icons" style="font-size:14px;padding:0px;">add </i></button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                {{ Form::textareaGroup('address', trans('general.billingaddress'), null, ['rows' => '3'])}}
            </div>
            <div class="col-md-6">
                {{ Form::textareaGroup('shipping_address', 'Shipping Address', null, ['rows' => '3', 'id'=> 'shipping_address'])}}
            </div>

            <div class="col-md-3">
                {{ Form::radioGroup('enabled', trans('general.enabled')) }}
            </div>

        </div>
        <!-- /.box-body -->

        <div class="box-footer">
            {{ Form::saveButton('expenses/vendors') }}
        </div>
        <!-- /.box-footer -->

        {!! Form::close() !!}
    </div>
<!-- Create Net Term Model -->
<div class="modal fade" id="modal-create-term" >
  <div class="modal-dialog ">
      <div class="modal-content">
          <div class="modal-header">
              <h4 class="modal-title">{{ trans('general.title.new', ['type' => trans_choice('general.net_term', 1)]) }}</h4>
          </div>
          <div class="modal-body">
              {!! Form::open(['id' => 'form-create-term', 'role' => 'form']) !!}
              <div class="row">
                    <div class="col-md-6 "> 
                      <div class="form-group required">      
                            <input class="form-control" required name="name" type="text" id="name">
                            <label for="name" class="form-label">{{ trans('general.name') }}</label>
                            <span class="form-controlBrd"></span>
                      </div>
                    </div>
                    <div class="col-md-6 required">
                        <div class="form-group ">
                            <input class="form-control" required name="term_days" type="text" id="term_days"> 
                            <label for="name" class="form-label">Due in fixed number of days</label>
                            <span class="form-controlBrd"></span>
                        </div>
                    </div>
              </div>
              {!! Form::close() !!}
          </div>
          <div class="modal-footer">
              <div class="pull-left">
              <button type="button" id="close-modal-create-term" class="btn mr-3 btn-default waves-effect waves-gray" data-dismiss="modal"><span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</button>
              {!! Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'button', 'id' =>'button-create-term', 'class' => 'btn btn-primary waves-effect waves-light']) !!}
              </div>
          </div>
      </div>
  </div>
</div>
@endsection


@push('scripts')
    <script type="text/javascript">
        var text_yes = '{{ trans('general.yes') }}';
        var text_no = '{{ trans('general.no') }}';

        $(document).ready(function(){
            $('#enabled_1').prev().trigger('click');

/*
            $("#net_term").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('general.net_term', 1)]) }}"
            });*/

            $('#address').on('keyup',function(){
                if($('#same_as_billing').is(":checked")){
                    $('#shipping_address').val('');
                    $('#shipping_address').val($('#address').val());
                }
            });

            $('#same_as_billing').change(function(){
                var c = this.checked;
                $('#shipping_address').prop('disabled', c);
                if(c){
                $('#shipping_address').val($('#address').val());
                }else{
                 $('#shipping_address').val('');
                }
            });
          $('#name').focus();
   
        });
         $(document).on('click', '#button-create-term', function (e) {
            $('#modal-create-customer .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="{{ url('acs/custom/images/loader.gif') }}" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');

            $.ajax({
                url: '{{ url("/netterms/terms") }}',
                type: 'POST',
                dataType: 'JSON',
                data: $("#form-create-term").serialize(),
                beforeSend: function () {
                    $(".form-group").removeClass("has-error");
                    $(".help-block").remove();
                },
                success: function(data) {
                    $('#span-loader').remove();
                    $('#close-modal-create-term').trigger('click');
                    $("#net_term").append('<option value="' + data.id + '" selected="selected">' + data.name + '</option>');
                    $("#net_term").selectpicker('refresh');
                },
                error: function(error, textStatus, errorThrown) {
                    $('#span-loader').remove();

                    if (error.responseJSON.name) {
                        $("input[name='name']").parent().parent().addClass('has-error');
                        $("input[name='name']").parent().after('<p class="help-block">' + error.responseJSON.name + '</p>');
                    }

                    if (error.responseJSON.term_days) {
                        $("input[name='term_days']").parent().parent().addClass('has-error');
                        $("input[name='term_days']").parent().after('<p class="help-block">' + error.responseJSON.term_days + '</p>');
                    }
                    
                }
            });
        });
    </script>
@endpush
