@extends('layouts.default')
@section('title',trans('customers.bill_center'))
@section('content')
<!-- Default box -->
<div class="">
   <div class="pmd-tabs pmd-tabs-bg horizantTabs">
      <ul class="nav nav-tabs secondarySubMeu inner-submenu" id="myTab">
         <li class="nav-item"><a href="#overdue" class="nav-link waves-effect waves-gray active" data-toggle="tab" aria-expanded="true">Over Due</a></li>
         <li class="nav-item"><a href="#almostdue" class="nav-link waves-effect waves-gray" data-toggle="tab" aria-expanded="false">Almost Due</a></li>
      </ul>
      <div class="pmd-card-body horizantTabsBodyContainer">
         <div class="tab-content">
            <div class="row">
               <div class="col-lg-10 col-md-10 col-sm-10">
                  <div class="row">
                     <div class="col-lg-6 col-md-6 col-sm-6">
                        <form action="{{ url('/expenses/vendors/billcenter') }}" id="changeForm">
                           {{ Form::textGroup('almost_due_at', 'Due Date', Date::now()->format('Y-m-d'), ['id'=>'almost_due_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'', 'required' => 'required','onchange'=>'$("#changeForm").submit()']) }}
                        </form>
                     </div>
                  </div>
               </div>
               <div class="col-lg-2 col-md-2 col-sm-2"><a href="#"><strong>Send Email</strong></a></div>
            </div>
            <div class="tab-pane tab-margin active" id="overdue">
               @foreach($vendors as $k => $vendor)
               @if(!($vendor->bills->isEmpty()))
               <div class="col-lg-10 col-md-10 col-sm-10 col-xs-10">
                  <div class="box box-success">
                     <div class="box-body" >
                        <div class="row">
                           <div class="col-lg-4 col-md-4 col-sm-4 col-xs-4"><strong>Vendor Name</strong></div>
                           <div class="col-lg-2 col-md-2 col-sm-2 col-xs-2"><strong>Balance </strong></div>
                           <div class="col-lg-2 col-md-2 col-sm-2 col-xs-2"><strong>Days Over Due</strong></div>
                           <div class="col-lg-2 col-md-2 col-sm-2 col-xs-2"><strong>PHONE</strong></div>
                           <div class="col-lg-2 col-md-2 col-sm-2 col-xs-2"><strong>Notes/Warnings</strong></div>
                        </div>
                        <div class="row">
                           <div class="col-lg-4 col-md-4 col-sm-4 col-xs-4" style="margin-top:10px; color:#0c6dff;">{{ $vendor->name }}</div>
                           <div class="col-lg-2 col-md-2 col-sm-2 col-xs-2" id="balance_amount" style="color: red">
                           </div>
                           <div class="col-lg-2 col-md-2 col-sm-2 col-xs-2">
                           </div>
                           <div class="col-lg-2 col-md-2 col-sm-2 col-xs-2">
                           </div>
                           <div class="col-lg-2 col-md-2 col-sm-2 col-xs-2" align="center" style="cursor: pointer;"> <a href="#"><i class="fa fa-envelope"></i></a> / <a href="#"><i class="fa fa-book"></i></a>
                           </div>
                        </div>
                        @foreach ($vendor->bills as $bill)
                        @php
                        $from_date = Carbon\Carbon::parse($bill->due_at);
                        $to_date = Carbon\Carbon::now();
                        $overDueDays = $from_date->diffInDays($to_date);
                        $paid_payment =	App\Models\Accounts\Expense\Bill::with('payments_total')->where('id',$bill->id)->first();
                        if (!($paid_payment->payments_total->isEmpty())){ 
                        $balance_payment = $bill->amount - $paid_payment->payments_total[0]->paid_amount;
                        }else{
                        $balance_payment = $bill->amount;
                        }
                        @endphp
                        <div class="row " style="margin-top:10px; ">
                           <div class="col-lg-4 col-md-4 col-sm-4">Bill #{{ $bill->bill_number }}
                           </div>
                           <div class="col-lg-2 col-md-2 col-sm-2" id="bill_amount">@money($balance_payment,'USD',true)  </div>
                           <div class="col-lg-2 col-md-2 col-sm-2" >{{ $overDueDays }}
                           </div>
                           <div class="col-lg-2 col-md-2 col-sm-2">{{ isset($bill->vendor_phone)?$bill->vendor_phone:'' }}
                           </div>
                           <div class="col-lg-2 col-md-2 col-sm-2">
                           </div>
                        </div>
                        @endforeach
                     </div>
                  </div>
               </div>
               <div class="col-lg-2 col-md-2 col-sm-2">
               </div>
               @endif
               @endforeach
            </div>
            <div class="tab-pane tab-margin" id="almostdue">
               @foreach($vendors_almostdue as $k => $vendor)
               @if(!($vendor->bills->isEmpty()))
               <div class="row">
                  <div class="col-lg-10 col-md-10 col-sm-10">
                     <div class="box box-success">
                        <div class="box-body">
                           <div class="row" style="margin:0px">
                              <div class="col-lg-4 col-md-4 col-sm-4">{{ $vendor->name }}
                              </div>
                              <div class="col-lg-2 col-md-2 col-sm-2" id="balance_amount" style="color: red">
                              </div>
                              <div class="col-lg-2 col-md-2 col-sm-2">
                              </div>
                              <div class="col-lg-2 col-md-2 col-sm-2">
                              </div>
                              <div class="col-lg-2 col-md-2 col-sm-2" align="center" style="cursor: pointer;"> <a href="#"><i class="fa fa-envelope"></i></a> / <a href="#"><i class="fa fa-book"></i></a>
                              </div>
                           </div>
                        </div>
                        @foreach ($vendor->bills as $bill)
                        @php
                        $from_date = Carbon::parse($bill->due_at);
                        $tenth = strtotime("+10 day");
                        $tenthday =  date('Y-m-d',$tenth);
                        $tenthday = Carbon::parse($tenthday);
                        $overDueDays = $from_date->diffInDays($tenthday);
                        $paid_payment =	App\Models\Accounts\Expense\Bill::with('payments_total')->where('id',$bill->id)->first();
                        if (!($paid_payment->payments_total->isEmpty())){ 
                        $balance_payment = $bill->amount - $paid_payment->payments_total[0]->paid_amount;
                        }else{
                        $balance_payment = $bill->amount;
                        }
                        @endphp
                        <div class="row " style="margin-top:10px; ">
                           <div class="col-lg-4 col-md-4 col-sm-4">Bill #{{ $bill->bill_number }}
                           </div>
                           <div class="col-lg-2 col-md-2 col-sm-2" id="bill_amount"> {{ $balance_payment }} </div>
                           <div class="col-lg-2 col-md-2 col-sm-2" >{{ $overDueDays }}
                           </div>
                           <div class="col-lg-2 col-md-2 col-sm-2">{{ isset($bill->vendor_phone)?$bill->vendor_phone:'' }}
                           </div>
                           <div class="col-lg-2 col-md-2 col-sm-2">
                           </div>
                        </div>
                        @endforeach
                     </div>
                  </div>
                  <div class="col-lg-2 col-md-2 col-sm-2">
                  </div>
               </div>
               @endif
               @endforeach
            </div>
         </div>
      </div>
   </div>
</div>

@include('includes.datepicker')
<script>
   $(document).ready(function() {      
      var today = new Date();

      $('#almost_due_at').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
      $('#almost_due_at').datepicker({
         format: 'yyyy-mm-dd',
         todayHighlight: true,
         clearBtn: true,
         endDate: today
      });   
   });
   
</script>
@endsection