@extends('layouts.default')
@section('header-links')
    @include('accounts.expenses.header')
@endsection
@section('title', trans_choice('general.payments', 2))


@section('new_button')
<div class="searchBox mr-2">
   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => trans('general.search_placeholder')]) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
<a href="{{ url('expenses/payments/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Payments"><i class="material-icons left">add</i>{{ trans_choice('general.payments', 2) }}</a>

{{-- <span class="new-button"><a  class="btn btn-success btn-sm"><span class="fa fa-plus"></span> &nbsp;</a></span> --}}

@endsection

@section('content')
<!-- Default box -->
<div class="box box-success">
   
    <div class="">
        <div class="">
            <table class="table table-show table-striped table-hover table-bordered table-filter" id="tbl-payments">
              
                <thead>
                    <tr>
                        <th >@sortablelink('paid_at', trans('general.date'))</th>
                        <th >@sortablelink('amount', trans('general.amount'))</th>
                        <th >@sortablelink('vendor.name', trans_choice('general.vendors', 1))</th>
                        <th >@sortablelink('account.name', trans_choice('general.accounts', 1))</th>
                        <th >{{ trans('general.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($payments as $item)
                    <tr>
                        <td><a href="{{ url('expenses/payments/' . $item->id . '/edit') }}">{{ Date::parse($item->paid_at)->format($date_format) }}</a></td>
                        <td>@money($item->amount, $item->currency_code, true)</td>
                        <td class="hidden-xs">{{ !empty($item->vendor->name) ? $item->vendor->name : trans('general.na') }}</td>
                        <td class="hidden-xs">{{ $item->account->name_number }}</td>
                        <td class="">
                             <a  class="btn btn-outline-info btn-circle-iconic btn34" href="{{ url('expenses/payments/' . $item->id . '/edit') }}"><i class="material-icons">create</i></a>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <!-- /.box-body -->

    {{-- <div class="box-footer">
        @include('accounts.partials.admin.pagination', ['items' => $payments, 'type' => 'payments'])
    </div> --}}
    <!-- /.box-footer -->
</div>

@endsection

