@extends('layouts.default')

@section('title', trans('general.title.edit', ['type' => trans_choice('general.payments', 1)]))
@section('new_button')
<a href="{{ url('expenses/payments') }}"
    class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>{{ trans_choice('general.payments', 2) }}</a>
<a href="{{ url('expenses/payments/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Payments"><i class="material-icons left">add</i>{{ trans_choice('general.payments', 2) }}</a>

@endsection
@section('content')
    <!-- Default box -->
    <div class="card">
        {!! Form::model($payment, [
            'method' => 'PATCH',
            'files' => true,
            'url' => ['expenses/payments', $payment->id],
            'role' => 'form'
        ]) !!}

        <div class="row">
            <div class="col-md-3">
                {{ Form::textGroup('paid_at', trans('general.date'), Date::parse($payment->paid_at)->format('Y-m-d'), ['id' => 'paid_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'']) }}
                {!! Form::hidden('company_id', 1 , ['id' => 'company_id']) !!} 
            </div>
            <div class="col-md-3">
                {{ Form::textGroup('amount', trans('general.amount'), null, ['id'=>'amount','required' => 'required', 'autofocus' => 'autofocus', 'data-decimals'=>"0"]) }}
            </div>
            <div class="col-md-3">
                {{ Form::selectGroup('account_id', trans_choice('general.accounts', 1), $accounts, setting('general.default_account'), ['data-live-search'=>'true']) }}
            </div>

            {{ Form::hidden('currency_code', 'USD' , ['id' => 'currency_code']) }} 

            {{-- {{ Form::selectGroup('category_id', trans_choice('general.categories', 1), $categories, null, []) }} --}}

            <div class="col-md-3">
                {{ Form::selectGroup('vendor_id', trans_choice('general.vendors', 1), $vendors, null, []) }}
            </div>
            <div class="col-md-3">
                {{ Form::selectGroup('payment_method', trans_choice('general.payment_methods', 1), $payment_methods, null, []) }}
            </div>
            <div class="col-md-3">
                {{ Form::textGroup('reference', trans('general.reference'), 'file-text-o',[]) }}
            </div>
            <div class="col-md-3">
                {{ Form::fileGroup('attachment', trans('general.attachment')) }}
            </div>
            <div class="col-md-6">
                {{ Form::textareaGroup('description', trans('general.description')) }}
            </div>            
        </div>
        <!-- /.box-body -->

        <div class="box-footer">
            {{ Form::saveButton('expenses/payments') }}
        </div>
        <!-- /.box-footer -->
    </div>
    {!! Form::close() !!}

@include('includes.datepicker')
<script type="text/javascript">
    $(document).ready(function(){
        var today = new Date();
        //Date picker
        $('#paid_at').inputmask('MM-DD-YYYY', { placeholder: 'MM-DD-YYYY' });
        $('#paid_at').datepicker({
            format: '{{ $date_format }}',
            autoclose: true
        });

        /*$("#account_id").select2({
            placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('general.accounts', 1)]) }}"
        });

        $("#category_id").select2({
            placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('general.categories', 1)]) }}"
        });

        $("#vendor_id").select2({
            placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('general.vendors', 1)]) }}"
        });

        $("#payment_method").select2({
            placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('general.payment_methods', 1)]) }}"
        });*/

      
        @if($payment->attachment)
            attachment_html  = '<span class="attachment">';
            attachment_html += '    <a href="{{ url('uploads/' . $payment->attachment->id . '/download') }}">';
            attachment_html += '        <span id="download-attachment" class="text-primary">';
            attachment_html += '            <i class="fa fa-file-{{ $payment->attachment->aggregate_type }}-o"></i> {{ $payment->attachment->basename }}';
            attachment_html += '        </span>';
            attachment_html += '    </a>';
            attachment_html += '    {!! Form::open(['id' => 'attachment-' . $payment->attachment->id, 'method' => 'DELETE', 'url' => [url('uploads/' . $payment->attachment->id)], 'style' => 'display:inline']) !!}';
            attachment_html += '    <a id="remove-attachment" href="javascript:void();">';
            attachment_html += '        <span class="text-danger"><i class="fa fa fa-times"></i></span>';
            attachment_html += '    </a>';
            attachment_html += '    {!! Form::close() !!}';
            attachment_html += '</span>';

            $('.fancy-file .fake-file').append(attachment_html);

            $(document).on('click', '#remove-attachment', function (e) {
                confirmDelete("#attachment-{!! $payment->attachment->id !!}", "{!! trans('general.attachment') !!}", "{!! trans('general.delete_confirm', ['name' => '<strong>' . $payment->attachment->basename . '</strong>', 'type' => strtolower(trans('general.attachment'))]) !!}", "{!! trans('general.cancel') !!}", "{!! trans('general.delete')  !!}");
            });
        @endif

        $(document).on('change', '#account_id', function (e) {
            $.ajax({
                url: '{{ url("settings/currencies/currency") }}',
                type: 'GET',
                dataType: 'JSON',
                data: 'account_id=' + $(this).val(),
                success: function(data) {
                    $('#currency').val(data.currency_name);
                    $('#currency_code').val(data.currency_code);
                }
            });
        });
    });
</script>
@endsection
