@extends('layouts.default')
@section('header-links')
    @include('accounts.expenses.header')
@endsection
@section('title', trans_choice('general.debitmemo', 2))

@section('new_button')
<div class="searchBox mr-2">
   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => trans('general.search_placeholder')]) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
<a  href="{{ url('expenses/debitmemo/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"  data-toggle="tooltip" title="Create Debitmemo"><i class="material-icons left">add</i>{{trans_choice('general.debitmemo', 2)}}</a>

@endsection

@section('content')
<!-- Default box -->
<div class="box box-success">
  
    <div class="">
        <div class="">
            <table class="table table-show table-striped table-hover table-bordered table-filter" id="tbl-items">
               
                <thead>
                    <tr>
                        <th>{{  trans_choice('general.vendors',1) }}</th>
                        <th>{{  trans('general.date') }}</th>
                        <th>{{  trans_choice('general.totals',1) }}</th>
                        <th>{{  trans('general.status') }}</th>
                        <th>{{  trans('general.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                  @foreach($debitmemo as $debit)
          				<tr>
          					<td>{{ $debit->vendor_name }}</td>
                    <td>{{ Date::parse($debit->debitmemo_at)->format($date_format) }}</td>
                    <td>@money($debit->total,'USD',true)</td>
                    <td>
                      <span class="badge badge-success">{{ ucwords($debit->status) }}</span>
                    </td>
                    <td>
                         {{-- <a  class="btn btn-outline-info btn-circle-iconic btn34" href="#"><i class="material-icons">create</i></a> --}}

                          <a class="btn btn-outline-info btn-circle-iconic btn34" href="{{url('expenses/debitmemo/'.$debit->id)}}"><i class="material-icons"> remove_red_eye </i></a>
                    </td>
          				</tr>
                  @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <!-- /.box-body -->

     <div class="box-footer">
    </div> 
       
    <!-- /.box-footer -->
</div>

@endsection