@extends('layouts.default')

@section('title', trans('general.title.new', ['type' => trans_choice('general.creditmemo', 1)]))
@section('new_button')
<a href="{{ url('/expenses/debitmemo') }}" class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>{{trans_choice('general.debitmemo', 1) .' List' }} </a>

{{-- <a href="{{ url('/incomes/creditmemo') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">remove_red_eye</i>show</a> --}}

<a  href="{{ url('expenses/debitmemo/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Debitmemo"><i class="material-icons left">add</i>{{trans_choice('general.debitmemo', 2)}}</a>
@endsection
@section('content')

<!-- Default box -->
{!! Form::open(['url' => 'incomes/invoices', 'files' => true, 'role' => 'form']) !!}
    <div class="card">

         <div class="row">

            <div class="col-lg-3 col-md-4 col-sm-4 {{ $errors->has('customer_id') ? 'has-error' : ''}}">
                <small>{{ trans_choice('general.vendors', 1) }}</small>
                {!! Form::select('vendor_id', $vendors, null, array_merge(['id' => 'vendor_id', 'class' => 'selectpicker','data-live-search'=>'true', 'placeholder' => trans('general.form.select.field', ['field' => trans_choice('general.vendors', 1)])])) !!}    
                {!! $errors->first('customer_id', '<p class="help-block">:message</p>') !!}
            </div> 

            

            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="form-group">
                        <input class="form-control"  name="vendor_email" id="vendor_email" type="text">
                        <label for="vendor_email" class="form-label">Email</label>
                        <span class="form-controlBrd"></span>
                    <div class="help-block">
                        <div class="custom-controls-stacked d-block" style="position: absolute; top: 50px;left: 0;">
                            <label class="custom-control overflow-checkbox" >
                            <input type="checkbox" name="sendlater" id="sendlater" value="1" class="overflow-control-input">
                            <span class="overflow-control-indicator" style="top:2px;"></span> <span class="overflow-control-description"> Send Later</span></label>
                        </div> 
                    </div>
                </div>
            </div>

            {!! Form::hidden('currency_code', setting('general.default_currency') , ['id' => 'currency_code']) !!}
            {{ Form::textGroup('debitmemo_at', 'Debit Memo Date', 'calendar',['id' => 'debitmemo_at', 'class' => 'form-control', 'required' => 'required', 'data-inputmask' => '\'alias\': \'mm-dd-yyyy\'', 'data-mask' => '' ], Date::now()->format($date_format) ) }}
        
        </div>
        <div class="row">

            <div class="col-lg-6 col-md-6 col-sm-6">
                <div class="form-groupTextArea">
                    <textarea class="form-ControlTextArea"  rows="3" name="address" cols="50" id="address"></textarea>
                    <label for="address" class="form-label">{{trans('general.billingaddress')}}</label>
                    <span class="form-controlBrd"></span>
                </div>
            </div>

        </div>
    </div>    
    <div class=" ">
         <h3 class="btn btn-info btn-Rcircle-iconic waves-effect waves-light mb-3">Items</h3>
        <div class="">
            <table class="table table-bordered tabl-input" id="items">
                <thead>
                    <tr class="text-left" style="background-color: #f9f9f9;">
                        <th width="5%" >{{ trans('general.actions') }}</th>
                        <th width="40%" >{{ trans('general.name') }}</th>
                        <th width="15%" class="text-center">{{ trans('invoices.quantity') }}</th>
                        <th width="25%" class="text-center">{{ trans('invoices.price') }}</th>
                    
                        <th width="15%" class="text-center">{{ trans('invoices.total') }}</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $item_row = 0; ?>
                    <tr id="item-row-{{ $item_row }}">
                        <td class="text-center" style="vertical-align: middle;">
                            <button type="button" onclick="$('#item-row-{{ $item_row }}').remove(); totalItem();" data-toggle="tooltip" title="{{ trans('general.delete') }}" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete </i></button>
                        </td>
                       <td class="text-center" style="vertical-align: middle;">
                           <select onchange="autoItem({{ $item_row }})" id="item-id-{{ $item_row }}" required="required" class="selectpicker" name="item[{{ $item_row }}][item_id]"  data-live-search="true" >
                                @include('accounts.common.subitem',['name' => trans('general.form.select.field', ['field' => trans_choice('general.items', 1)]) ])
                            </select>
                            <input class="form-control"   name="item[{{ $item_row }}][name]" type="hidden" id="item-name-{{ $item_row }}">
                            
                            
                            <input class="form-control"   name="item[{{ $item_row }}][chartid]" type="hidden" id="item-chartid-{{ $item_row }}">
                        </td>
                       <td>
                            <div class="form-group">
                                <input class="form-control text-left" required="required" name="item[{{ $item_row }}][quantity]" type="text" id="item-quantity-{{ $item_row }}">
                                <label class="form-label">Quantity</label>
                                <span class="form-controlBrd"></span>
                            </div>
                        </td>
                        <td>
                            <div class="form-group">
                                <input class="form-control text-left" required="required" name="item[{{ $item_row }}][price]" type="text" id="item-price-{{ $item_row }}">
                                <label class="form-label">Price</label>
                                <span class="form-controlBrd"></span>
                            </div>
                        </td>
                        <td class="text-center" style="vertical-align: middle;">
                            <span id="item-total-{{ $item_row }}">0</span>
                        </td>
                    </tr>
                    <?php $item_row++; ?>
                    <tr id="addItem">
                        <td class="text-center"><button type="button" onclick="addItem();" data-toggle="tooltip" title="{{ trans('general.add') }}" class="btn btn-xs  btn-outline-primary btn-circle-iconic btn34" data-original-title="{{ trans('general.add') }}"><i class="material-icons">add </i></button></td>
                        <td class="text-right" colspan="4"></td>
                    </tr>
                    <tr>
                        <td class="text-right" colspan="4"><strong>{{ trans('invoices.sub_total') }}</strong></td>
                        <td class="text-right"><span id="sub-total">0</span></td>
                    </tr>
                    <tr>
                        <td class="text-right" colspan="4"><strong>{{ trans('invoices.total') }}</strong></td>
                        <td class="text-right"><span id="grand-total">0</span></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

 

    {{ Form::fileGroup('attachment', trans('general.attachment')) }} 

    {{ Form::saveButtons('incomes/invoices') }}
   <div class="row">
        <div class="col-lg-6 col-md-6 col-sm-6 mt-2">
          {{ Form::textareaGroup('notes', trans_choice('general.notes', 2)) }}
      </div>

    <div class="col-lg-6 col-md-6 col-sm-6 mrg-top-5">
       
      {{ Form::saveButtons('expenses/debitmemo') }}
    </div>
</div>
    <!-- /.box-footer -->
{!! Form::close() !!}
@endsection
@push('scripts')

    <script type="text/javascript">

        var item_row = '{{ $item_row }}';

        
        function addItem() {
            html  = '<tr id="item-row-' + item_row + '">';
            html += '  <td class="text-center" style="vertical-align: middle;">';
            html += '      <button type="button" onclick="$(\'#item-row-' + item_row + '\').remove(); totalItem();" data-toggle="tooltip" title="{{ trans('general.delete') }}" class="btn btn-xs btn-danger"><i class="material-icons">delete </i></button>';
            html += '  </td>';

            html += '  <td>';
            html += '<select class="selectpicker" onchange="autoItem('+ item_row +')" name="item[' + item_row + '][item_id]" required="required" id="item-id-' + item_row + '"  data-live-search="true">';
            html += $('#item-id-0').html();
            html += '</select>';
            html += '<input class="form-control"  name="item['+ item_row +'][name]"        type="hidden" id="item-name-'+ item_row + '">';
            html += '<input class="form-control"   name="item['+ item_row +'][chartid]" type="hidden" id="item-chartid-'+item_row +'">';
            html += '  </td>';

            html += '  <td>';
            html += ' <div class="form-group"><input class="form-control text-left" required="required" name="item[' + item_row + '][quantity]" type="text" id="item-quantity-' + item_row + '"><label class="form-label">Quantity</label> <span class="form-controlBrd"></span></div>';
            html += '  </td>';
            html += '  <td>';
            html += '<div class="form-group"><input class="form-control text-left" required="required" name="item[' + item_row + '][price]" type="text" id="item-price-' + item_row + '"><label class="form-label">Price</label> <span class="form-controlBrd"></span></div>';
            html += '  </td>';
            html += '  <td class="text-center" style="vertical-align: middle;">';
            html += '      <span id="item-total-' + item_row + '">0</span>';
            html += '  </td></tr>';

            $('#items tbody #addItem').before(html);

            $('#item-id-'+ item_row).selectpicker('refresh');

            item_row++;
        }
        var autocomplete_path = "{{ url('items/items/autocompletebill') }}";
        function autoItem (id){
            var item_id = $("#item-id-"+id).val();
            
            $.ajax({
                url: autocomplete_path,
                type: 'GET',
                dataType: 'JSON',
                data: 'query=' + item_id + '&type=invoice&currency_code=' + $('#currency_code').val(),
                success: function(data) {
                 
                    $('#item-name-'+id).val(data.name);
                    $('#item-quantity-' + id).val('1');
                    $('#item-price-' + id).val(data.sale_price);
                    $('#item-chartid-' +id).val(data.income_account);
                    $('#item-total-' + id).html(data.total);
                    totalItem();
                    
                }
            });
        }
        function totalItem() {
            $.ajax({
                url: '{{ url("items/items/totalItem") }}',
                type: 'POST',
                dataType: 'JSON',
                data: $('#currency_code, #items input[type=\'text\'],#items input[type=\'hidden\'], #items textarea, #items select,#account input[type=\'text\'],#account input[type=\'hidden\'], #account textarea, #account select'),
                headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
                success: function(data) {
                    if (data) {
                        $.each( data.items, function( key, value ) {
                            $('#item-total-' + key).html(value);
                        });

                        $('#sub-total').html(data.sub_total);
                        $('#grand-total').html(data.grand_total);
                    }
                }
            });
        }
       
        $(document).ready(function(){
             //Date picker
             $('#debitmemo_at').inputmask('MM-DD-YYYY', { placeholder: 'MM-DD-YYYY' });
            $('#creditmemo_at').datepicker({
                format: '{{ $date_format }}',
                autoclose: true
            });

             $(document).on('keyup', '#items tbody .form-control', function(){
                totalItem();
            });
        });

        function VendorAjax(val){
            $.ajax({
                type: 'GET',
                dataType: 'JSON',
                data: 'vendor_id=' + val,
                url : '{{ url('expenses/vendors/autocompletevendor') }}',
                success:function(data){
                   $('#vendor_email').val(data.vendor_email).addClass('has-value');
                   $('#address').val(data.address).addClass('has-value');
                },
                error:function(error){
                    console.log(error);
                }
            });
        }
	</script>
@endpush()