@extends('layouts.default')

@section('title', trans('general.title.new', ['type' => trans_choice('general.debitmemo', 1)]))
@section('new_button')
<a href="{{ url('/expenses/debitmemo') }}" class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>{{trans_choice('general.debitmemo', 1) .' List' }} </a>

@endsection
@section('content')

<!-- Default box -->
{!! Form::open(['url' => 'expenses/debitmemo', 'files' => true, 'role' => 'form', 'id'=>'debitMemo']) !!}
    <div class="card">

        <div class="row">

            <div class="col-lg-3 col-md-4 col-sm-4 {{ $errors->has('customer_id') ? 'has-error' : ''}}">
                <small>{{ trans_choice('general.vendors', 1) }}</small>
                {!! Form::select('vendor_id', $vendors, null, array_merge(['id' => 'vendor_id', 'class' => 'selectpicker','data-live-search'=>'true', 'placeholder' => trans('general.form.select.field', ['field' => trans_choice('general.vendors', 1)])])) !!}    
                {!! $errors->first('customer_id', '<p class="help-block">:message</p>') !!}
            </div> 
            
            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="form-group">
                        <input class="form-control"  name="vendor_email" id="vendor_email" type="text">
                        <label for="vendor_email" class="form-label">Email</label>
                        <span class="form-controlBrd"></span>
                    <div class="help-block">
                        <div class="custom-controls-stacked d-block" style="position: absolute; top: 50px;left: 0;">
                            <label class="custom-control overflow-checkbox" >
                            <input type="checkbox" name="sendlater" id="sendlater" value="1" class="overflow-control-input">
                            <span class="overflow-control-indicator" style="top:2px;"></span> <span class="overflow-control-description"> Send Later</span></label>
                        </div> 
                    </div>
                </div>
            </div>

            {!! Form::hidden('currency_code', setting('general.default_currency') , ['id' => 'currency_code']) !!}

            <div class="col-md-3">
                {{ Form::textGroup('debitmemo_at', 'Debit Memo Date', Date::now()->format('Y-m-d'), ['id' => 'debitmemo_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'']) }}
            </div>
        </div>
        <div class="row">
            <div class="col-lg-6 col-md-6 col-sm-6">
                <div class="form-groupTextArea">
                    <textarea class="form-ControlTextArea"  rows="3" name="address" cols="50" id="address"></textarea>
                    <label for="address" class="form-label">{{trans('general.billingaddress')}}</label>
                    <span class="form-controlBrd"></span>
                </div>
            </div>
        </div>
    </div>
    <div class=" ">
       <h3>Items</h3>
        <div class=" ">
            <table class="table table-bordered tabl-input" id="items">                
                <thead>
                    <tr style="background-color: #f9f9f9;">
                        <th width="5%">{{ trans('general.actions') }}</th>
                        <th width="30%">{{ trans('general.account') }}</th>
                        <th width="30%">{{ trans('general.description') }}</th>
                        <th width="20%">{{ trans('invoices.price') }}</th>
                        <th width="20%">{{ trans('invoices.total') }}</th>
                    </tr>
                </thead>
                <tbody>
                     
                    <?php $item_row = 0; ?>
                    <tr id="item-row-{{ $item_row }}">
                        <td style="vertical-align: middle;">
                            <button type="button" onclick="$('#item-row-{{ $item_row }}').remove(); totalItem();" data-toggle="tooltip" title="{{ trans('general.delete') }}" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete </i></button>
                        </td>
                       <td style="vertical-align: middle;">
                           <select  id="item-id-{{ $item_row }}" required="required" class="selectpicker" name="item[{{ $item_row }}][chartid]"  data-live-search="true"  onchange="addChartofAccount(event)">
                               {!! Cache::get('account_details_option') !!}
                            </select>
                        </td>
                       <td>
                            <div class="form-group">
                                <input class="form-control text-left" required="required" name="item[{{ $item_row }}][description]" type="text" id="item-description-{{ $item_row }}">
                                <label class="form-label">{{  trans('general.description') }} </label>
                                <span class="form-controlBrd"></span>
                            </div>
                        </td>
                        <td>
                            <div class="form-group">
                            <input class="form-control price"  required="required" name="item[{{ $item_row }}][price]" type="text" id="item-price-{{ $item_row }}">
                           <label class="form-label">Price</label>
                                <span class="form-controlBrd"></span>
                        </div>
                        </td>
                        <td class="" style="vertical-align: middle;">
                            <span id="item-total-{{ $item_row }}">0</span>
                        </td>
                    </tr>
                    <?php $item_row++; ?>
                    <tr id="addItem">
                        <td><button type="button" onclick="addItem();" data-toggle="tooltip" title="{{ trans('general.add') }}" class="btn btn-xs  btn-outline-info btn-circle-iconic btn34" data-original-title="{{ trans('general.add') }}"><i class="material-icons">add </i></button></td>
                        <td class="text-right" colspan="4"></td>
                    </tr>
                    <tr>
                        <td class="text-right" colspan="4"><strong>{{ trans('invoices.sub_total') }}</strong></td>
                        <td><span id="sub-total">0</span></td>
                    </tr>
                    <tr>
                        <td class="text-right"  colspan="4"><strong>{{ trans('invoices.total') }}</strong></td>
                        <td><span id="grand-total">0</span></td>
                        {{ Form::hidden('total_grand', null, ['id'=>'grand-total-input']) }}
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <div id="bills_list"></div>  

    <div class="col-md-8">
        {{ Form::fileGroup('attachment', trans('general.attachment')) }} 
    </div>
   
<div class="row">
        <div class="col-lg-6 col-md-6 col-sm-6 mt-2">
          {{ Form::textareaGroup('notes', trans_choice('general.notes', 2)) }}
      </div>

    <div class="col-lg-6 col-md-6 col-sm-6 mrg-top-5">
       
      {{ Form::saveButton('expenses/debitmemo') }}
    </div>
</div>
    <!-- /.box-footer -->
{!! Form::close() !!}


 @include('accounts/common/models/chartofaccount')
 @include('includes.datepicker')

<script  src="{{asset('accounts/chartofaccounts/accounting.js')}}">  </script>
<script type="text/javascript">
var today = new Date();
    $(document).on('#debitMemo submit',function(){
        var price = $("#grand-total-input").val();
        var total = parseInt(price.substring(1, price.length));
        var bill_price = 0;

        $('.bill_price').each(function(){
            bill_price += parseInt($(this).val() || 0);
        });

        if(total === bill_price){
            return true;
        }else{
            return false;
        }
    });

        var item_row = '{{ $item_row }}';

        $(document).ready(function(){
             //Date picker
            $('#debitmemo_at').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
            $('#debitmemo_at').datepicker({
                format: 'yyyy-mm-dd',
                todayHighlight: true,
                clearBtn: true,
                endDate: today
            });

            $(document).on('keyup', '#items tbody .form-control', function(){
                totalItem();
            });

            $('#vendor_id').on('change',function(){
                var val = $(this).val();
                getBills(val);
                VendorAjax(val);
            });
        });

        function getBills(id){
            $('#bills_list').html('');
            $.ajax({
                url:'{{ url('expenses/debitmemo/getbills') }}'+'/'+id,
                success:function(data){
                    $('#bills_list').html(data);
                },error:function(){
                    console.log('ERROR 404');
                }
            });
        }

        
        function addItem() {
            html  = '<tr id="item-row-' + item_row + '">';
            html += '  <td style="vertical-align: middle;">';
            html += '      <button type="button" onclick="$(\'#item-row-' + item_row + '\').remove(); totalItem();" data-toggle="tooltip" title="{{ trans('general.delete') }}" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete </i></button>';
            html += '  </td>';

            html += '  <td>';
            html += '<select class="selectpicker" name="item[' + item_row + '][chartid]" required="required" id="item-id-' + item_row + '"  data-live-search="true" onchange="addChartofAccount(event)>';
            html += $('#item-id-0').html();
            html += '</select>';           
            html += '  </td>';

            html += '  <td>';
            html += ' <div class="form-group"><input class="form-control text-left" required="required" name="item[' + item_row + '][description]" type="text" id="item-description-'+ item_row +'"> <label class="form-label">{{  trans('general.description') }} </label> <span class="form-controlBrd"></span></div>';
            html += '  </td>';
            html += '  <td>';
            html += '<div class="form-group"><input class="form-control text-left" required="required" name="item[' + item_row + '][price]" type="text" id="item-price-' + item_row + '"><label class="form-label">Price</label> <span class="form-controlBrd"></span></div>';
            html += '  </td>';
            html += '  <td style="vertical-align: middle;">';
            html += '      <span id="item-total-' + item_row + '">0</span>';
            html += '  </td></tr>';

            $('#items tbody #addItem').before(html);

            $('#item-id-'+ item_row).selectpicker('refresh');

            item_row++;
        }
        
        function totalItem() {
            $.ajax({
                url: '{{ url("items/items/totalDeposite") }}',
                type: 'POST',
                dataType: 'JSON',
                data: $('#currency_code, #items input[type=\'text\'],#items input[type=\'hidden\'], #items textarea, #items select'),
                headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
                success: function(data) {
                    if (data) {
                        $.each( data.items, function( key, value ) {
                            $('#item-total-' + key).html(value);
                        });
                        $('#sub-total').html(data.sub_total);
                        
                        $('#grand-total').html(data.grand_total);
                        $('#grand-total-input').val(data.grand_total);
                    }
                }
            });
        }

        function VendorAjax(val){
            $.ajax({
                type: 'GET',
                dataType: 'JSON',
                data: 'vendor_id=' + val,
                url : '{{ url('expenses/vendors/autocompletevendor') }}',
                success:function(data){
                   $('#vendor_email').val(data.vendor_email).addClass('has-value');
                   $('#address').val(data.address).addClass('has-value');
                },
                error:function(error){
                    console.log(error);
                }
            });
        }

        
        $(document).on('click', '#button-account-create', function (e) { 
             $('#modal-account-create .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="{{ url('acs/custom/images/loader.gif') }}" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>'); 
                
            $.ajax({
                url: '{{ url("accounting/chartofaccounts_model_data") }}',
                type: 'POST',
                dataType: 'JSON',
                data: $("#form-account-create").serialize(),
                 
                success: function(data) {
                    $('#span-loader').remove(); 

                    $('#close-modal-create-account').trigger('click');
                    $("#item-id-"+ data.present_value_of_dropdown).append('<option value="' + data.id + '" selected="selected" data-subtext="'+ data.account_type_name +'">' + data.name + '</option>'); 
                    $("#item-id-"+ data.present_value_of_dropdown).selectpicker('refresh');

                },
                error: function(error, textStatus, errorThrown) {
                    $('#span-loader').remove();  
                }
            });
            
        }); 
</script>
@endsection