<table class="table table-bordered ">
    <thead>
        <tr>
            <td>Number</td>
            <td>Vendor</td>
            <td>Billed Date</td>
            <td>Due Date</td>
            <td>Total</td>
            <td>Recieved</td>
            <td>Balance</td>
            <td>Amount</td>
        </tr>
    </thead>
    <tbody>
        @foreach ($bills as $item)
        @php
            $recieved = (count($item->payments_total)!=0)?(($item->payments_total)[0])->paid_amount:0;
            $balance = $item->amount - $recieved;
        @endphp
        <tr>
            <td>
                <a href="{{ url('/expenses/bills') }}/{{ $item->id }}" target="_blank">{{ $item->bill_number }}</a></td>
            <td>{{ $item->vendor_name }}</td>
            <td>{{ Carbon\Carbon::parse($item->billed_at)->format($date_format) }}</td>
            <td>{{ Carbon\Carbon::parse($item->due_at)->format($date_format) }}</td>
            <td>@money($item->amount, $item->currency_code, true)</td>
            <td>@money($recieved, $item->currency_code, true)</td>
            <td>@money($balance, $item->currency_code, true)</td>
            <td class="text-center">
                <div class="form-group">
                    <input type="hidden" name="bill[{{$item->id}}][bill_id]" value="{{ $item->id }}">
                    <input class="form-control has-value bill_price" name="bill[{{$item->id}}][bill_amount]" id="bill_amount" type="number" min="1" max="{{ ($balance)}}">
                    <label for="bill_amount" class="form-label">Amount</label>
                    <span class="form-controlBrd"></span>
                </div>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>