@extends('layouts.default')
@section('header-links')
    @include('accounts.banking.header')
@endsection

@section('title', 'Cheques List')

@section('new_button')
<div class="searchBox mr-2">
   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => 'Search here']) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
<a  href="{{ url('expenses/cheques/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Cheque"><i class="material-icons left">add</i> Cheque</a>
 

@endsection

@section('content')
<!-- Default box -->
<div class="box box-success">

    <table class="table table-show table-striped  table-bordered table-filter" id="tbl-cheques">       
        <thead>
            <tr>
                <th>Number</th>
                <th>Payee</th>
                <th>Amount</th>
                <th>Payment Date</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        @foreach($cheques as $item)
            <tr>
                <td><a href="{{ url('expenses/cheques/' . $item->id . ' ') }}">{{ $item->cheque_number }}</a></td>
                <td>{{ $item->person_name }} ({{ ucwords($item->person_type) }})</td>
                <td>@money($item->amount, $item->currency_code, true)</td>
                <td>{{ Date::parse($item->paid_at)->format($date_format) }}</td>
                <td >

                    <a  class="btn btn-outline-info btn-circle-iconic btn34" href="{{ url('expenses/cheques/' . $item->id . '/edit') }}"><i class="material-icons">create</i>
                    </a>
                    <a class="btn btn-outline-info btn-circle-iconic btn34" href="{{ url('expenses/cheques/' . $item->id) }}"><i class="material-icons"> remove_red_eye </i>
                    </a>
                </td>
            </tr>
        @endforeach
        @if(count($cheques) == 0)
        <tr>
            <td colspan="6" class="text-center">No Data</td>
        </tr>
        @endif
        </tbody>
    </table>
</div>
@endsection

