@extends('accounts.layouts.cheque')

@section('title', trans_choice('general.cheques', 1) . ': ' . $cheque->cheque_number)
<style>
    .cheque{padding:20px;}
     .table th{padding:1rem !important;}
</style>
@section('content')
<div class="card">
    <section class="cheque">
        <div class="row invoice-header">
            <div class="col-md-6">
                @if ($logo)
                    <img src="{{ $logo }}" class="invoice-logo" />
                @endif
          
            <div class="invoice-company">
                <address>
                    <strong>{{ setting('general.company_name') }}</strong><br>
                    {!! nl2br(setting('general.company_address')) !!}<br>
                    @if (setting('general.company_tax_number'))
                        {{ trans('general.tax_number') }}: {{ setting('general.company_tax_number') }}<br>
                    @endif
                    <br>
                    @if (setting('general.company_phone'))
                        {{ setting('general.company_phone') }}<br>
                    @endif
                    {{ setting('general.company_email') }}
                </address>
            </div>
        </div>
        <div class="col-md-6">
            <div class="">
                    <table class="table no-border">
                        <tbody>
                        <tr>
                            <th>{{ trans('cheques.cheque_number') }}:</th>
                            <td>{{ $cheque->cheque_number }}</td>
                        </tr>
                        <tr>
                            <th>{{ trans('cheques.paid_date') }}:</th>
                            <td>{{ Date::parse($cheque->paid_at)->format($date_format) }}</td>
                        </tr>
                        {{-- <tr>
                            <th>{{ trans('cheques.payment_due') }}:</th>
                            <td>{{ Date::parse($cheque->due_at)->format($date_format) }}</td>
                        </tr> --}}
                        </tbody>
                    </table>
                </div>
        </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                {{ trans('cheques.cheque_from') }}
                <address>
                    <strong>{{ $cheque->vendor_name }}</strong><br>
                    {!! nl2br($cheque->vendor_address) !!}<br>
                    @if ($cheque->vendor_tax_number)
                        {{ trans('general.tax_number') }}: {{ $cheque->vendor_tax_number }}<br>
                    @endif
                    <br>
                    @if ($cheque->vendor_phone)
                        {{ $cheque->vendor_phone }}<br>
                    @endif
                    {{ $cheque->vendor_email }}
                </address>
            </div>
            <div class="col-md-6">
                
            </div>
        </div>
        <div class="row">
            <div class="">
                <table class="table table-striped">
                    <tbody>
                    <tr>
                        <th>{{ trans_choice('accounting.accountdetails', 1) }}</th>
                        <th>{{ trans_choice('general.description', 1) }}</th>
                        <th>{{ trans('bills.price') }}</th>
                        <th>{{ trans('bills.total') }}</th>
                    </tr>
                    @foreach($cheque->account_details as $item)
                        <tr>
                             <td>
                                    {{ $item->name }}
                                </td>

                                 <td>
                                    {{ isset($item->description)?$item->description:'-' }}
                                </td>
                                <td>@money($item->price, $cheque->currency_code, true)</td>
                                <td>@money($item->total, $cheque->currency_code, true)</td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                @if ($cheque->notes)
                    <p class="lead">{{ trans_choice('general.notes', 2) }}:</p>

                    <p class="text-muted well well-sm no-shadow" style="margin-top: 10px;">
                        {{ $cheque->notes }}
                    </p>
                @endif
            </div>
            <div class="col-md-6">
                <div class="">
                    <table class="table">
                        <tbody>
                        @foreach($cheque->totals as $total)
                            @if ($total->code != 'total')
                                <tr>
                                    <th>{{ trans($total['name']) }}:</th>
                                    <td class="text-right">@money($total->amount, $cheque->currency_code, true)</td>
                                </tr>
                            @else
                                @if ($cheque->paid)
                                    <tr class="text-success">
                                        <th>{{ trans('invoices.paid') }}:</th>
                                        <td class="text-right">- @money($cheque->paid, $cheque->currency_code, true)</td>
                                    </tr>
                                @endif
                                <tr>
                                    <th>{{ trans($total['name']) }}:</th>
                                    <td class="text-right">@money($total->amount - $cheque->paid, $cheque->currency_code, true)</td>
                                </tr>
                            @endif
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection
