@extends('layouts.default')
@section('title', trans('bills.bill_payment'))
@section('content')
<style type="text/css">
input[type=number]::-webkit-inner-spin-button, 
input[type=number]::-webkit-outer-spin-button { 
  -webkit-appearance: none; 
}
.tabl-input tbody>tr>td>.form-group .form-control + label.form-label {
    position: absolute;
    top: -15px !important;
}
input[type=number] {
  -moz-appearance: textfield;
}
</style>

<div class="row">
    @if($errors->any())
        @foreach ($errors->all() as $error)
            <div>{{ $error }}</div>
        @endforeach
    @endif
</div>

<div class="box box-success">   
    {!! Form::open(['url' => 'expenses/bills/payment', 'files' => true, 'id' =>  'payment','role' => 'form']) !!}
    <div class="box-body">
        <div class="card">
            <div class="row">
                <div class="col-md-3">
                    {{ Form::textGroup('name', trans('general.name'), $bill->vendor_name, ['disabled' => 'disabled']) }}
                </div>
                <div class="col-md-3">
                    {{ Form::textGroup('paid_at', trans('bills.payment_date'), Date::now()->format('Y-m-d'), ['id' => 'paid_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'']) }}
                </div>
                <div class="col-md-3">
                    {{ Form::selectGroup('account_id', trans_choice('general.accounts', 1), $accounts, setting('general.default_account'), ['data-live-search'=>'true']) }}
                </div>
                <div class="col-md-3">
                    {{ Form::selectGroup('payment_method', trans_choice('general.payment_methods', 1), $payment_methods, setting('general.default_payment_method')) }}
                </div>
                
                <p id="accountbalance" style="margin-left:15px"> </p>

                {!! Form::hidden('currency_code', 'USD',['id' => 'currency_code']) !!}
                {!! Form::hidden('bill_id', $bill->id, ['id' => 'bill_id']) !!} 
                {!! Form::hidden('bill_id_return', 1, ['id' => 'bill_id']) !!} 
                {{ Form::hidden('account_chart_id',null,['id'=>'account_chart_id']) }}
            </div>
        </div>
        <div class="">
            <div class="">
               <h3 class="item-title">Outstanding Transactions</h3>
                <div class=" ">
                    <table class="table table-bordered tabl-bill tabl-input table-striped" id="items">
                        <thead>
                            <tr style="background-color: #f9f9f9;">
                                <th>{{ trans('general.description') }}</th>
                                <th>{{ trans('invoices.due_date') }}</th>
                                <th>{{ trans('general.totalamount') }}</th>
                                <th>{{ trans('general.paidamount') }}</th>
                                <th>{{ trans_choice('general.balance', 2) }}</th>
                                <th>{{ trans_choice('general.payments',1) }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                                if(isset($bill->payments_total[0])){
                                    $paid_amount = isset($bill->payments_total[0]['paid_amount'])?($bill->payments_total[0]['paid_amount']):0;
                                }
                                else{
                                        $paid_amount = 0;
                                }
                            ?>

                            <tr>
                                <td>{{ $bill->bill_number }}</td>
                                <td>{{ Date::parse($bill->due_at)->format($date_format) }}</td>
                                <td>@money($bill->amount,$bill->currency_code,true)</td>
                                <td>@money($paid_amount,$bill->currency_code,true)</td>
                                <td>@money(($bill->amount - $paid_amount),$bill->currency_code,true)</td>
                                <td>
                                    @if($bill->amount - $paid_amount != 0)
                                    <div class="form-group">                                
                                        <input type="number" name="amount" min="1" max="{{ ($bill->amount - $paid_amount) }}" id="amount_0" class="form-control amount has-value" required> 
                                        <label class="form-label">Amount</label>
                                        <span class="form-controlBrd"></span>
                                        <input type="hidden" id="invoice_amount_0">
                                    </div>
                                    @else
                                    <span class="badge badge-success">Full Paid</span>
                                    @endif
                                    <!--<input type="number" name="amount"  min="0" max="{{ ($bill->amount - $paid_amount) }}" id="amount" required="required"  class="" placeholder="0">-->
                               </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            
            {{ Form::textareaGroup('notes', trans_choice('general.notes', 2)) }}
        </div>
    </div>
    @if($bill->amount - $paid_amount != 0)
    <div class="box-footer">
        <div id="payment_id"></div>
        {{ Form::saveButton('expenses/bills') }}
    </div>
    @endif
    {!! Form::close() !!}
</div>
@include('includes.datepicker')

<script type="text/javascript">
    $(document).ready(function(){

        var account_id = $('#account_id').val();
        getChartID(account_id);
        getAccountBalance(account_id);

        window.onload = function() {
            var account_id = '{{ setting('general.default_account') }}';
                $.ajax({
                url  : '{{ url('/banking/tranfers/chart_id/') }}'+'/'+account_id,
                type : 'GET',
                success : function(data){
                    $('#account_chart_id').val(data);
                },
                error:function(data){
                    console.log(data);
                }
            });
        }


        $('#account_id').on('change',function(){               
            let account_id = $(this).val();
            getChartID(account_id);
            getAccountBalance(account_id);
        });


        /*$("#payment_method").select2({
            placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('general.payment_methods', 1)]) }}"
        });

        $("#account_id").select2({
            placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('general.accounts', 1)]) }}"
        });*/
        $('#customerpayment').submit(function() {
            var elements = $("input[name='amount']");
            var validated = false;
            elements.each(function() {
                if ($(this).val() != '' && $(this).val() != 0) {
                    validated = true;
                    return false; // will break the each
                } else {
                    $('#payment_id').html('<p style="color:blue;margin-left:20px"> Please Enter Amount </p>').fadeOut(10000);
                    validated = false;
                }
            });
            return validated;
        });
    });
    function getChartID(account_id){
        $.ajax({
            url  : '{{ url('/banking/tranfers/chart_id/') }}'+'/'+account_id,
            type : 'GET',
            success : function(data){
                $('#account_chart_id').val(data);
            },
            error:function(data){
                console.log(data);
            }
        });
    }
    function getAccountBalance(account_id){
        $('#accountbalance').html(' ');
        $.ajax({
            url  : '{{ url('/banking/accounts/accountbalance/') }}'+'/'+account_id,
            type : 'GET',
            success : function(data){
                $('#accountbalance').html('Account Balance:- $' +data.amount);
            },
            error:function(data){
                console.log(data);
            }
        });
    }
</script>
@endsection