@extends('layouts.default')
@section('header-links')
    @include('accounts.expenses.header')
@endsection
@section('title', trans_choice('general.bills', 2))

@section('new_button')

<div class="searchBox mr-2">
   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => trans('general.search_placeholder'), 'id'=>'tableSearch']) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
<a href="{{ url('expenses/bills/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"  data-toggle="tooltip" title="Create Bills"><i class="material-icons left">add</i> {{ trans_choice('general.bills', 2) }}</a>


{{-- <span class="new-button"><a  class="btn btn-success btn-sm"><span class="fa fa-plus"></span> &nbsp;</a></span> --}}
@endsection

@section('content')
<!-- Default box -->
<div class="box box-success">
    

    <div class="">
        <div class="wid100-Hidden" style="min-height:400px;">
            <table class="table table-show table-striped table-hover table-bordered table-filter" id="tbl-bills">
             
                <thead >
                    <tr>
                        <th>{{ trans_choice('general.numbers', 1) }}</th>
                        <th>{{ trans_choice('general.vendors', 1) }}</th>
                        <th>{{ trans('general.amount') }} </th>
                        <th>{{ trans('bills.bill_date') }}</th>
                        <th>{{ trans('bills.due_date') }}</th>
                        <th>{{  trans_choice('general.statuses', 1)}} </th>
                        <th>{{ trans('general.actions') }}</th>
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($bills as $item)
                    <tr>
                        <td><a href="{{ url('expenses/bills/' . $item->id . ' ') }}">{{ $item->bill_number }}</a></td>
                        <td>{{ $item->vendor_name }}</td>
                        <td>@money($item->amount, $item->currency_code, true)</td>
                        <td>{{ Date::parse($item->billed_at)->format($date_format) }}</td>
                        <td>{{ Date::parse($item->due_at)->format($date_format) }}</td>
                        <td><span class="badge {{ $item->status->label }}">{{ $item->status->name }}</span></td>
                         <td>
                            <div class="pull-center">
                                @if($item->status->code != 'paid')
                                <a href="{{ url('expenses/bills/makepayment/'.$item->id) }}">{{ trans('bills.make_payment') }}</a>
                                @else
                                <a href="{{ url('expenses/bills/' . $item->id . '/print') }}" >
                                   {{ trans('general.print') }}</a>
                                @endif
                                
                            </div>
                        </td>
                        <td>
                            <div class="position-relative">
                                <div class="btn-group">
                                    <div class="dropdown moreIcon">
                                        <a  data-toggle="dropdown" class="dropdown-toggle"> <i class="material-icons"> more_horiz </i></a>
                                        <ul class="dropdown-menu dropdown-menu-right">
                                            <li><a href="{{ url('expenses/bills/' . $item->id) }}">{{ trans('general.show') }}</a></li>
                                            <li><a href="{{ url('expenses/bills/' . $item->id . '/edit') }}">{{ trans('general.edit') }}</a></li>
                                            <li> <a href="{{ url('expenses/bills/' . $item->id . '/pdf') }}">{{ trans('bills.download_pdf') }}</a>
                                            </li>
                                            @if($item->status->code != 'paid')
                                            <li>
                                                <a href="{{ url('expenses/bills/' . $item->id . '/print') }}" >
                                               {{ trans('general.print') }}
                                                </a>
                                            </li>
                                            @endif
                                        </ul>
                                    </div>
                                </div>
                            </div>   
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <!-- /.box-body -->

   {{--  <div class="box-footer">
        @include('accounts.partials.admin.pagination', ['items' => $bills, 'type' => 'bills'])
    </div> --}}
    <!-- /.box-footer -->
</div>

@endsection

