<?php foreach($invoices as $item){                   
if( !($item->payments_total->isEmpty()) ){
   $paid_amount = isset($item->payments_total[0]['paid_amount'])?$item->payments_total[0]['paid_amount']:0;
}
else{
    $paid_amount = 0;
}
?>
<tr>
    <td><a href="{{ url('incomes/invoices/' . $item->id . ' ') }}">{{ $item->invoice_number }}</a></td>
    <td>
        {{ $item->customer_name_with_parent }}
    </td>

    <td>@money($item->amount, $item->currency_code, true)</td>

    <td>@money($paid_amount, $item->currency_code, true)</td>

    <td>@money(($item->amount - $paid_amount),$item->currency_code, true)</td>
    <td>{{ Date::parse($item->invoiced_at)->format($date_format) }}</td>
    <td>{{ Date::parse($item->due_at)->format($date_format) }}</td>
    <td><span class="badge {{ $item->status->label }}">{{ $item->status->name }}</span></td>
    <input type="hidden" name="customer_email" id="customer_email{{$item->id}}" value="{{ $item->customer_email }}">
    <input type="hidden" name="customer_name" id="customer_name{{$item->id}}" value="{{ $item->customer_name }}">
    <input type="hidden" name="invoice_number" id="invoice_number{{$item->id}}" value="{{ $item->invoice_number }}">
    <input type="hidden" name="cc_email" value="{{ $item->cc_email }}" id="cc_email{{ $item->id }}">
    <input type="hidden" name="bcc_email" value="{{ $item->bcc_email }}" id="bcc_email{{$item->id}}">
    <td class="text-center">
        <div class="pull-center">
            @if($item->status->code != 'paid')
            <a
                href="{{ url('incomes/customers/receivepayment/'.$item->customer_id.'/'.$item->id) }}">{{ trans('invoices.receive_payment') }}</a>
            @else
            <a href="{{ url('incomes/invoices/' . $item->id . '/print') }}">
                {{ trans('general.print') }}</a>
            @endif

        </div>
    </td>
    <td>
        <div class="position-relative">
            <div class="btn-group">
                <div class="dropdown moreIcon">
                    <a data-toggle="dropdown" class="dropdown-toggle"> <i class="material-icons"> more_horiz </i></a>
                    <ul class="dropdown-menu dropdown-menu-right">
                        <li><a href="{{ url('incomes/invoices/' . $item->id) }}">{{ trans('general.show') }}</a></li>
                        <li><a
                                href="{{ url('incomes/invoices/' . $item->id . '/edit') }}">{{ trans('general.edit') }}</a>
                        </li>
                        @if($item->status->code == 'paid')
                        <li> <a href="#" onclick='EmailInvoice({{$item->id}})' ;> {{ trans('invoices.send_mail') }}</a>
                        </li>
                        @endif
                        <li> <a
                                href="{{ url('incomes/invoices/' . $item->id . '/pdf') }}">{{ trans('invoices.download_pdf') }}</a>
                        </li>
                        @if($item->status->code != 'paid')
                        <li> <a href="#" onclick='EmailReminder({{ $item->id }})' ;>
                                {{ trans('invoices.send_reminder') }}</a>
                        </li>
                        <li>
                            <a href="{{ url('incomes/invoices/' . $item->id . '/print') }}">
                                {{ trans('general.print') }}
                            </a>
                        </li>

                        <li>{!! Form::deleteLink($item, 'incomes/invoices') !!}</li>
                        @endif
                    </ul>
                </div>
            </div>
        </div>
    </td>
</tr>
<?php } ?>
{{ Form::hidden('last_page', $invoices->lastPage(), ['id'=>'last_page']) }}