@foreach($bills as $item)
    <tr>
        <td><a href="{{ url('expenses/bills/' . $item->id . ' ') }}">{{ $item->bill_number }}</a></td>
        <td>{{ $item->vendor_name }}</td>
        <td>@money($item->amount, $item->currency_code, true)</td>
        <td>{{ Date::parse($item->billed_at)->format($date_format) }}</td>
        <td>{{ Date::parse($item->due_at)->format($date_format) }}</td>
        <td><span class="badge {{ $item->status->label }}">{{ $item->status->name }}</span></td>
            <td class="text-center">
            <div class="pull-center">
                @if($item->status->code != 'paid')
                <a href="{{ url('expenses/bills/makepayment/'.$item->id) }}">{{ trans('bills.make_payment') }}</a>
                @else
                <a href="{{ url('expenses/bills/' . $item->id . '/print') }}" >
                    {{ trans('general.print') }}</a>
                @endif
                
            </div>
        </td>
        <td>
            <div class="position-relative">
                <div class="btn-group">
                    <div class="dropdown moreIcon">
                        <a  data-toggle="dropdown" class="dropdown-toggle"> <i class="material-icons"> more_horiz </i></a>
                        <ul class="dropdown-menu dropdown-menu-right">
                            <li><a href="{{ url('expenses/bills/' . $item->id) }}">{{ trans('general.show') }}</a></li>
                            <li><a href="{{ url('expenses/bills/' . $item->id . '/edit') }}">{{ trans('general.edit') }}</a></li>
                            <li> <a href="{{ url('expenses/bills/' . $item->id . '/pdf') }}">{{ trans('bills.download_pdf') }}</a>
                            </li>
                            @if($item->status->code != 'paid')
                            <li>
                                <a href="{{ url('expenses/bills/' . $item->id . '/print') }}" >
                                {{ trans('general.print') }}
                                </a>
                            </li>
                            @endif
                        </ul>
                    </div>
                </div>
            </div>   
        </td>
    </tr>
@endforeach