@extends('layouts.default')
@section('header-links')
   <div class="secondarySubMeu inner-submenu">           
        <a class="{{ ($type == 'all')?'active':'' }} btnActive" id="allBtn"  onclick="getType('all')">Total Invoices</a>
        <a class="{{ ($type == 'opened')?'active':'' }} btnActive" id="openedBtn"  onclick="getType('opened')">Opened Invoices</a>
        <a class="{{ ($type == 'over')?'active':'' }} btnActive" id="overBtn"  onclick="getType('over')">Over Due Invoices</a>            
    </div> 
@endsection
@section('title', $title.' '.trans_choice('general.invoices', 2))

@section('new_button')
<div class="btn btn-default btn-sm date-range">
    <div id="invoice-range" >
        <i class="material-icons dateRangeIcon" style="font-size:16px;top:3px;"> calendar_today </i>&nbsp;
        <input type="text" class="color-black" id="pickDate" value="" style="font-size:12px;">
    </div>
</div>

<div class="searchBox mr-2">
    {!! Form::text('search', request('search'), ['onkeyup'=>'searchData(this)','onblur'=>'searchData(this)','id'=>'tableSearch','class' =>
    'form-control input-filter input-sm', 'placeholder' => trans('general.search_placeholder')]) !!}
     <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
<a href="{{ url('incomes/invoices/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Invoices"><i class="material-icons left">add</i> {{ trans_choice('general.invoices', 2) }}</a>
@endsection

@section('content')
<style>
.color-black {color: black !important;}
.date-range{height:30px !important;}
</style>
<!-- Default box -->
<div class="">
    <div id="content">
       
        <div class="wid100-Hidden">
            <table class="table table-show table-striped table-hover table-bordered table-filter">
                
                <thead>
                    <tr>
                        <th>{{  trans_choice('general.numbers', 1) }}</th>
                        <th>{{  trans_choice('general.customers', 1) }} </th>
                        <th>{{  trans('general.totalamount') }} </th>
                        <th>{{  trans('general.recivedamount') }} </th>
                        <th>{{  trans_choice('general.balance',2)}} </th>
                        <th>{{  trans('invoices.invoice_date')}} </th>
                        <th>{{  trans('invoices.due_date')}} </th>
                        <th>{{  trans_choice('general.statuses', 1)}} </th>
                        <th>{{ trans('general.actions') }}</th>
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                <tbody id="data_div"></tbody>
            </table>
        </div>
    </div>
</div>

{{ Form::hidden('type', 'all', ['id'=>'type']) }}
{{ Form::hidden('page_id', 1, ['id'=>'page_id']) }}

@push('css')
<link rel="stylesheet" type="text/css" href="{{ asset('accounts/css/daterangepicker.css') }}" />
@endpush
<!-- affix script -->
<script type="text/javascript" src="{{ asset('accounts/js/moment/moment.js') }}"></script>
<script type="text/javascript" src="{{ asset('accounts/js/daterangepicker/daterangepicker.js') }}"></script>

<script>
    // Date Range Picker Starts
        var start = moment().startOf('year');
        var end = moment().endOf('year');
        function applyDate(start,end) {
            $('#pickDate').val(start.format('L') + ' - ' + end.format('L'));
        }

        $('#pickDate').daterangepicker({
            startDate: moment('{{ $daterange[0] }}'),
            endDate: moment('{{ $daterange[1] }}'),
            ranges: {
                'This Week' : [moment().startOf('isoWeek'), moment().endOf('isoWeek')],
                'Last Week' : [moment().subtract('1','week').startOf('isoWeek'), moment().subtract('1','week').endOf('isoWeek')],
                'Last Two Weeks' : [moment().subtract('2','week').startOf('isoWeek'), moment().subtract('1','week').endOf('isoWeek')],
                'This Month' : [moment().startOf('month'), moment().endOf('month')],
                'Previous Month' :[moment().subtract(1,'month').startOf('month'), moment().subtract(1,'month').endOf('month')],
                '{{ trans("reports.this_quarter") }}': [moment().subtract(2, 'months').startOf('month'), moment().endOf('month')],
                '{{ trans("reports.previous_quarter") }}': [moment().subtract(5, 'months').startOf('month'), moment().subtract(3, 'months').endOf('month')],
                '{{ trans("reports.last_12_months") }}': [moment().subtract(11, 'months').startOf('month'), moment().endOf('month')],
                '{{ trans("reports.this_year") }}': [moment().startOf('year'), moment().endOf('year')],
                '{{ trans("reports.previous_year") }}': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
                
            }
        }, applyDate);
    // ENDS

    //Ajax call to get your new invoices    
    function getTableData(){
        var type = $("#type").val();
        var daterange = $("#pickDate").val();
        var page_id = $("#page_id").val();
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            type: 'GET',
            dataType: 'html',
            url: "{{ url('incomes/invoices/dashboardlist?page=') }}"+page_id,
            data: 'type='+type+'&daterange='+daterange,
            success: function(result){
                $("#data_div").append(result);
                $("#page_id").val(+page_id + +1);
            }
        });
    } 
    //end of ajax

    function getType(type) {
        $("#page_id").val(1);
        $("#type").val(type);
        $("#data_div").html('');
        // Title        
        var str = type;
        str = str.toLowerCase().replace(/\b[a-z]/g, function(letter) {
            return letter.toUpperCase();
        });
        // Activating Active class for buttons
        $(".btnActive").removeClass('active');
        $("#"+type+'Btn').addClass('active');

        $(".pageTitle h2").html(str+' Invoices');
        getTableData();
    }

    function dateChanged() {
        $("#page_id").val(1);
        $("#data_div").html('');
        getTableData();
    }

    $(window).scroll(function() {
        if($(window).scrollTop() + $(window).height() >= $(document).height()) {
            if(+$("#last_page").val() >= +$("#page_id").val()) {
                getTableData();
            }
        }
    }); 


</script>

@endsection