@extends('layouts.default')

@section('title', trans('general.dashboard'))
<style>
    .card-DboardStats-CountNum {
    font-size: 14px !important;
    margin-top:-20px !important;
   }
.card-DboardStats-Count p {font-size:10px;}

.card-DboardStats h5{position: absolute;
    top: 0px;
    font-size: 1.25rem;
    left: 65px;
    color:#0c6dff ;
}
.card-header {margin-bottom:0px !important;padding:0px !important;}

.color-black {
    color: black !important;
}
.date-range-pic{height: 20px !important;
    padding: 0px 1px !important;
    top: -8px;
    position: absolute;
    right: 7px;}
.box-tools .btn-sm{height:25px !important;}
.dash-daterange{    
    position: relative;
    top: -25px;
   }
.badgeclass .badge {
    font-size: 100% !important;
     font-weight:100 !important;
     cursor:pointer;
}
 .graph-info{
    background-color:#fff;
    border-radius: 10px;
    border:1px solid #ccc;
    min-width:100px;
 }
.badge-secondary{
    background-color:#6b66dc !important;
}
.badge-dark{
    background-color:#39c3d6 !important;
}
.badge-danger{
     background-color:#ff7862 !important;
}
.badge-primary{
    background-color:#267af9 !important;
}
 
.badge-inactive{background-color: #ebebeb !important;}

</style>

@section('content')
<div class="row">
    {{-- Invoices Card --}}
    <div class="col-lg-4 col-md-4 col-sm-4 col-xs-4">
        <div class="card-DboardStats flex-column">
            <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
                    <h5>  Invoices</h5>
                    <div class="width100P d-flex">
            
                        <div class="icon60">
                            <span class="icon24 icon-income"></span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
                    <div class="btn btn-default btn-sm pull-right date-range-pic pt-0">
                        <div id="invoice-range" class="range-padding">
                            <i class="material-icons dateRangeIcon" style="font-size:10px;top:0px;"> calendar_today </i>&nbsp;
                            <input type="text" class="color-black" id="invoiceRange" value="" style="font-size:12px;">
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-DboardStats-Count">
                <div class="row">
                    {{ Form::open(['route'=>'dashboard.invoices.card', 'style'=>'hidden', 'id'=>'invoiceForm']) }}
                        {{ Form::hidden('type', null, ['id'=>'type']) }}
                        {{ Form::hidden('daterange', null, ['id'=>'daterange']) }}
                    {{ Form::close() }}
                    <div class="col-lg-4 col-md-4 col-sm-4">
                        <a data-toggle="tooltip" title="View List" href="#" onclick="postInvoices('all')">
                            <div class="card-DboardStats-CountNum" id="income_total"><div class="lds-dual-ring"></div></div>
                        </a>
                        <p>Total Invoices</p>
                    </div>   
                    <div class="col-lg-4 col-md-4 col-sm-4"> 
                        <a data-toggle="tooltip" title="View List" href="#" onclick="postInvoices('opened')">
                            <div class="card-DboardStats-CountNum" id="income_opened"><div class="lds-dual-ring"></div></div>
                        </a>
                        <p>Open Invoices</p>
                    </div>
                    <div class="col-lg 4 col-md-4 col-sm-4"> 
                        <a data-toggle="tooltip" title="View List" href="#" onclick="postInvoices('over')">
                            <div class="card-DboardStats-CountNum" id="income_over"><div class="lds-dual-ring"></div></div>
                        </a>
                        <p>Overdue Invoices</p>
                        </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Expenses Card --}}
    <div class="col-lg-4 col-md-4 col-sm-4 col-xs-4">
        <div class="card-DboardStats flex-column">
            <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
                        <h5>Bills</h5>
                        <div class="width100P d-flex">
                
                        <div class="icon60">
                        <span class="icon24 icon-dash-expenses"></span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
                     <div class="btn btn-default btn-sm pull-right date-range-pic pt-0">
                        <div id="expense-range" class="range-padding">
                            <i class="material-icons dateRangeIcon" style="font-size:10px;top:0px;"> calendar_today </i>&nbsp;
                            <input type="text" class="color-black" id="expenseRange" value="" style="font-size:12px;">
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-DboardStats-Count">
                <div class="row">
                    {{ Form::open(['route'=>'dashboard.expenses.card', 'style'=>'hidden', 'id'=>'expenseForm']) }}
                        {{ Form::hidden('type', null, ['id'=>'expenseType']) }}
                        {{ Form::hidden('daterange', null, ['id'=>'expenseDaterange']) }}
                    {{ Form::close() }}
                    <div class="col-lg-4 col-md-4 col-sm-4 ">
                        <a data-toggle="tooltip" title="View List" href="#" onclick="postExpenses('all')">
                            <div class="card-DboardStats-CountNum" id="expense_total"><div class="lds-dual-ring"></div></div>
                        </a>
                        <p>Total Bills</p>
                    </div>   
                    <div class="col-lg-4 col-md-4 col-sm-4 "> 
                        <a data-toggle="tooltip" title="View List" href="#" onclick="postExpenses('opened')">
                            <div class="card-DboardStats-CountNum" id="expense_opened"><div class="lds-dual-ring"></div></div>
                        </a>
                        <p>Open Bills</p>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-4 "> 
                        <a data-toggle="tooltip" title="View List" href="#" onclick="postExpenses('over')">
                            <div class="card-DboardStats-CountNum" id="expense_over"><div class="lds-dual-ring"></div></div>
                        </a>
                        <p>Overdue Bills</p>
                        </div>
                </div>
            </div>
        </div>
    </div>
    
    {{-- Profit Card --}}
    <div class="col-lg-4 col-md-4 col-sm-4 col-xs-4">
        <div class="card-DboardStats flex-column">
            <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
                    <h5>Profit</h5>
                    <div class="width100P d-flex">
                        <div class="icon60">
                            <span class="icon24 icon-profit"></span>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
                    <div class="btn btn-default btn-sm pull-right date-range-pic pt-0">
                        <div id="profit-range" class="range-padding">
                            <i class="material-icons dateRangeIcon" style="font-size:10px;top:0px;"> calendar_today </i>&nbsp;
                            <input type="text" class="color-black" id="profitRange" value="" style="font-size:12px;">
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-DboardStats-Count">
                <div class="row">
                    <div class="col-lg-4 col-md-4 col-sm-4">
                        <a href="javascript::void(0)">
                            <div class="card-DboardStats-CountNum" id="profit_total"><div class="lds-dual-ring"></div></div>
                        </a>
                        <p>Total Profit</p>
                    </div>   
                    <div class="col-lg-4 col-md-4 col-sm-4"> 
                        <a href="javascript::void(0)">
                            <div class="card-DboardStats-CountNum" id="profit_opened"><div class="lds-dual-ring"></div></div>
                        </a>
                        <p>Open Profit</p>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-4"> 
                        <a href="javascript::void(0)">
                            <div class="card-DboardStats-CountNum" id="profit_over"><div class="lds-dual-ring"></div></div>
                        </a>
                        <p>Overdue Profit</p>
                        </div>
                </div>
            </div>
        </div>
    </div>
</div>  

<!-- Account Balance List & Latest Invoices & Latest Expenses-->
<div class="row">
      <!-- Latest Incomes List-->
    <div class="col-lg-4 col-md-4">
        <div class="card">            
            <div class="card-header">
                <div class="row">
                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                        <h4 class="box-title">{{ trans('dashboard.latest_incomes') }}</h4>
                    </div>
                    <div class="col-lg-6 col-md-6">
                        <div class="btn btn-default btn-sm pull-right date-range-pic pt-0">
                            <div id="ltst-income-range"  class="range-padding">
                                <i class="material-icons dateRangeIcon" style="font-size:10px;top:0px;"> calendar_today </i>&nbsp;
                                <span style="font-size:9px;"></span> <b class="caret"></b>
                                <input type="text" class="color-black" id="ltstIncomeRange" value="" style="font-size:12px;">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <table class="table table-accounts">
                    <thead>
                        <tr>
                            <th>{{ trans('general.date') }}</th>
                            <th>{{ trans_choice('general.name', 1) }}</th>
                            <th>{{ trans('general.amount') }}</th>
                        </tr>
                    </thead>
                    <tbody id="ltstIncomeListData"></tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Latest Expenses List-->
    <div class="col-lg-4 col-md-4">
        <div class="card">            
            <div class="card-header">
                <div class="row">
                    <div class="col-lg-6 col-md-6">
                        <h4 class="box-title">{{ trans('dashboard.latest_expenses') }}</h4>
                    </div>
                    <div class="col-lg-6 col-md-6">
                        <div class="btn btn-default btn-sm pull-right date-range-pic pt-0">
                            <div id="ltst-exp-range" class="range-padding">
                                <i class="material-icons dateRangeIcon" style="font-size:10px;top:0px;"> calendar_today </i>&nbsp;
                                <span style="font-size:9px;"></span> <b class="caret"></b>     
                                <input type="text" class="color-black" id="ltstExpRange" value="" style="font-size:12px;">                       
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <table class="table table-accounts">
                    <thead>
                        <tr>
                            <th>{{ trans('general.date') }}</th>
                            <th>{{ trans_choice('general.name', 1) }}</th>
                            <th>{{ trans('general.amount') }}</th>
                        </tr>
                    </thead>
                    <tbody id="ltstExpListData"></tbody>
                </table>
            </div>
        </div>
    </div>

    {{-- ACCOUNTS LIST --}}
    <div class="col-lg-4 col-md-4">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col-lg-6 col-md-6">
                        <h4 class="box-title">{{ trans('dashboard.account_balance') }}</h4>
                    </div> 
                </div>
            </div>
                
            <div class="card-body">
                <table class="table table-accounts">
                    <thead>
                        <tr>
                            <th>Bank Name</th>
                            <th>Balance</th>
                        </tr>
                    </thead>
                    <tbody id="accountsListData"></tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!---Income, Expense and Profit Line Chart-->
<div class="row">
    <div class="col-lg-12 col-md-12 col-sm-12">
        <div class="card">
            <div class="box-header with-border" style="height:200px;">
                <h3 class="box-title pull-left">{{ trans('dashboard.cash_flow') }}</h3>
                {{-- ["#7BB32E","#267af9","#828c94","#39c3d6",'#ff7862','#d39e00','#03a5ee'] --}}
                <div class="text-center badgeclass">
                    <span class="badge badge-success" id="graph-income" onclick="GraphData('income','success')">Income</span>
                    <span class="badge badge-primary" id="graph-bank"  onclick="GraphData('bank','primary')">Bank</span>
                    <span class="badge badge-inactive" id="graph-equity"  onclick="GraphData('equity','secondary')">Equity</span>
                    <span class="badge badge-inactive" id="graph-assets"    onclick="GraphData('assets','dark')">Assets</span>
                    <span class="badge badge-danger"    id="graph-expenses" onclick="GraphData('expenses','danger')">Expenses</span>
                    <span class="badge badge-inactive" id="graph-liabilities" onclick="GraphData('liabilities','warning')">Liabilities</span>
                     <span class="badge badge-info"     id="graph-profit" onclick="GraphData('profit','info')">Profit</span>
                </div>
                <div class="box-tools text-right">
                    
                    <input type="hidden" name="period" id="period" value="month" />
                    <div class="btn btn-default btn-sm p-0 text-right dash-daterange">
                        <div id="cashflow-range" class="">
                            <i class="material-icons dateRangeIcon" style="font-size:14px;top:2px;"> calendar_today </i>&nbsp;
                            <span></span> <b class="caret"></b>
                        </div>
                    </div>
                </div>
            </div>
          
            <div id="cashflow_data"></div>
            <div class="" id="cashflow">
               {{--  {!! $cashflow->render() !!} --}}
            </div>
        </div>
    </div>
</div>

<link rel="stylesheet" type="text/css" href="{{ asset('accounts/css/daterangepicker.css') }}" />
<link rel="stylesheet" href="{{ asset('/theme/plugins/morris/morris.css') }}"> 

<script src="//cdnjs.cloudflare.com/ajax/libs/raphael/2.1.0/raphael-min.js"></script>
<script src="{{asset('/theme/plugins/morris/morris.js')}}"></script>
<script type="text/javascript" src="{{ asset('accounts/js/moment/moment.js') }}"></script>
<script type="text/javascript" src="{{ asset('accounts/js/daterangepicker/daterangepicker.js') }}"></script>

<script type="text/javascript">
    /* Invoices Card */
    function postInvoices(type) {
        var dtr = $("#invoiceRange").val();
        $("#type").val(type);
        $("#daterange").val(dtr);
        $("#invoiceForm").submit();
    }

    function getIncomeTotals() {
        var dates = $("#invoiceRange").val();
        $.ajax({
            type: 'POST',
            url: '{{ route('income.counts') }}',
            data: 'dates='+dates+'&_token={{ csrf_token() }}',
            success: function(result) {
                $("#income_total").html('$ '+result.total.value);
                $("#income_opened").html('$ '+result.opened.value);
                $("#income_over").html('$ '+result.over.value);
            }
        });
    }
    /* Ends Here */

    /* Expenses Card */
    function postExpenses(type) {
        var dtr = $("#expenseRange").val();
        $("#expenseType").val(type);
        $("#expenseDaterange").val(dtr);
        $("#expenseForm").submit();
    }

    function getExpenseTotals() {
        var dates = $("#expenseRange").val();
        $.ajax({
            type: 'POST',
            url: '{{ route('expenses.counts') }}',
            data: 'dates='+dates+'&_token={{ csrf_token() }}',
            success: function(result) {
                $("#expense_total").html('$ '+result.total.value);
                $("#expense_opened").html('$ '+result.opened.value);
                $("#expense_over").html('$ '+result.over.value);
            }
        });
    }
    /* Ends */

    /* Profit Card */
    function getProfitTotals() {
        var dates = $("#profitRange").val();
        $.ajax({
            type: 'POST',
            url: '{{ route('profit.counts') }}',
            data: 'dates='+dates+'&_token={{ csrf_token() }}',
            success: function(result) {
                $("#profit_total").html('$ '+result.total.value);
                $("#profit_opened").html('$ '+result.opened.value);
                $("#profit_over").html('$ '+result.over.value);
            }
        });
    }
    /* Ends */

    /* LATEST INCOMES List */
    function getLtstIncomes() {
        $("#ltstIncomeListData").html('');
        $("#ltstIncomeListData").append('<div class="loaderSmall"> </div>');
        var dates = $("#ltstIncomeRange").val();
        $.ajax({
            type: 'POST',
            url: '{{ route('latest.incomes.list') }}',
            data: 'dates='+dates+'&_token={{ csrf_token() }}',
            success: function(result) {
                $("#ltstIncomeListData").append(result);
                $("#ltstIncomeListData .loaderSmall").remove();
            }
        }); 
    }
    /* Ends */

    /* LATEST EPENSES List */
    function getLtstExps() {
        $("#ltstExpListData").html('');
        $("#ltstExpListData").append('<div class="loaderSmall"> </div>');
        var dates = $("#ltstExpRange").val();
        $.ajax({
            type: 'POST',
            url: '{{ route('latest.expenses.list') }}',
            data: 'dates='+dates+'&_token={{ csrf_token() }}',
            success: function(result) {
                $("#ltstExpListData").append(result);
                $("#ltstExpListData .loaderSmall").remove();
            }
        }); 
    }
    /* Ends */

    /* Accounts List */
    function getAccounts() {
        $("#accountsListData").html('');
        $("#accountsListData").append('<div class="loaderSmall"> </div>');
        var dates = $("#accountsRange").val();
        $.ajax({
            type: 'POST',
            url: '{{ route('accounts.list') }}',
            data: 'dates='+dates+'&_token={{ csrf_token() }}',
            success: function(result) {
              $("#accountsListData").append(result);
              $('#accountsListData .loaderSmall').remove();
            }
        }); 
    }
    /* Ends */

    function GraphData(type,value){
        $('#graph-'+type).toggleClass('badge-'+value);
        $('#graph-'+type).toggleClass('badge-inactive');
        $('#cashflow').html('');
        var year_num = '{{ date('y') }}';
        var Year_Months = ["Jan", "Feb", "Mar", "Apr", "May", "June", "July", "August", "Sep", "Oct", "Nov", "Dec"]; 
        var chartData = [];
        for (var i = 0; i < 12; i++) {
             j =    Year_Months[i]+'-'+year_num;
             a =    34;
             b =    32;
             c =    0;
             d =    0;
             e =    23;
             f =    0;
             g =    13;  
            let jsonData =  {};
            jsonData['y'] = j;
            if (a != 0 ) { jsonData['a'] = a; }
            if (b != 0)  { jsonData['b'] = b; }
            if (c != 0)  { jsonData['c'] = c; }
            if (d != 0)  { jsonData['d'] = d; }
            if (e != 0)  { jsonData['e'] = e; }
            if (f != 0)  { jsonData['f'] = f; }
            if (g != 0)  { jsonData['g'] = g; }
            chartData.push(jsonData); 
        }
        html = '<div class="row m-0" style="padding:0px 20px 0px 50px;">';
        var ykeys  = [];
        var labels  = [];
        $.each(chartData,function(index,i){ 
            // console.log(i); 
            html += '<div class="col-lg-1 col-md-1 col-sm-1 col-xs-1 p-0"><div class="morris-hover morris-default-style hidden-sm-down" style="left: 0px; top: -120px;"><div class="morris-hover-row-label">'+i.y+'</div>';
            if(a != 0){
                html += '<div class="morris-hover-point" style="color: #7BB32E">';
                html += 'Income: $'+i.a;
                html += '</div>';
                if(ykeys.indexOf('a') === -1) {
                    ykeys.push('a');
                    labels.push('Income');
                }
            }if(b != 0){
                html += '<div class="morris-hover-point" style="color: #267af9">';
                html += 'Bank: $'+i.b;
                html += '</div>';
                if(ykeys.indexOf('b') === -1) {
                    ykeys.push('b');
                    labels.push('Bank');
                }
            }if(c !== 0){
              //  console.log(c);
                html += '<div class="morris-hover-point" style="color: #6b66dc">';
                html += 'Equity: $'+i.c;
                html += '</div>';
                if(ykeys.indexOf('c') === -1) {
                    ykeys.push('c');
                    labels.push('Equity');
                }
            }if(d != 0){
                html += '<div class="morris-hover-point" style="color: #39c3d6">';
                html += 'Assets: $'+i.d;
                html += '</div>';
                if(ykeys.indexOf('d') === -1) {
                    ykeys.push('d');
                    labels.push('Assets');
                }
            }if(e != 0){
                html += '<div class="morris-hover-point" style="color: #ff7862">';
                html += 'Expenses: $'+i.e;
                html += '</div>';
                if(ykeys.indexOf('e') === -1) {
                    ykeys.push('e');
                    labels.push('Expenses');
                }
            }if(f != 0){
                html += '<div class="morris-hover-point" style="color: #d39e00">';
                html += 'Liabilities:$'+i.f;
                html += '</div>';
                if(ykeys.indexOf('f') === -1) {
                    ykeys.push('f');
                    labels.push('Liabilities');
                }
            }if(g != 0){
                html += '<div class="morris-hover-point" style="color: #03a5ee">';
                html += 'Profit:$'+i.g;
                html += '</div>';
                 if(ykeys.indexOf('g') === -1) {
                    ykeys.push('g');
                    labels.push('Profit');
                }
            }
            html += '</div> </div>';
        });
        html +='</div>';         

        $('#cashflow_data').html(html); 
        var cashflow = Morris.Bar({
          element: 'cashflow',
          data: [],
          xkey: 'y',
          ykeys: ykeys,
          preUnits: "$",
          labels: labels,
          fillOpacity: 0.6,
          barColors: ["#7BB32E","#267af9","#6b66dc","#39c3d6",'#ff7862','#d39e00','#03a5ee'],
          xLabelAngle: 0, 
          hideHover:'false', 
        });

        cashflow.setData(chartData);
    }

    $(function() {        
        GraphData();
        /* Chart Graph Start Here */
        
        //console.log(chartData); 

        /* Chart Graph End Here */

        var start = moment().startOf('month');
        var end = moment().endOf('month');

        function cb(start, end) {
            $('#cashflow-range span').html(start.format('L') + ' - ' + end.format('L'));
        }
        function invoice(start,end) {
            $('#invoiceRange').val(start.format('L') + ' - ' + end.format('L'));
            getIncomeTotals();
        }
        function expense(start,end) {
            $('#expenseRange').val(start.format('L') + ' - ' + end.format('L'));
            getExpenseTotals();
        }
        function profit(start,end) {
            $('#profitRange').val(start.format('L') + ' - ' + end.format('L'));
            getProfitTotals();
        }
        function ltstincomes(start,end) {
            $('#ltstIncomeRange').val(start.format('L') + ' - ' + end.format('L'));
            getLtstIncomes();
        }
        function ltstexpenses(start,end) {
            $('#ltstExpRange').val(start.format('L') + ' - ' + end.format('L'));
            getLtstExps();
        }
        function accounts(start,end) {
            $('#accountsRange').val(start.format('L') + ' - ' + end.format('L'));
            getAccounts();
        }

        $('#cashflow-range').daterangepicker({
            startDate: start,
            endDate: end,
            ranges: {
                'This Week' : [moment().startOf('isoWeek'), moment().endOf('isoWeek')],
                'Last Week' : [moment().subtract('1','week').startOf('isoWeek'), moment().subtract('1','week').endOf('isoWeek')],
                'Last Two Weeks' : [moment().subtract('2','week').startOf('isoWeek'), moment().subtract('1','week').endOf('isoWeek')],
                'This Month' : [moment().startOf('month'), moment().endOf('month')],
                'Previous Month' :[moment().subtract(1,'month').startOf('month'), moment().subtract(1,'month').endOf('month')],
                '{{ trans("reports.this_quarter") }}': [moment().subtract(2, 'months').startOf('month'), moment().endOf('month')],
                '{{ trans("reports.previous_quarter") }}': [moment().subtract(5, 'months').startOf('month'), moment().subtract(3, 'months').endOf('month')],
                '{{ trans("reports.last_12_months") }}': [moment().subtract(11, 'months').startOf('month'), moment().endOf('month')],
                '{{ trans("reports.this_year") }}': [moment().startOf('year'), moment().endOf('year')],
                '{{ trans("reports.previous_year") }}': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
                
            }
        }, cb);
        $('#invoice-range').daterangepicker({
            startDate: start,
            endDate: end,
            ranges: {
                'This Week' : [moment().startOf('isoWeek'), moment().endOf('isoWeek')],
                'Last Week' : [moment().subtract('1','week').startOf('isoWeek'), moment().subtract('1','week').endOf('isoWeek')],
                'Last Two Weeks' : [moment().subtract('2','week').startOf('isoWeek'), moment().subtract('1','week').endOf('isoWeek')],
                'This Month' : [moment().startOf('month'), moment().endOf('month')],
                'Previous Month' :[moment().subtract(1,'month').startOf('month'), moment().subtract(1,'month').endOf('month')],
               '{{ trans("reports.this_quarter") }}': [moment().subtract(2, 'months').startOf('month'), moment().endOf('month')],
                '{{ trans("reports.previous_quarter") }}': [moment().subtract(5, 'months').startOf('month'), moment().subtract(3, 'months').endOf('month')],
                '{{ trans("reports.last_12_months") }}': [moment().subtract(11, 'months').startOf('month'), moment().endOf('month')],
                '{{ trans("reports.this_year") }}': [moment().startOf('year'), moment().endOf('year')],
                '{{ trans("reports.previous_year") }}': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
                
            }
        }, invoice);
        $('#expense-range').daterangepicker({
            startDate: start,
            endDate: end,
            ranges: {
                'This Week' : [moment().startOf('isoWeek'), moment().endOf('isoWeek')],
                'Last Week' : [moment().subtract('1','week').startOf('isoWeek'), moment().subtract('1','week').endOf('isoWeek')],
                'Last Two Weeks' : [moment().subtract('2','week').startOf('isoWeek'), moment().subtract('1','week').endOf('isoWeek')],
                'This Month' : [moment().startOf('month'), moment().endOf('month')],
                'Previous Month' :[moment().subtract(1,'month').startOf('month'), moment().subtract(1,'month').endOf('month')],
                 '{{ trans("reports.this_quarter") }}': [moment().subtract(2, 'months').startOf('month'), moment().endOf('month')],
                '{{ trans("reports.previous_quarter") }}': [moment().subtract(5, 'months').startOf('month'), moment().subtract(3, 'months').endOf('month')],
                '{{ trans("reports.last_12_months") }}': [moment().subtract(11, 'months').startOf('month'), moment().endOf('month')],
                '{{ trans("reports.this_year") }}': [moment().startOf('year'), moment().endOf('year')],
                '{{ trans("reports.previous_year") }}': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
                
            }
        }, expense);
        $('#profit-range').daterangepicker({
            startDate: start,
            endDate: end,
            ranges: {
                'This Week' : [moment().startOf('isoWeek'), moment().endOf('isoWeek')],
                'Last Week' : [moment().subtract('1','week').startOf('isoWeek'), moment().subtract('1','week').endOf('isoWeek')],
                'Last Two Weeks' : [moment().subtract('2','week').startOf('isoWeek'), moment().subtract('1','week').endOf('isoWeek')],
                'This Month' : [moment().startOf('month'), moment().endOf('month')],
                'Previous Month' :[moment().subtract(1,'month').startOf('month'), moment().subtract(1,'month').endOf('month')],
                 '{{ trans("reports.this_quarter") }}': [moment().subtract(2, 'months').startOf('month'), moment().endOf('month')],
                '{{ trans("reports.previous_quarter") }}': [moment().subtract(5, 'months').startOf('month'), moment().subtract(3, 'months').endOf('month')],
                '{{ trans("reports.last_12_months") }}': [moment().subtract(11, 'months').startOf('month'), moment().endOf('month')],
                '{{ trans("reports.this_year") }}': [moment().startOf('year'), moment().endOf('year')],
                '{{ trans("reports.previous_year") }}': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
                
            }
        }, profit);
        $('#ltst-income-range').daterangepicker({
            startDate: start,
            endDate: end,
            ranges: {
                'This Week' : [moment().startOf('isoWeek'), moment().endOf('isoWeek')],
                'Last Week' : [moment().subtract('1','week').startOf('isoWeek'), moment().subtract('1','week').endOf('isoWeek')],
                'Last Two Weeks' : [moment().subtract('2','week').startOf('isoWeek'), moment().subtract('1','week').endOf('isoWeek')],
                'This Month' : [moment().startOf('month'), moment().endOf('month')],
                'Previous Month' :[moment().subtract(1,'month').startOf('month'), moment().subtract(1,'month').endOf('month')],
                '{{ trans("reports.this_quarter") }}': [moment().subtract(2, 'months').startOf('month'), moment().endOf('month')],
                '{{ trans("reports.previous_quarter") }}': [moment().subtract(5, 'months').startOf('month'), moment().subtract(3, 'months').endOf('month')],
                '{{ trans("reports.last_12_months") }}': [moment().subtract(11, 'months').startOf('month'), moment().endOf('month')],
                '{{ trans("reports.this_year") }}': [moment().startOf('year'), moment().endOf('year')],
                '{{ trans("reports.previous_year") }}': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
                
            }
        }, ltstincomes);
        $('#ltst-exp-range').daterangepicker({
            startDate: start,
            endDate: end,
            ranges: {
                'This Week' : [moment().startOf('isoWeek'), moment().endOf('isoWeek')],
                'Last Week' : [moment().subtract('1','week').startOf('isoWeek'), moment().subtract('1','week').endOf('isoWeek')],
                'Last Two Weeks' : [moment().subtract('2','week').startOf('isoWeek'), moment().subtract('1','week').endOf('isoWeek')],
                'This Month' : [moment().startOf('month'), moment().endOf('month')],
                'Previous Month' :[moment().subtract(1,'month').startOf('month'), moment().subtract(1,'month').endOf('month')],
                '{{ trans("reports.this_quarter") }}': [moment().subtract(2, 'months').startOf('month'), moment().endOf('month')],
                '{{ trans("reports.previous_quarter") }}': [moment().subtract(5, 'months').startOf('month'), moment().subtract(3, 'months').endOf('month')],
                '{{ trans("reports.last_12_months") }}': [moment().subtract(11, 'months').startOf('month'), moment().endOf('month')],
                '{{ trans("reports.this_year") }}': [moment().startOf('year'), moment().endOf('year')],
                '{{ trans("reports.previous_year") }}': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
                
            }
        }, ltstexpenses);
        $('#accounts-range').daterangepicker({
            startDate: start,
            endDate: end,
            ranges: {
                'This Week' : [moment().startOf('isoWeek'), moment().endOf('isoWeek')],
                'Last Week' : [moment().subtract('1','week').startOf('isoWeek'), moment().subtract('1','week').endOf('isoWeek')],
                'Last Two Weeks' : [moment().subtract('2','week').startOf('isoWeek'), moment().subtract('1','week').endOf('isoWeek')],
                'This Month' : [moment().startOf('month'), moment().endOf('month')],
                'Previous Month' :[moment().subtract(1,'month').startOf('month'), moment().subtract(1,'month').endOf('month')],
                '{{ trans("reports.this_quarter") }}': [moment().subtract(2, 'months').startOf('month'), moment().endOf('month')],
                '{{ trans("reports.previous_quarter") }}': [moment().subtract(5, 'months').startOf('month'), moment().subtract(3, 'months').endOf('month')],
                '{{ trans("reports.last_12_months") }}': [moment().subtract(11, 'months').startOf('month'), moment().endOf('month')],
                '{{ trans("reports.this_year") }}': [moment().startOf('year'), moment().endOf('year')],
                '{{ trans("reports.previous_year") }}': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
                
            }
        }, accounts);

        cb(start, end);
        invoice(start, end);
        expense(start, end);
        profit(start, end);
        ltstincomes(start, end);
        ltstexpenses(start, end);
        accounts(start, end);
    });

    $(document).ready(function () {
        $('#cashflow-range').on('apply.daterangepicker', function(ev, picker) {
            var period = $('#period').val();

            $.ajax({
                url: '{{ url("dashboard/dashboard/cashflow") }}',
                type: 'get',
                dataType: 'html',
                data: 'period=' + period + '&start=' + picker.startDate.format('YYYY-MM-DD') + '&end=' + picker.endDate.format('YYYY-MM-DD'),
                success: function(data) {
                    $('#cashflow').html(data);
                }
            });
        });


        $('#cashflow-monthly').on('click', function() {
            var picker = $('#cashflow-range').data('daterangepicker');

            $('#period').val('month');

            $.ajax({
                url: '{{ url("dashboard/dashboard/cashflow") }}',
                type: 'get',
                dataType: 'html',
                data: 'period=month&start=' + picker.startDate.format('YYYY-MM-DD') + '&end=' + picker.endDate.format('YYYY-MM-DD'),
                success: function(data) {
                    $('#cashflow').html(data);
                }
            });
        });

        $('#cashflow-quarterly').on('click', function() {
            var picker = $('#cashflow-range').data('daterangepicker');

            $('#period').val('quarter');

            $.ajax({
                url: '{{ url("dashboard/dashboard/cashflow") }}',
                type: 'get',
                dataType: 'html',
                data: 'period=quarter&start=' + picker.startDate.format('YYYY-MM-DD') + '&end=' + picker.endDate.format('YYYY-MM-DD'),
                success: function(data) {
                    $('#cashflow').html(data);
                }
            });
        });
        $('#slide').on('click',function(){
            $('#cashflow svg').width('100%');
        });
    });



    



</script>
@endsection