
<?php  echo Tree($items); ?>
@php 
    function Tree($items, $prefix = 10) {
        foreach ($items as $k=> $item) {
                switch ($item['source_type']) {
                    case '0':
                        $label = 'Inventory';
                        break;
                    case '1':
                        $label = 'Non - Inventory';
                        break;
                    case '2':
                        $label = 'Service';
                        break;
                    case '3':
                        $label = 'Bundle';
                        break;
                    default:
                        $label = '';
                        break;
                    }
        	@endphp
            <tr>
            	<td style = "padding-left:{{$prefix}}px"><a href="{{ url('items/items/' . $item['id'] . '/edit') }}">{{ $item['name'] }}</a></td>
                
                <td class="hidden-xs">{{ $label }}</td>
                <td>{{ money($item['sale_price'], setting('general.default_currency'), true) }}</td>
                <td class="hidden-xs">
                    @if ($item['enabled'])
                        <span class="label label-success">{{ trans('general.enabled') }}</span>
                    @else
                        <span class="label label-danger">{{ trans('general.disabled') }}</span>
                    @endif
                </td>
                <td>
                    <a  class="btn btn-outline-info btn-circle-iconic btn34" href="{{ url('items/items/' . $item['id'] . '/edit') }}"><i class="material-icons">create</i></a>
                </td>
            </tr>
            @if (isset($item['children']))
                @php Tree($item['children'], $prefix+20 );  @endphp
            @endif
        @php  } 
    }
@endphp