
<?php  echo Tree($items); ?>

@php /* Starts here */
    // Total Items as elements
    function Tree($elements, $prefix = 10) {
        // Each element
        foreach ($elements as $k=> $element) { 
            
                if(isset($element['invoice_customer'][0])){
                    // dd($element['invoice_customer'][0]);
                    $total_amount = 0;
                    $paid_amount = 0;

                    foreach($element['invoice_customer'] as $total_amount_loop){
                        if(isset($total_amount_loop['invoices_total']['amount'])) {
                            $total_amount += $total_amount_loop['invoices_total']['amount'];
                        }
                        $paid_amount += isset($total_amount_loop['payments_total'][0]['paid_amount'])?$total_amount_loop['payments_total'][0]['paid_amount']:0;
                    }
                }
                else{
                    $total_amount = 0;
                    $paid_amount = 0;
                }
                if(isset($element['creditmemo_customer'])){
                    $credit_amount = 0;
                    foreach($element['creditmemo_customer'] as $creditmemo){
                        $credit_amount += $creditmemo['creditmemo']['remaining_balance'];
                    }
                }
@endphp 
            <tr>
            	<td  style = "padding-left:{{$prefix}}px" >
                <a href="{{ url('incomes/customers/' . $element['id']) }}">
            		{{  $element['name'] }} </a>
    	            
                </td>
                <td class="hidden-xs">{{ !empty($element['customer_email']) ? $element['customer_email'] : trans('general.na') }}</td>
                <td>{{ $element['phone'] }}</td>
                <td>@money($total_amount + $credit_amount, $element['currency_code'], true)</td>
                <td>@money($paid_amount + $credit_amount, $element['currency_code'], true)</td>
                <td>@money(($total_amount-($paid_amount + $credit_amount)),$element['currency_code'], true)</td>
                <td class="hidden-xs">
                    @if ($element['enabled'])
                        <span class="label label-success">{{ trans('general.enabled') }}</span>
                    @else
                        <span class="label label-danger">{{ trans('general.disabled') }}</span>
                    @endif
                </td>
                <input type="hidden" name="customer_name" id="customer_name{{$element['id']}}"  value="{{$element['name']}}">
                <input type="hidden" name="customer_email" id="customer_email{{$element['id']}}"  value="{{$element['customer_email']}}">
                <td class="text-center">
                    <div class="pull-center">
                        <a href="{{ url('incomes/invoices/create/'.$element['id']) }}">{{ trans('invoices.create_invoice') }}</a>
                    </div>
                </td>
                <td>
                    <div class="pull-right">
                            <div class="btn-group">
                                <div class="dropdown moreIcon">
                                    
                                     <a  data-toggle="dropdown" class="dropdown-toggle"> <i class="material-icons"> more_horiz </i></a>

                                    <ul class="dropdown-menu dropdown-menu-right">
                                        <li><a href="{{ url('incomes/customers/' . $element['id'] . '/edit') }}">{{ trans('general.edit') }}</a></li>
                                        <li><a href="#" onclick='EmailReminder({{ $element['id'] }})';>{{ trans('general.sendreminder') }}</a></li>
                                        <li><a href="{{ url('incomes/customers/collectioncenter/'.$element['id'] ) }}">{{ trans('customers.collection_center') }}</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                </td>
            </tr>
            @if (isset($element['children']))
                @php Tree($element['children'], $prefix+20 );  @endphp
            @endif
        @php  } 
    }
@endphp