@extends('layouts.default')

@section('header-links')
    @include('accounts.banking.header')
@endsection

@section('title', 'Transfers')

@section('new_button')
<div class="searchBox mr-2">
   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => 'Search here']) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
<a href="{{ url('banking/transfers/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"  data-toggle="tooltip" title="Create Transfers"><i class="material-icons left">add</i> Transfer </a>

@endsection

@section('content')
<!-- Default box -->
<div class="box box-success">
    <div class="">
            <table class="table table-show table-striped table-hover table-bordered table-filter" id="tbl-transfers">
           
                <thead>
                <tr>
                    <th>Date</th>
                    <th>From Account</th>
                    <th>To Account</th>
                    <th>Amount</th>
                    <th>Actions</th>
                </tr>
                </thead>
                <tbody>
                @foreach($transfers as $item)
                    <tr>
                        <td>{{ Date::parse($item->paid_at)->format($date_format) }}</td>
                        <td>{{ $item->from_account }}</td>
                        <td>{{ $item->to_account }}</td>
                        <td>@money($item->amount, $item->currency_code, true)</td>

                        <td>
                             <a  class="btn btn-outline-info btn-circle-iconic btn34" href="{{ url('banking/transfers/' . $item->id . '/edit') }}"><i class="material-icons">create</i></a>

                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
    </div>
</div>
@endsection
