@extends('layouts.default')
@section('title', 'Edit Transfer')

@section('new_button')
<a href="{{ url('banking/transfers') }}"
    class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>Transfer List</a>
 
<a href="{{ url('banking/transfers/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"  data-toggle="tooltip" title="Create Transfers"><i class="material-icons left">add</i> Transfer </a>
@endsection
@section('content')
    <!-- Default box -->
    <div class="card">
        {!! Form::model($transfer, [
            'method' => 'PATCH',
            'url' => ['banking/transfers', $transfer->id],
            'role' => 'form'
        ]) !!}

        <div class="row">
            <div class="col-lg-3 col-md-3">
                {{ Form::selectGroup('from_account_id', 'From Account', $accounts, null, ['data-live-search'=>'true','required'=>'required']) }}   
            </div>
            <div class="col-lg-3 col-md-3">
                {{ Form::selectGroup('to_account_id', 'To Account', $accounts, null, ['data-live-search'=>'true','required'=>'required']) }}
            </div>
            <div class="col-lg-3 col-md-3">
                {{ Form::textGroup('amount', 'Amount', null, ['id'=>'amount','required' => 'required'])}} 
            </div>
            <div class="col-lg-3 col-md-3">
                {{ Form::textGroup('transferred_at', 'Transfer date', $transfer->payment?->paid_at, ['id' => 'transferred_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'']) }}
            </div>
            <div class="col-lg-3 col-md-3">
                {{ Form::selectGroup('payment_method', 'Payment Method', $payment_methods, config('accounts.payment_method'), []) }}
            </div>
            <div class="col-lg-3 col-md-3">
                {{ Form::textGroup('reference', 'Reference Number', null) }}
            </div>
            <div class="col-lg-12 col-md-12">
                {{ Form::textareaGroup('description', 'Description') }}
            </div>
        </div>
    
        <div class="box-footer">
            {{ Form::saveButton('Update') }}
        </div>    

        {!! Form::close() !!}
    </div>
@include('includes.datepicker')
    <script type="text/javascript">
        $(document).ready(function(){

            $(window).on("load", function(){
                var from_account_id = {{ $transfer->from_account_id }};
                var type = 'from_account_id';
                getChartid(from_account_id,type);
                getAccountBalance(from_account_id,type);

                var to_account_id = {{ $transfer->to_account_id }};
                var type = 'to_account_id';
                getChartid(to_account_id);
                getAccountBalance(to_account_id,type);
            });
 
            //Date picker
            $('#transferred_at').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
            $('#transferred_at').datepicker({
                format: 'yyyy-mm-dd',
                todayHighlight: true,
            });

            $('#from_account_id').on('change',function(){
                var from_account_id = $(this).val();
                var type = 'from_account_id';
                getChartid(from_account_id,type);
                getAccountBalance(from_account_id,type);
            });

            $('#to_account_id').on('change',function(){
                var to_account_id = $(this).val();
                var type = 'to_account_id';
                getChartid(to_account_id);
                getAccountBalance(to_account_id,type);
            });
        });

         function getChartid(id , type){
            $.ajax({
                url  : '{{ url('banking/tranfers/chart_id/') }}'+'/'+id,
                type : 'GET',
                success : function(data){
                    if(type == 'from_account_id'){
                        $('#from_account_chart_id').val(data);
                    }else{
                        $('#to_account_chart_id').val(data);
                    }
                },
                error:function(data){
                    console.log(data);
                }
            });
        }

        function getAccountBalance(account_id,type){
            $('#accountbalance').html(' ');
            $.ajax({
                url  : '{{ url('banking/accounts/accountbalance/') }}'+'/'+account_id,
                type : 'GET',
                success : function(data){
                   $('#'+type+'_div').html('Balance: $' +data.amount);
                },
                error:function(data){
                    console.log(data);
                }
            });
        }
    </script>
@endsection