@extends('layouts.default')
@section('title', trans('general.title.dummy', ['type' => trans_choice('general.reconcile', 1)]) .' for ' . $account->name_number ) 


@section('content')
<div class="box box-success">
		<div class="box-body" >
			<div class="row center-block text-center">
				<div class="col-sm-4">
                    <div class="card">
					 <h3 id="statement_ending_balance">@money($reconcile->ending_balance,'USD',true)</h3>
					<h6>STATEMENT ENDING BALANCE</h6>
                     </div>
				</div>
				<div class="col-sm-4">
                         <div class="card">
					 <h3 id="cleared_balance">$0.00</h3>
					<h6>CLEARED BALANCE</h6>
                    </div>
				</div>
				<div class="col-sm-4">
                     <div class="card">
					 <h3 id="difference_balance">@money(($reconcile->ending_balance - $account->opening_balance),'USD',true)</h3>
					<h6>DIFFERENCE</h6>
                    </div>
				</div>
			</div>
			<div class="row text-center">
				<div class="col-sm-4">
                    <div class="card">
					<h3 id="beginning_balance">@money($account->opening_balance,'USD',true)</h3>
					BEGINNING BALANCE
                </div>
				</div>
				<div class="col-sm-4">
                    <div class="card">
                    <h3 id="payments_total">$0.00</h3>
					<label id="payments_count">0 PAYMENTS
                    </label>
				</div>
				<div class="col-sm-4">
                    <div class="card">
                    <h3 id="deposit_total">$0.00</h3>
					<label id="deposit_count">0 DEPOSIT
                    </label>
                </div>
				</div>
			</div>
			
		</div>
</div>

<!-- Default box -->
<div class="box box-success">

    <!-- /.box-header -->
    <div class="box-body" id="content">
        <div class="">
            <table class="table table-striped table-hover" id="tbl-transactions">
                <thead>
                    <tr>
                        <th class="col-md-1">@sortablelink('paid_at', trans('general.date'))</th>
                        <th class="col-md-2">@sortablelink('type', trans_choice('general.transactionstype', 1))</th>
                        <th class="col-md-2">@sortablelink('number', trans('accounts.number'))</th>
                        <th class="col-md-2">@sortablelink('name', trans('general.name'))</th>
                        <th class="col-md-2">@sortablelink('description', trans('general.description'))</th>{{-- 
                        <th class="col-md-2">@sortablelink('account_name', trans('accounts.account_name'))</th> --}}
                        <th class="col-md-2">@sortablelink('amount', trans_choice('general.payments',1))</th>
                        <th class="col-md-2">@sortablelink('amount', trans('general.deposit'))</th>
                        <th class="col-md-2"><input type="checkbox" id="checkall" ></th>
                    </tr>
                </thead>
                <tbody> 
                     <?php $sum = 0; ?>
                    @if(count($chartofaccounts)>0)
                    @foreach($chartofaccounts as $k=>$item)
                    

                    <tr>
                        <td>{{ Date::parse($item->transaction_date)->format($date_format) }}</td>
                        <td>{{ $item->transaction_type }}</td>
                        <td>{{ $item->number }} </td>
                        <td>{{ $item->name }} </td>
                       {{--  <td>{{ $item->description }}</td> --}}
                        	<?php if($item->amount_type == 'add'){
		                      $deposit = @money($item->amount,'USD',true);
		                      $payment = '';
                  			}else{
	                    	$deposit =  '';
	                        $payment = @money($item->amount,'USD',true);}?>
                        <td>{{ $item->detailtype->detail_type }}</td>
                        <td id="payment-{{ $k }}">{{ isset($payment)?$payment:'' }}</td>
                        <td id="deposit-{{ $k }}">{{ isset($deposit)?$deposit:'' }}</td>
                        <td> <input type="checkbox" name="tickbox" id="tickbox" value="{{ $k }}"></td>
                    </tr>
                    @endforeach
                    @else
                          <tr>
                            <td>No Data</td>
                          </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
</div>

@endsection

@push('scripts')

<script type="text/javascript">

            
           
    $(document).ready(function(){
        
        $('input[name=tickbox]').on('change',function(){
           getTransactions();
        });

        $('#checkall').on('change',function(){
            if($('#checkall').prop('checked') == true){
                $('input[name=tickbox]').prop('checked',true);
            }else{
                $('input[name=tickbox]').prop('checked',false);

            }
            getTransactions();
        });
    });

    function getTransactions(){
            var payment = []; 
            var deposit = [];

            $("#tbl-transactions input:checkbox:checked").map(function(){
                var id = $(this).val();
                payment.push($('#payment-'+id).html());
                deposit.push($('#deposit-'+id).html());
            }).get();
            var payments_total = 0;
            var deposit_total  = 0;
            var deposit_count  = 0;
            var payments_count = 0;

            $.each(payment,function(index,value){
                if(value){
                    var num = parseFloat(value.replace('$','').replace(/,/g,''));
                    console.log(num);
                    payments_count += 1;
                    payments_total += num;
                  
                }
            });

            $.each(deposit,function(index,value){

                if(value){
                    var num1 = parseFloat(value.replace('$','').replace(/,/g,''));
                    deposit_count += 1; 
                    deposit_total += num1;
                  
                }
            });
            $('#payments_total').html('$'+payments_total);
            $('#deposit_total').html('$'+deposit_total);
            $('#payments_count').html(payments_count +' '+'PAYMENTS');
            $('#deposit_count').html(deposit_count +' '+'DEPOSIT');

            var beginning_balance = $('#beginning_balance').html().replace('$','').replace(/,/g,'');
            var statement_ending_balance = $('#statement_ending_balance').html().replace('$','').replace(/,/g,'');
            console.log(statement_ending_balance);
            var cleared_balance =( (parseFloat(beginning_balance) + parseFloat(deposit_total)) -parseFloat(payments_total) )
            $('#cleared_balance').html('$'+cleared_balance);
            var difference_balance = (statement_ending_balance - cleared_balance);
            $('#difference_balance').html('$'+difference_balance);
    }

   
    
</script>

@endpush