@extends('layouts.default')
@section('header-links')
    @include('accounts.accounting.header')
@endsection
@section('title', trans_choice('general.reconciliations', 2))

@section('new_button')
<div class="searchBox mr-2">
   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => trans('general.search_placeholder')]) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
 <a href="{{ route('reconcile.create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data toggle="tooltip" title="Create Reconcile"><i class="material-icons left">add</i>{{ trans_choice('general.reconciliations', 1) }}</a>
@endsection

@section('content')
<!-- Default box -->
<div class="box box-success">
    
            <table class="table table-show table-striped table-hover table-bordered table-filter" id="tbl-reconciliations">
            
                <thead>
                    <tr>
                        <th>{{ trans('general.created_date') }} </th>
                        <th>{{ trans_choice('general.accounts', 1) }}</th>
                        <th>{{ trans('general.period') }}</th>
                        <th  class="amount-space">{{ trans('reconciliations.closing_balance') }} </th>
                        <th>{{ trans_choice('general.statuses', 1) }}</th>
                        <th>{{ trans('general.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($reconciliations as $item)
                    <tr>
                        <td><a href="{{ route('reconcile.edit', $item->id) }}">{{ Date::parse($item->created_at)->format($date_format) }}</a></td>
                        <td>{{ isset($item->account->name_number)?$item->account->name_number:'' }}</td>
                        <td class="hidden-xs">{{ Date::parse($item->started_at)->format($date_format) }} - {{ Date::parse($item->ended_at)->format($date_format) }}</td>
                        <td class=" amount-space">@money($item->closing_balance, $item->account->currency_code, true)</td>
                        <td class="hidden-xs">
                            @if ($item->reconciled)
                                <span class="label label-success">{{ trans('reconciliations.reconciled') }}</span>
                            @else
                                <span class="label label-danger">{{ trans('reconciliations.unreconciled') }}</span>
                            @endif
                        </td>
                        <td>
                              <a  class="btn btn-outline-info btn-circle-iconic btn34" href="{{ route('reconcile.edit', $item->id) }}"><i class="material-icons">create</i></a>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
     
    <!-- /.box-body -->

    {{-- <div class="box-footer">
        @include('accounts.partials.admin.pagination', ['items' => $reconciliations, 'type' => 'reconciliations'])
    </div> --}}
    <!-- /.box-footer -->
</div>
<!-- /.box -->

<script type="text/javascript">
    $(document).ready(function(){
    });
</script>
@endsection
