@extends('layouts.default')

@section('title', trans('general.title.edit', ['type' => trans_choice('general.reconciliations', 1)]))
@section('new_button')
<a href="{{ url('banking/reconcile') }}" class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>{{ trans_choice('general.reconciliations', 1) . ' List'}} </a>
<a href="{{ route('reconcile.create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data toggle="tooltip" title="Create Reconcile"><i class="material-icons left">add</i>{{ trans_choice('general.reconciliations', 1) }}</a>
@endsection
@section('content')
    <div class="">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans_choice('general.transactions', 2) }}</h3>
        </div>
        <div class="">
            {!! Form::model($reconcile, [
                'method' => 'PATCH',
                'url' => ['banking/reconcile', $reconcile->id],
                'role' => 'form',
                'id' => 'form-reconciliations',
                'class' => 'form-loading-button'
            ]) !!}

            {{ Form::hidden('account_id', $account->id) }}
            {{ Form::hidden('currency_code', $currency->code, ['id' => 'currency_code']) }}
            {{ Form::hidden('opening_balance', $opening_balance, ['id' => 'opening_balance']) }}
            {{ Form::hidden('closing_balance', $reconcile->closing_balance, ['id' => 'closing_balance']) }}
            {{ Form::hidden('started_at', $reconcile->started_at) }}
            {{ Form::hidden('ended_at', $reconcile->ended_at) }}
            {{ Form::hidden('reconcile', $reconcile->reconcile, ['id' => 'hidden-reconcile']) }}
            <div class="">
                <table class="table table-striped table-bordered" id="tbl-transactions">
                    
                    <thead >
                    <tr>
                        <th >{{ trans('general.date') }}</th>
                        <th >{{ trans('general.description') }}</th>
                        <th >{{ trans('general.name') }}</th>
                        <th >{{ trans('general.memo') }}</th>
                        <th >{{ trans_choice('general.type', 1) }}</th>
                        <th >{{ trans_choice('general.deposits', 1) }}</th>
                        <th >{{ trans_choice('general.withdrawals', 1) }}</th>
                        <th >{{ trans('general.clear') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($transactions as $item)
                        <tr>
                            <td>{{ Date::parse($item->transaction_date)->format($date_format) }}</td>
                            <td>{{ $item->description }}</td>
                            <td>{{ $item->name }}</td>
                            <td>{{ $item->number }}</td>
                            <td>@if (!empty($item->transaction_type)) {{ $item->transaction_type}} @else {{ trans('general.na') }}@endif</td>
                            @if ($item->amount_type ==  'add')
                                <td>@money($item->amount, $item->currency_code, true)</td>
                                <td>&nbsp;</td>
                            @else
                                <td>&nbsp;</td>
                                <td>@money($item->amount, $item->currency_code, true)</td>
                            @endif
                            <td>
                                <div class="custom-controls-stacked d-block">
                                    <label class="custom-control overflow-checkbox">{{ Form::checkbox('transactions['. $item->id . '_'. $item->amount_type . ']', $item->amount, $item->reconciled,['class'=>'overflow-control-input']) }}<span class="overflow-control-indicator"></span>  </label> 
                                
                        </tr>
                    @endforeach
                    </tbody>
                </table>
                @if ($transactions->count())
                    <table class="table">
                        <tbody>
                        <tr>
                            
                            <td  class="col-md-1 text-right">{{ trans('reconciliations.closing_balance') }}:</td>

                            <td id="closing-balance" class="col-md-1 text-right">@money($reconcile->closing_balance, $account->currency_code, true)</td>
                        </tr>
                        <tr>
                           
                            <td  class="col-md-1 text-right">{{ trans('reconciliations.cleared_amount') }}:</td>
                            <td id="cleared-amount" class="col-md-1 text-right">@money('0', $account->currency_code, true)</td>
                        </tr>
                        <tr>
                            
                            <td  class="col-md-1 text-right">{{ trans('general.difference') }}:</td>
                            <td id="difference" class="col-md-1 text-right">@money('0', $account->currency_code, true)</td>
                        </tr>
                        </tbody>
                    </table>
                @endif
            </div>
        </div>
        <div class="text-right">
            @if ($transactions->count())
                <div class="form-group no-margin">
                    {!! Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'submit', 'class' => 'btn btn-default button-submit', 'data-loading-text' => trans('general.loading')]) !!}
                    {!! Form::button('<span class="fa fa-check"></span> &nbsp;' . trans('reconciliations.reconcile'), ['type' => 'button', 'id' => 'button-reconcile', 'class' => 'btn btn-primary button-submit', 'data-loading-text' => trans('general.loading'), 'disabled' => 'disabled']) !!}
                    <a href="{{ route('reconcile.index') }}" class="btn btn-default"><span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</a>
                </div>
            @else
                {{ trans('general.no_records') }}
            @endif
        </div>
        {!! Form::close() !!}
    </div>
@endsection

@push('scripts')

<script type="text/javascript">
    $(document).ready(function(){
        $('#tbl-transactions input[type="checkbox"]').trigger('change');
    });

    $(document).on('change', '#tbl-transactions input[type="checkbox"]', function (e) {
        $.ajax({
            url: '{{ url("/banking/reconcile/calculate") }}',
            type: 'GET',
            dataType: 'JSON',
            data: $('#form-reconciliations').serialize(),
            headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
            success: function(data) {
                if (data) {
                    if (data.difference_raw != 0)  {
                        $('#button-reconcile').attr('disabled','disabled');
                        $('#difference').css('background-color', '#f2dede');
                    } else {
                        $('#button-reconcile').removeAttr('disabled');
                        $('#difference').css('background-color', '#d0e9c6');
                    }

                    $('#closing-balance').html(data.closing_balance);
                    $('#cleared-amount').html(data.cleared_amount);
                    $('#difference').html(data.difference);
                }
            }
        });
    });

    $(document).on('click', '#button-reconcile', function (e) {
        $('#hidden-reconcile').val(1);

        $('#form-reconciliations').submit();
    });
</script>
@endpush
