@extends('layouts.default')
@section('title', trans_choice('general.journal', 2))
@section('content')
<div class="box box-success">
    {!! Form::open(['url' => 'banking/journal', 'files' => true, 'role' => 'form' , 'id'=> 'journalform']) !!}
    <div class="box-header with-border">
        <div class="row">
            <div class="col-sm-6">
                {{ Form::textGroup('journal_date', trans('general.journal_date'), 'calendar',['id' => 'journal_date', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy/mm/dd\'', 'data-mask' => ''], Date::now()->format($date_format)) }}
            </div>
            <div class="col-lg-6">
                {!! Form::label('journal_number', trans('general.journal_no'), ['class' => 'control-label']) !!}
                {!! Form::text('journal_number',null, ['class' => 'form-control']) !!}
            </div>
        </div>
        <div class="form-group col-md-12">
            <div class="">
                <table class="table table-bordered table-striped " id="journal">
                    <thead>
                        <tr style="background-color: #f9f9f9;">
                            <th width="30%" class="text-left">{{ trans_choice('general.account', 1) }}</th>
                            <th width="15%" class="text-center">{{ trans_choice('general.debit',2) }}</th>
                            <th width="15%" class="text-right">{{ trans_choice('general.credit',2) }}</th>
                            <th width="20%" class="text-right">{{ trans('general.description') }}</th>
                            <th width="35%" class="text-right">{{ trans('general.name') }}</th>
                            <th width="5%"  class="text-center">{{ trans('general.actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                         @php 
                            function chartfunction($elements, $prefix = '' , $item_id =null) {
                                foreach ($elements as $k=> $element) { 
                                    @endphp
                                    <option value="{{ $element['id'] }}" 
                                    {{ ( $item_id == $element['id'] )?'selected':'' }}>
                                        {{ $prefix . $element['name'] }} 
                                        @if (isset($element['children']))
                                            @php chartfunction($element['children'], $prefix . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;', $item_id);
                                            @endphp
                                        @endif
                                    </option>
                                @php  } 
                            }
                        @endphp
                        @for($journal_row = 0 ; $journal_row < 4 ;$journal_row++)
                        <tr id="journal-row-{{ $journal_row }}">
                            <td>
                             
                                <select onchange="nameofjournal({{ $journal_row }})" id="journal-id-{{ $journal_row }}" class="form-control select21 select2-hidden-accessible" name="journal[{{ $journal_row }}][chart_id]" tabindex="-1" aria-hidden="true">
                                    <?php echo   chartfunction($account_details_name , $prefix = '' ); ?>
                                </select>

                            </td>
                            <td>
                                <input class="form-control text-center debits"  name="journal[{{ $journal_row }}][debits]" type="text" id="journal-debits-{{ $journal_row }}">
                            </td>
                            <td>
                                <input class="form-control text-center credits"  name="journal[{{ $journal_row }}][credits]" type="text" id="journal-credits-{{ $journal_row }}">
                            </td>
                            <td>
                                <input class="form-control text-right"  name="journal[{{ $journal_row }}][descriptions]" type="text" id="journal-descriptions-{{ $journal_row }}">
                            </td>
                            <td>
                              

                                <select  id="journal[{{ $journal_row }}][person_id]" class="form-control select21" name="journal[{{ $journal_row }}][person_id]" tabindex="-1" aria-hidden="true">
                                    <option  selected="selected"> Select Name </option>
                                    @foreach($personname as $item)
                                    <option  value="{{ $item->id }}">{{ $item->name }} <p class="pull-right">{{ $item->type}}</p></option>
                                    @endforeach
                                </select>
                                
                            </td>
                            <td class="text-center" style="vertical-align: middle;">
                                <button type="button" onclick="$(this).tooltip('destroy'); " data-toggle="tooltip" title="{{ trans('general.delete') }}" class="btn btn-xs btn-danger"><i class="fa fa-trash"></i></button>
                            </td>
                        </tr>
                        @endfor
                        <tr id="addJournal">
                        <tr id="Total">
                            <td  class="text-center">Total</td>
                            <td class="text-center" id="debitTotal">00</td>
                            <td class="text-center" id="creditTotal">00</td>
                            <td class="text-right" colspan="3"></td>
                        </tr>
                            <td class="text-left"><button type="button" onclick="addJournal();" data-toggle="tooltip" title="{{ trans('general.add') }}" class="btn btn-xs btn-primary" data-original-title="{{ trans('general.add') }}"><i class="fa fa-plus"></i></button>
                                <button type="button" onclick="removeJournal();" data-toggle="tooltip" title="Clear all lines" class="btn btn-xs">Clear all lines</button>
                            </td>
                            <td class="text-right" colspan="4"></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
        {{ Form::textareaGroup('description', trans_choice('general.notes', 2)) }}
        {{ Form::fileGroup('attachment', trans('general.attachment'),[]) }}
    </div>
    <!-- /.box-body -->
    <div class="box-footer">
        {{ Form::saveButtons('banking/journal') }}
    </div>
    <!-- /.box-footer -->
    {!! Form::close() !!}
</div>
@endsection
@push('scripts')
<script type="text/javascript">
    $(document).ready(function(){
        $('#journal_date').datepicker({
                format: '{{ $date_format }}',
                autoclose: true
        });
    
        /*$(".select21").select2({
            placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('accounting.account_name', 1)]) }}"
        });
        $(".select23").select2({
            placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('accounting.name', 1)]) }}"
        });*/
    
        $(document).on('#journalform submit',function(){
         
            var debits = 0;
            var credits = 0;
            $('.debits').each(function(){
                debits += parseInt($(this).val() || 0);
                $('#debitTotal').html(debits);
            });
    
            $('.credits').each(function(){
                credits += parseInt($(this).val() || 0);
                $('#creditTotal').html(credits);
            });
    
            if(debits === credits){
               return true;
            }else{
                return false;
            }
    
        });
        $(document).on('keyup', '#journal tbody .debits', function(){
            $(this).closest('td').next().find('input').val('');
           
            totalDebits();
    
        });
    
        $(document).on('keyup', '#journal tbody .credits', function(){

            $(this).closest('td').prev().find('input').val('');
            totalCredits();
        });



    
     }); 
        
       
    
        var journal_row = {{ $journal_row }};
    
        function addJournal(){
            addfour = journal_row + 4;
            for(i = journal_row ; i < addfour ; i++){
                addJournals();
            }
        }  

        function totalDebits(){
            var debits = 0;
            $('.debits').each(function(){
                debits += parseInt($(this).val() || 0);
                $('#debitTotal').html(debits);
            });
        }
        function totalCredits(){
             var credits = 0;
            $('.credits').each(function(){
                credits += parseInt($(this).val() || 0);
                $('#creditTotal').html(credits);
            });
        }
        
        function nameofjournal(){
            console.log('1');
        }    
            
    
        function removeJournal(){
            var tr = $('#journal tr:last').prev().attr('id');
            var journal = tr.replace('journal-row-','');
            removeFour = journal - 4;
            if(journal != 3){
                for(i = journal ; i > removeFour ; i--){
                    $('#journal-row-' + i).remove();
                }
            }
        }   
        
       
    
        function addJournals() {
    
            html  = '<tr id="journal-row-' + journal_row + '">';
           
            html += '  <td>';
            html += '      <select class="form-control select21" onchange="nameofjournal('+ journal_row +')" name="journal[' + journal_row + '][chart_id]" id="journal-id-' + journal_row + '">';
            html += '         <option selected="selected" value="">{{ trans('general.form.select.field', ['field' => trans_choice('accounting.account_name', 1)]) }}</option>';
            html += $('#journal-0').html();
            html += '      </select>';
            
            html += '<input  name="journal['+ journal_row +'][debits]" type="hidden" value="1" id="journal-debits-'+ journal_row +'">'
            html += '  </td>';
    
            html += '  <td>';
            html += '      <input class="form-control text-center debits"  name="journal[' + journal_row + '][debits]" type="text" placeholder="" id="journal-debits-' + journal_row + '">';
            html += '  </td>';
            html += '  <td>';
            html += '      <input class="form-control text-center credits"  name="journal[' + journal_row + '][credits]" type="text" id="journal-credits-' + journal_row + '">';
            html += '  </td>';
            html += '  <td>';

            html += '      <input class="form-control "  name="journal[' + journal_row + '][description]" type="text" id="journal-description-' + journal_row + '">';
            html += '  </td>';
            html += '  <td>';

            html += '      <select class="form-control select23" onchange="nameofjournal('+ journal_row +')" name="journal[' + journal_row + '][person_id]" id="journal-id-' + journal_row + '">';
           html +='<option  selected="selected"> Select Name </option>';
                    @foreach($personname as $item)
            html +=' <option  value="{{ $item->id }}">{{ $item->name }} <p class="pull-right">{{ $item->type}}</p></option> '
                    @endforeach

            html += '</select>';
            html += '  </td>';

            html += '  <td class="text-center" style="vertical-align: middle;">';
            html += '      <button type="button" onclick="$(this).tooltip(\'destroy\'); $(\'#journal-row-' + journal_row + '\').remove(); totalItem();" data-toggle="tooltip" title="{{ trans('general.delete') }}" class="btn btn-xs btn-danger"><i class="fa fa-trash"></i></button>';
            html += '  </td>';
    
    
            $('#journal tbody #addJournal').before(html);
            //$('[rel=tooltip]').tooltip();
    
            $('[data-toggle="tooltip"]').tooltip('hide');
    
           
           /* $('#journal-row-' + journal_row + ' .select21').select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('accounting.account_name', 1)]) }}"
            });
            $('#journal-row-' + journal_row + ' .select23').select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('accounting.name')]) }}"
            });*/
    
            journal_row++;
        }
</script>
@endpush