@extends('layouts.default')
@section('header-links')
    @include('accounts.banking.header')
@endsection
@section('title', 'Journal List')
@section('new_button')
<div class="searchBox">
   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => 'Search here']) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
<a href="{{ url('banking/journal/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Journal Entry"><i class="material-icons left">add</i>Journal</a>

@endsection
@section('content')
<!-- Default box -->
<div>
   
    <!-- /.box-header -->
    <div class="">
        <table class="table table-show table-striped table-hover table-bordered table-filter" id="tbl-transfers">         
            <thead>
            <tr>
                <th>Date</th>
                <th>Number</th>
                <th>Amount</th>
                <th>Actions</th>
            </tr>
            </thead>
            <tbody>
                @foreach($journals as $journal)
                <tr>
                    <td>{{ Date::parse($journal->journal_date)->format($date_format) }}</td>
                    <td>{{ $journal->journal_number }}</td>
                    <td>@if($journal->amount != '') @money($journal->amount,'USD',true) @endif</td>
                    <td>
                        <a  class="btn btn-outline-info btn-circle-iconic btn34" href="{{ url('banking/journal/' . $journal->id . '/edit') }}"><i class="material-icons">create</i></a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    <!-- /.box-body -->
</div>

@endsection
