@extends('layouts.default')
@section('title', trans('general.title.edit', ['type'=>trans_choice('general.journal', 2)]))
@section('new_button')
<a href="{{ url('banking/journal') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i
        class="material-icons left">remove_red_eye</i> {{ trans_choice('general.journal', 2).' '.trans('general.list') }}</a>
<a href="{{ url('banking/journal/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Journal Entry"><i class="material-icons left">add</i> {{ trans_choice('general.journal', 2) }}</a>
@endsection
<style>
    .bootstrap-select.btn-group .dropdown-menu.inner {
        max-height: 400px !important;
    }
    .width100px {
        width: 60px !important;
    }
</style>
@section('content')
<div class="box box-success">
    <div class="card">
    {!! Form::model($journal, ['url' => ['banking/journal', 'id'=>$journal->id], 'files' => true, 'role' => 'form' , 'id'=> 'journalform', 'method'=>'PUT']) !!}
   
        <div class="row">
            <div class="col-sm-6">
                {{ Form::textGroup('journal_date', trans('general.journal_date'), Date::parse($journal->journal_date)->format(env('APP_FIELD_DATE')), ['id' => 'journal_date', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'']) }}
            </div>
            <div class="col-lg-6">
                {{ Form::textGroup('journal_number', trans('general.journal_no'), null, ['required']) }}
            </div>
        </div>
    </div>
        <div class="">
            <div class="">
                <table class="table table-bordered tabl-input table-striped " id="journal">
                    <thead>
                        <tr style="background-color: #f9f9f9;">
                            <th width="5%"> {{ trans('general.actions') }} </th>
                            <th width="25%"> {{ trans_choice('general.account', 1) }} </th>
                            <th width="20%"> {{ trans_choice('general.debit',2) }} </th>
                            <th width="15%"> {{ trans_choice('general.credit',2) }} </th>
                            <th width="20%"> {{ trans('general.description') }} </th>
                            <th width="15%"> {{ trans('general.name') }} </th>
                        </tr>
                    </thead>
                    <tbody>
                        @for($journal_row = 0 ; $journal_row < count($journal->items); $journal_row++) 
                        <tr id="journal-row-{{ $journal_row }}">
                            <td class="width100px" style="vertical-align: middle;">
                                <button type="button" 
                                        onclick="$('#journal-row-{{ $journal_row }}').remove(); getTotals();"
                                        data-toggle="tooltip"
                                        title="{{ trans('general.delete') }}"
                                        class="btn btn-outline-danger btn-circle-iconic btn34">
                                    <i class="material-icons">delete </i>
                                </button>
                            </td>
                            <td>
                                <select onchange="nameofjournal({{ $journal_row }}); addChartofAccount(event);" 
                                    id="journal-id-{{ $journal_row }}"
                                    class="" 
                                    data-live-search="true"
                                    name="journal[{{ $journal_row }}][chart_id]" 
                                    tabindex="-1" 
                                    aria-hidden="true"
                                    @if($journal_row==0) required @endif>
                                    <option value="">Select Type</option>
                                     {!! loopChartData($account_details_name , $prefix = '',($journal->items[$journal_row])->chart_id); !!}
                                </select>
                            </td>
                            <td>
                                <div class="form-group">
                                    <input class="form-control debits"
                                        name="journal[{{ $journal_row }}][debits]" 
                                        type="text"
                                        id="journal-debits-{{ $journal_row }}"
                                        value="{{ ($journal->items[$journal_row])->debit }}">
                                    <label class="form-label">Debits</label>
                                    <span class="form-controlBrd"></span>
                                </div>
                            </td>
                            <td>
                                <div class="form-group">
                                    <input class="form-control credits"
                                        name="journal[{{ $journal_row }}][credits]" 
                                        type="text"
                                        id="journal-credits-{{ $journal_row }}"
                                        value="{{ ($journal->items[$journal_row])->credit }}">
                                    <label class="form-label">Credits</label>
                                    <span class="form-controlBrd"></span>
                                </div>
                            </td>
                            <td>
                                <div class="form-group">
                                    <input class="form-control"
                                        name="journal[{{ $journal_row }}][descriptions]" 
                                        type="text"
                                        id="journal-descriptions-{{ $journal_row }}"
                                        value="{{ ($journal->items[$journal_row])->description }}">
                                    <label class="form-label">Description</label>
                                    <span class="form-controlBrd"></span>
                                </div>
                            </td>
                            <td>
                                <select id="journal-name-{{ $journal_row }}" 
                                    class=""
                                    name="journal[{{ $journal_row }}][person_id]" 
                                    tabindex="-1" 
                                    aria-hidden="true"
                                    data-live-search="true">
                                    <option value="" selected="selected"> Select Name </option>
                                    @foreach($personname as $item)
                                    <option value="{{ $item->id }}" @if($item->id == ($journal->items[$journal_row])->person_id) selected @endif>
                                        {{ $item->name }} 
                                        <p> ({{ $item->type}}) </p>
                                    </option>
                                    @endforeach
                                </select>
                            </td>
                            </tr>
                            @endfor
                            <tr id="addJournal">
                                <td class="width100px">Total</td>
                                <td></td>
                                <td id="debitTotal">00</td>
                                <td id="creditTotal">00</td>
                                <td colspan="3"></td>
                                {{ Form::hidden('amount', null, ['id'=>'amount']) }}
                            </tr>
                            <tr>
                                <td colspan="6" class="width100px">
                                    <button type="button" onclick="addJournal();" 
                                        data-toggle="tooltip"
                                        title="{{ trans('general.add') }}"
                                        class="btn btn-outline-primary btn-circle-iconic btn34"
                                        data-original-title="{{ trans('general.add') }}">
                                        <i class="material-icons">add</i>
                                    </button>
                                    <button type="button" onclick="removeJournal();" data-toggle="tooltip"
                                        title="Clear all lines" class="btn btn-xs">Clear all lines</button>
                                </td>
                            </tr>
                    </tbody>
                </table>
            </div>
        </div>
      
        {{ Form::fileGroup('attachment', trans('general.attachment'), null) }}
        <div class="col-md-12 pt-1">
            @if($journal->attachment)
            <span class="attachment">
                <a target="_blank" href="{{ url('/uploads/' . $journal->attachment->id . '/download') }}">
                    <span id="download-attachment" class="text-primary">
                        <i class="fa fa-file-{{ ($journal->attachment)->aggregate_type }}-o"></i> {{ $journal->attachment->basename }}
                    </span>
                </a>
            </span>
            @endif
        </div>
    </div>
    <!-- /.box-body -->
    <div class="row">
        <div class="col-lg-6 col-md-6 col-sm-6 mt-2">
              {{ Form::textareaGroup('description', trans_choice('general.notes', 2), null) }}
        </div>
        <div class="col-lg-6 col-md-6 col-sm-6 mrg-top-5">
   
        {{ Form::saveButton('Update banking/journal') }}
    
       </div>
    </div>
    <!-- /.box-footer -->
    {!! Form::close() !!}

    {{-- Select Div --}}
    <div id="selectDiv" class="d-none">
        {!! Cache::get('account_details_option')  !!}
    </div>
     @include('accounts.common.models.chartofaccount')


</div>
@include('includes.datepicker')
 <script  src="{{asset('accounts/chartofaccounts/accounting.js')}}">  </script>
<script type="text/javascript">
    $(document).ready(function(){
        //Date picker
        $('#journal_date').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
        $('#journal_date').datepicker({
            format: 'yyyy-mm-dd',
            todayHighlight: true,
        });
    
        $(document).on('#journalform submit',function(){         
            var debits = 0;
            var credits = 0;
            $('.debits').each(function(){
                debits += parseInt($(this).val() || 0);
                $('#debitTotal').html(debits);
                $('#amount').val(debits);
            });
    
            $('.credits').each(function(){
                credits += parseInt($(this).val() || 0);
                $('#creditTotal').html(credits);
            });

            if($("#debitTotal").html() == '00') {
                return false;
            }
    
            if(debits === credits){
               return true;
            }else{
                return false;
            }
    
        });

        $(document).on('keyup', '#journal tbody .debits', function(){
            $(this).closest('td').next().find('input').val('');           
            totalDebits();    
        });
    
        $(document).on('keyup', '#journal tbody .credits', function(){
            $(this).closest('td').prev().find('input').val('');
            totalCredits();
        });

    });    
    
    var journal_row = {{ $journal_row }};

    function addJournal(){
        addfour = journal_row + 4;
        for(i = journal_row ; i < addfour ; i++){
            addJournals();
        }
    }  

    function totalDebits(){
        var debits = 0;
        $('.debits').each(function(){
            debits += parseInt($(this).val() || 0);
            $('#debitTotal').html(debits);
        });
    }

    function totalCredits(){
            var credits = 0;
        $('.credits').each(function(){
            credits += parseInt($(this).val() || 0);
            $('#creditTotal').html(credits);
        });
    }
    
    function nameofjournal(){
        console.log('1');
    }  

    function removeJournal(){
        var tr = $('#journal tr:last').prev().prev().attr('id');
        var journal = tr.replace('journal-row-','');
        removeFour = journal - 4;
        if(journal != 3){
            for(i = journal ; i > removeFour ; i--){
                $('#journal-row-' + i).remove();
            }
        }

        getTotals();
    }   

    function addJournals() {

        html  = '<tr id="journal-row-' + journal_row + '">';

        html += '<td class="width100px" style="vertical-align: middle;">';
        html += '   <button type="button" onclick="$(\'#journal-row-' + journal_row + '\').remove(); getTotals();" data-toggle="tooltip" title="{{ trans('general.delete') }}" class="btn btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete </i></button>';
        html += '</td>';
        
        html += '<td>';
        html += '   <select class="selectpicker" data-live-search="true" onchange="nameofjournal('+ journal_row +'); addChartofAccount(event);" name="journal[' + journal_row + '][chart_id]" id="journal-id-' + journal_row + '">';
        html += $('#selectDiv').html();
        html += '   </select>';            
        html += '   <input  name="journal['+ journal_row +'][debits]" type="hidden" value="1" id="journal-debits-'+ journal_row +'">';
        html += '</td>';

        html += '<td>';
        html += '   <div class="form-group"> <input class="form-control debits"  name="journal[' + journal_row + '][debits]" type="text" placeholder="" id="journal-debits-' + journal_row + '"><label class="form-label">Debits</label><span class="form-controlBrd"></span></div>';
        html += '</td>';

        html += '<td>';
        html += '   <div class="form-group"><input class="form-control credits"  name="journal[' + journal_row + '][credits]" type="text" id="journal-credits-' + journal_row + '"><label class="form-label">Credits</label><span class="form-controlBrd"></span></div>';
        html += '</td>';

        html += '<td>';
        html += '  <div class="form-group"><input class="form-control "  name="journal[' + journal_row + '][descriptions]" type="text" id="journal-description-' + journal_row + '"><label class="form-label">Description</label><span class="form-controlBrd"></span></div>';
        html += '</td>';

        html += '<td>';
        html += '   <select class="selectpicker" data-live-search="true" name="journal[' + journal_row + '][person_id]" id="journal-name-' + journal_row + '">';
        html +=  '       <option value="" selected="selected"> Select Name </option>';
                        @foreach($personname as $item)
        html += '       <option  value="{{ $item->id }}">{{ $item->name }} <p class="pull-right">({{ $item->type}})</p></option> ';
                        @endforeach
        html += '   </select>';
        html += '</td>';            

        $('#journal tbody #addJournal').before(html);
        $('#journal-id-'+journal_row).selectpicker('refresh');
        
        $('#journal-name-'+journal_row).selectpicker('refresh');

        journal_row++;

        getTotals();
    }

    function getTotals() {
        totalCredits();
        totalDebits();
    }

    $(document).on('click', '#button-account-create', function (e) { 
     $('#modal-account-create .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="{{ url('acs/custom/images/loader.gif') }}" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');    
        $.ajax({
            url: '{{ url("accounting/chartofaccounts_model_data") }}',
            type: 'POST',
            dataType: 'JSON',
            data: $("#form-account-create").serialize(),
             
            success: function(data) {
                $('#span-loader').remove(); 

                $('#close-modal-create-account').trigger('click');
                $("#"+ data.present_value_of_dropdown).append('<option value="' + data.id + '" selected="selected" data-subtext="'+ data.account_type_name +'">' + data.name + '</option>'); 
                $("#"+ data.present_value_of_dropdown).selectpicker('refresh');

            },
            error: function(error, textStatus, errorThrown) {
                $('#span-loader').remove();
                // $('#close-modal-create-account').trigger('click'); 

            }
        }); 
    }); 
</script>
@endsection