@extends('layouts.default')
@section('title', 'New journal')
@section('new_button')
<a href="{{ url('banking/journal') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i
		class="material-icons left">remove_red_eye</i>Journal List</a>
@endsection
<style>
    .bootstrap-select.btn-group .dropdown-menu.inner {
        max-height: 400px !important;
    }

    .width100px {
        width: 60px !important;
    }
</style>
@section('content')

    <div class="box box-success">
        <div class="card">
            {!! Form::open(['url' => 'banking/journal', 'files' => true, 'role' => 'form' , 'id'=> 'journalform', 'autocomplete'=>'off']) !!}
            <div class="box-header with-border">
                <div class="row">
                    <div class="col-lg-6 col-md-6 col-sm-6">
                        {{ Form::textGroup('journal_date', 'Journal Date', Date::now()->format('yyyy-mm-dd'), ['id' => 'journal_date', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'']) }}
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6">
                        {{ Form::textGroup('journal_number', 'Number', null, ['required'=>'required']) }}
                    </div>
                </div>
            </div>
        </div>

        <div class="">
            <table class="table table-bordered tabl-input table-striped" id="journal">
                
            <thead>
                    <tr style="background-color: #f9f9f9;">
                        <th style="width:5%;">Actions </th>
                        <th style="width:25%;">Account</th>
                        <th style="width:15%;">Debits</th>
                        <th style="width:10%;">Credits</th>
                        <th style="width:20%;">Description</th>
                        <th style="width:25%;">Name</th>
                    </tr>
                </thead>
                <tbody> 
                    @for($journal_row = 0 ; $journal_row < 4 ;$journal_row++) 
                    <tr id="journal-row-{{ $journal_row }}">
                        <td class="width100px" style="vertical-align: middle;">
                            <button type="button" onclick="" 
                                data-toggle="tooltip"
                                title="{{ trans('general.delete') }}" 
                                class="btn btn-outline-danger btn-circle-iconic btn34">
                                <i class="material-icons">delete </i>
                            </button>
                        </td>
                        <td>
                            <select onchange="nameofjournal({{ $journal_row }}); addChartofAccount(event)" 
                                id="journal-id-{{ $journal_row }}"
                                class="" 
                                data-live-search="true"
                                name="journal[{{ $journal_row }}][chart_id]" 
                                tabindex="-1" 
                                aria-hidden="true"
                                @if($journal_row==0) required @endif>
                                {!! Cache::get('account_details_option')  !!}
                            </select>
                        </td>
                        <td>
                            <div class="form-group">
                                <input class="form-control debits"
                                    name="journal[{{ $journal_row }}][debits]" 
                                    type="text"
                                    id="journal-debits-{{ $journal_row }}">
                                <label class="form-label">Debits</label>
                                <span class="form-controlBrd"></span>
                            </div>
                        </td>
                        <td>
                            <div class="form-group">
                                <input class="form-control credits"
                                    name="journal[{{ $journal_row }}][credits]" 
                                    type="text"
                                    id="journal-credits-{{ $journal_row }}">
                                <label class="form-label">Credits</label>
                                <span class="form-controlBrd"></span>
                            </div>
                        </td>
                        <td>
                            <div class="form-group">
                                <input class="form-control"
                                    name="journal[{{ $journal_row }}][descriptions]" 
                                    type="text"
                                    id="journal-descriptions-{{ $journal_row }}">
                                <label class="form-label">Description</label>
                                <span class="form-controlBrd"></span>
                            </div>
                        </td>
                        <td>
                            <select id="journal-name-{{ $journal_row }}" 
                                class=""
                                name="journal[{{ $journal_row }}][person_id]" 
                                tabindex="-1" 
                                aria-hidden="true"
                                data-live-search="true">
                                <option value="" selected="selected"> Select Name </option>
                                @foreach($personname as $item)
                                <option value="{{ $item->id }}" data-subtext=
                                        ({{ $item->type}})> {{ $item->name }} 
                                </option>
                                @endforeach
                            </select>
                        </td>
                    </tr>
                    @endfor
                    <tr id="addJournal">                                
                        <td class="width100px">Total</td>
                        <td> </td>
                        <td id="debitTotal">00</td>
                        <td id="creditTotal">00</td>
                        <td> </td> 
                        <td> </td>   
                        {{ Form::hidden('amount', null, ['id'=>'amount']) }}                            
                    </tr>
                    <tr>
                        <td class="width100px">
                            <button type="button" 
                                    onclick="addJournal();" 
                                    data-toggle="tooltip"
                                    title="{{ trans('general.add') }}" 
                                    class="btn btn-outline-primary btn-circle-iconic btn34"
                                    data-original-title="{{ trans('general.add') }}">
                                <i class="material-icons">add</i>
                            </button>
                            <button type="button" 
                                onclick="removeJournal();" 
                                data-toggle="tooltip" 
                                title="Clear all lines" 
                                class="btn btn-xs">
                                Clear all lines
                            </button>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
            
        {{ Form::fileGroup('attachment', 'Attachment') }}
    </div>
    <!-- /.box-body -->
    <div class="row">
             <div class="col-lg-6 col-md-6 col-sm-6 mt-2">
                {{ Form::textareaGroup('description', 'Notes') }}
             </div>
    <div class="col-lg-6 col-md-6 col-sm-6 mrg-top-5">
    <div class="box-footer">
        {{ Form::saveButton('Save banking/journal') }}
    </div>
    </div>
    <!-- /.box-footer -->
    {!! Form::close() !!}


@include('accounts.common.models.chartofaccount')
</div>

{!! Form::hidden('new_row', 5, ['id'=>'new_row']) !!}

<script  src="{{asset('accounts/chartofaccounts/accounting.js')}}">  </script>
@include('includes.datepicker')
<script type="text/javascript">
    $(document).ready(function(){
        $("#journal_date").inputmask('MM-DD-YYYY', { placeholder: 'MM-DD-YYYY' });
        $('#journal_date').datepicker({
                format: '{{ $date_format }}',
                autoclose: true
        });
    
        $(document).on('#journalform submit',function(){         
            var debits = 0;
            var credits = 0;
            $('.debits').each(function(){
                debits += parseInt($(this).val() || 0);
                $('#debitTotal').html(debits);
                $('#amount').val(debits);
            });
    
            $('.credits').each(function(){
                credits += parseInt($(this).val() || 0);
                $('#creditTotal').html(credits);
            });

            if($("#debitTotal").html() == '00') {
                return false;
            }
    
            if(debits === credits){
               return true;
            }else{
                return false;
            }
    
        });

        $(document).on('keyup', '#journal tbody .debits', function(){
            $(this).closest('td').next().find('input').val('');           
            totalDebits();    
        });
    
        $(document).on('keyup', '#journal tbody .credits', function(){
            $(this).closest('td').prev().find('input').val('');
            totalCredits();
        });

    });    
    
    var journal_row = {{ $journal_row }};

    function addJournal(){
        addfour = journal_row + 4;
        for(i = journal_row ; i < addfour ; i++){
            addJournals();
        }
    }  

    function totalDebits(){
        var debits = 0;
        $('.debits').each(function(){
            debits += parseInt($(this).val() || 0);
            $('#debitTotal').html(debits);
        });
    }

    function totalCredits(){
            var credits = 0;
        $('.credits').each(function(){
            credits += parseInt($(this).val() || 0);
            $('#creditTotal').html(credits);
        });
    }
    
    function nameofjournal(){
        console.log('1');
    }  

    function removeJournal(){
        var tr = $('#journal tr:last').prev().prev().attr('id');
        var journal = tr.replace('journal-row-','');
        removeFour = journal - 4;
        if(journal != 3){
            for(i = journal ; i > removeFour ; i--){
                $('#journal-row-' + i).remove();
            }
        }

        totalCredits();
    }   

    function addJournals() {

        html  = '<tr id="journal-row-' + journal_row + '">';

        html += '<td class="width100px" style="vertical-align: middle;">';
        html += '   <button type="button" onclick="$(\'#journal-row-' + journal_row + '\').remove(); getTotals();" data-toggle="tooltip" title="{{ trans('general.delete') }}" class="btn btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete </i></button>';
        html += '</td>';
        
        html += '<td>';
        html += '   <select class="selectpicker" data-live-search="true" onchange="nameofjournal('+ journal_row +');addChartofAccount(event)" name="journal[' + journal_row + '][chart_id]" id="journal-id-' + journal_row + '">'; 
        html += $('#journal-id-0').html();
        html += '   </select>';            
        html += '   <input  name="journal['+ journal_row +'][debits]" type="hidden" value="1" id="journal-debits-'+ journal_row +'">';
        html += '</td>';

        html += '<td>';
        html += '   <div class="form-group"> <input class="form-control debits"  name="journal[' + journal_row + '][debits]" type="text" placeholder="" id="journal-debits-' + journal_row + '"><label class="form-label">Debits</label><span class="form-controlBrd"></span></div>';
        html += '</td>';

        html += '<td>';
        html += '   <div class="form-group"><input class="form-control credits"  name="journal[' + journal_row + '][credits]" type="text" id="journal-credits-' + journal_row + '"><label class="form-label">Credits</label><span class="form-controlBrd"></span></div>';
        html += '</td>';

        html += '<td>';
        html += '  <div class="form-group"><input class="form-control "  name="journal[' + journal_row + '][descriptions]" type="text" id="journal-description-' + journal_row + '"><label class="form-label">Description</label><span class="form-controlBrd"></span></div>';
        html += '</td>';

        html += '<td>';
        html += '   <select class="selectpicker" data-live-search="true" name="journal[' + journal_row + '][person_id]" id="journal-name-' + journal_row + '">';
        html +=  '       <option value="" selected="selected"> Select Name </option>';
                        @foreach($personname as $item)
        html += '       <option  value="{{ $item->id }}">{{ $item->name }} <p class="pull-right">({{ $item->type}})</p></option> ';
                        @endforeach
        html += '   </select>';
        html += '</td>';            

        $('#journal tbody #addJournal').before(html);

        journal_row++;
    }
 
    $(document).on('click', '#button-account-create', function (e) { 
     $('#modal-account-create .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="{{ url('acs/custom/images/loader.gif') }}" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');    
        $.ajax({
            url: '{{ url("accounting/chartofaccounts_model_data") }}',
            type: 'POST',
            dataType: 'JSON',
            data: $("#form-account-create").serialize(),
             
            success: function(data) {
                $('#span-loader').remove(); 

                $('#close-modal-create-account').trigger('click');
                $("#"+ data.present_value_of_dropdown).append('<option value="' + data.id + '" selected="selected" data-subtext="'+ data.account_type_name +'">' + data.name + '</option>'); 
                $("#"+ data.present_value_of_dropdown).selectpicker('refresh');

            },
            error: function(error, textStatus, errorThrown) {
                $('#span-loader').remove();
                // $('#close-modal-create-account').trigger('click'); 

            }
        }); 
    });  

    
</script>
@endsection