@extends('layouts.default')
@section('new_button')
<a href="{{ url('banking/deposit') }}"
	class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>{{ trans('general.deposit').' List' }}</a>
<a href="{{ url('banking/deposit/' . $deposit->id . '/edit') }}"
	class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">edit</i>Edit</a>
<a href="{{ url('banking/deposit/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">add</i> {{ trans('general.add_new') }}</a>
@endsection
@section('title',  trans_choice('general.deposit', 1))
<style>
	.table th{padding:1rem !important;}
</style>
@section('content')
<section class="invoice">
	<div class="card">
		<div class="row mb-3">
			<div class="col-lg-4 col-md-4">
				<span class="depst-head">Deposite To  : </span>  {{ $deposit->account->name_number }}
			</div>
			<div class="col-lg-4 col-md-4">
				<span class="depst-head">Deposite at   :</span> {{ Date::parse($deposit->paid_at)->format($date_format) }}
			</div>
			<div class="col-lg-4 col-md-4">
				<span class="depst-head">Deposite Memo :</span>   {{ $deposit->memo  }} 
			</div>
		</div>
	</div>
	<div class="row m-0">
		<table class="table table-striped">
			<thead>
				<tr>
					<th width="15%">{{ trans('invoices.received_from') }}</th>
					<th width="25%">{{ trans_choice('general.accounting',1) }}</th>
					<th width="25%">{{ trans('general.memo') }}</th>
					<th width="20%">{{ trans_choice('general.payment_methods', 1) }}</th>
					<th width="15%">{{ trans('invoices.price') }}</th>
				</tr>
			</thead>
			<tbody>
				@foreach($deposit->items as $item)
				@php 
				if($item->person_id){
				$person_id = explode('-',$item->person_id)[1];
				if( $person_id === 1 ){
				$person_type = App\Models\Accounts\Income\Customer::find($person_id);
				}else{
				$person_type = App\Models\Accounts\Expense\Vendor::find($person_id);
				}
				}
				@endphp
				<tr>
					<td width="15%" >{{  isset($person_type)?$person_type->name:'' }} </td>
					<td width="25%" >{{ $item->chart->name }}</td>
					<td width="25%" >{{ $item->memo }}</td>
					<td width="20%" >{{ $item->payment_custom }}</td>
					<td width="15%" > @money($item->price,'USD',true)</td>
				</tr>
				@endforeach
			</tbody>
		</table>
	</div>
	{{-- 
	<div class="row">
		<div class="col-md-6">
		</div>
		<div class="col-md-6">
			<div class="">
				<table class="table">
					<tbody>
						<tr class="text-success">
							<th>Paid</th>
							<td class="text-right">@money($deposit->price,'USD',true)</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
	</div>
	--}}
	<div class="box-footer row no-print">
		<div class="col-md-12">
			{{-- 
			<div class="col-lg-4 col-md-6">
				<a href="{{ url('banking/deposit/'.$deposit->id.'/edit')}}" class="btn btn-primary">
				{{ trans('general.edit') }}
				</a>
			</div>
			--}}
			<div style="display:flex;">
				@if($deposit->attachment)
				<span class="attachment">
				<a href="{{ url('uploads/' . $deposit->attachment->id . '/download') }}">
				<span id="download-attachment" class="text-primary">
				<i class="fa fa-file-{{ $deposit->attachment->aggregate_type }}-o"></i> {{ $deposit->attachment->basename }}
				</span>
				</a>
				</span>
				@endif
			</div>
		</div>
	</div>
</section>
@endsection
@push('scripts')
<script type="text/javascript">
	var text_yes = '{{ trans('general.yes') }}';
	var text_no = '{{ trans('general.no') }}';
</script>
@endpush