@extends('layouts.default')
@section('title', 'Deposit list')

@section('header-links')
    @include('accounts.banking.header')
@endsection

@section('new_button')
<div class="searchBox mr-2">
   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => 'Search here']) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
<a href="{{ url('banking/deposit/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create deposit"><i class="material-icons left">add</i> Deposit </a>
@endsection

@section('content')
<!-- Default box -->
<div class="box box-success">
    <div class="">
        <div class="">
            <table class="table table-show table-striped table-filter table-bordered table-responsive" id="tbl-accounts">               
                <thead>
                    <tr>
                        <th>Bank or Credit Card</th>
                        <th>Date</th>
                        <th>Amount</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($deposites as $deposite)
                    <tr>
                        <td>{{ isset($deposite->account->name_number)?$deposite->account->name_number:'' }}</td>
                        <td>{{  Date::parse($deposite->paid_at)->format($date_format) }}</td>
                        <td>@money($deposite->price,$deposite->currency_code,true)</td>
                        <td>
                             <a  class="btn btn-outline-info btn-circle-iconic btn34" href="{{ url('banking/deposit/' . $deposite->id . '/edit') }}"><i class="material-icons">create</i></a>

                             <a class="btn btn-outline-info btn-circle-iconic btn34" href="{{ url('banking/deposit/' . $deposite->id ) }}"><i class="material-icons"> remove_red_eye </i></a>

                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection

