@extends('layouts.default')
@section('title', 'Edit Deposit')
@section('new_button')
<a href="{{ url('banking/deposit') }}"
	class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>Deposit List</a>
<a href="{{ url('banking/deposit/' . $deposit->id ) }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">remove_red_eye</i>show</a>
<a href="{{ url('banking/deposit/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Deposit"><i class="material-icons left">add</i> Deposit</a>
@endsection
@section('content')
<!-- Default box -->
{!! Form::model($deposit,[
'method' => 'PATCH',
'url' => ['banking/deposit',$deposit->id],
'role' => 'form']) !!}
<div class="card">
	<div class="row">
		<div class="col-lg-3 col-md-3">
			{{ Form::selectGroup('account_id', 'Deposit To', $accounts, $deposit->account_id, ['data-live-search'=>'true','required'=>'required']) }}
		</div>
		<div class="col-lg-3 col-md-3">
			{{ Form::textGroup('paid_at', 'Date', Date::parse($deposit->paid_at)->format('yyyy-mm-dd'), ['id' => 'paid_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'']) }}
		</div>
		<div class="col-lg-3 col-md-3">
			{{ Form::textGroup('memo', 'Memo', $deposit->memo, []) }}
		</div>
		{{ Form::hidden('currency_code', setting('general.default_currency') , ['id' => 'currency_code']) }}
	</div>
</div>
<div class="">
<h3 class="mb-3">Deposites</h3>
<div class="">
	<table class="table tabl-input table-striped" id="deposites">
		<thead>
			<tr style="background-color: #f9f9f9;">
				<th width="5%">Actions</th>
				<th width="20%">Received From</th>
				<th width="20%">Account</th>
				<th width="20%">Memo</th>
				<th width="20%">Payment Method</th>
				<th width="15%">Price</th>
			</tr>
		</thead>
		<tbody>
			<?php $deposite_row = 0; ?>
			@forelse($deposit->items as $item)
			<tr id="deposite-row-{{ $deposite_row }}">
				<td>
					<button type="button" onclick="$('#deposite-row-{{ $deposite_row }}').remove();" data-toggle="tooltip" title="{{ trans('general.delete') }}" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete</i></button>
				</td>
				<td>
					<select id="deposite-id-{{ $deposite_row }}" class="selectpicker" name="deposite[{{ $deposite_row }}][person_id]" data-live-search="true" tabindex="-1" aria-hidden="true">
						<option value="" > Select Name </option>
						@foreach($personname as $person)
						<option value="{{ $person->id }}" data-subtext=
							({{ $person->type}}) {{ ($item->person_id == $person->id)?'selected':'' }}> {{ $person->name }} 
						</option>
						@endforeach  
					</select>
				</td>
				<td>
					<select  id="deposite-id-account-{{ $deposite_row }}" class="selectpicker" name="deposite[{{ $deposite_row }}][chart_id]" tabindex="-1"   data-live-search='true' aria-hidden="true" required="required"  onchange="addChartofAccount(event)"> 
					{!! loopChartData($account_details_name , $prefix = '',$item->chart_id); !!} 
					</select>
				</td>
				<td>
					<div class="form-group">
						<input class="form-control"  name="deposite[{{ $deposite_row }}][memo]" type="text" value="{{ $item->memo }}" id="deposite-memo-{{ $deposite_row }}">
						<label class="form-label">Memo</label>
						<span class="form-controlBrd"></span>
					</div>
				</td>
				<td>
					{!! Form::select('deposite[' . $deposite_row . '][payment]', $payment_methods, $item->payment,['id'=> 'payment-id-'. $deposite_row, 'class' => 'selectpicker', 'placeholder' => trans('general.form.select.field', ['field' =>trans_choice('accounting.account_name', 1)])]) !!} 
				</td>
				<td>
					<div class="form-group">
						<input class="form-control price" required="required" name="deposite[{{ $deposite_row }}][price]" onchange="totalPrice()" onkeyup="totalPrice()" value="{{ $item->price }}" type="text" id="deposite-price-{{ $deposite_row }}">
						<label class="form-label">Price</label>
						<span class="form-controlBrd"></span>
					</div>
				</td>
			</tr>
			<?php $deposite_row++; ?>
			@empty
			<tr id="deposite-row-{{ $deposite_row }}">
				<td style="vertical-align: middle;">
					<button type="button" onclick="$('#deposite-row-{{ $deposite_row }}').remove();" data-toggle="tooltip" title="{{ trans('general.delete') }}" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete</i></button>
				</td>
				<td>
					<select id="deposite-id-{{ $deposite_row }}" class="selectpicker" data-live-search='true' name="deposite[{{ $deposite_row }}][person_id]" tabindex="-1" aria-hidden="true">
						<option value="" > Select Name </option>
						@foreach($personname as $person)
						<option value="{{ $person->id }}" data-subtext=
							({{ $person->type}}) > {{ $person->name }} 
						</option>
						@endforeach  
					</select>
				</td>
				<td>
					<select  id="deposite-id-account-{{ $deposite_row }}" class="selectpicker" name="deposite[{{ $deposite_row }}][chart_id]" tabindex="-1"   data-live-search='true' aria-hidden="true" required="required" onchange="addChartofAccount(event)" > 
					{!! Cache::get('account_details_option')  !!}
					</select>
				</td>
				<td>
					<div class="form-group">
						<input class="form-control"  name="deposite[{{ $deposite_row }}][memo]" type="text"   id="deposite-memo-{{ $deposite_row }}">
						<label class="form-label">Memo</label>
						<span class="form-controlBrd"></span>
					</div>
				</td>
				<td >
					{!! Form::select('deposite[' . $deposite_row . '][payment]', $payment_methods, config('accounts.payment_method'),['id'=> 'payment-id-'. $deposite_row, 'class' => 'selectpicker', 'placeholder' => trans('general.form.select.field', ['field' =>trans_choice('accounting.account_name', 1)])]) !!}
				</td>
				<td >
					<div class="form-group">
						<input class="form-control price" required="required" name="deposite[{{ $deposite_row }}][price]" onchange="totalPrice()" onkeyup="totalPrice()"  type="text" id="deposite-price-{{ $deposite_row }}">
						<label class="form-label">Price</label>
						<span class="form-controlBrd"></span>
					</div>
				</td>
			</tr>
			@endforelse
			<?php $deposite_row++; ?>
			<tr id="adddeposite">
				<td><button type="button" onclick="adddeposite();" data-toggle="tooltip" title="{{ trans('general.add') }}" class="btn btn-xs  btn-outline-primary btn-circle-iconic btn34" data-original-title="{{ trans('general.add') }}"><i class="material-icons">add</i></button></td>
				<td colspan="5"></td>
			</tr>
			<tr>
				<td class=text-right colspan="5"><strong>{{ trans('invoices.total') }}</strong></td>
				<td><span id="grand-total">@money($deposit->price,'USD',true)</span></td>
				<input type="hidden" name="totalprice" value="{{ $deposit->price }}" id="totalprice"> 
			</tr>
		</tbody>
	</table>
</div>
{{ Form::fileGroup('attachment', trans('general.attachment')) }}
@if($deposit->attachment)
<span class="attachment">
<a href="{{ url('uploads/' . $deposit->attachment->id . '/download') }}">
<span id="download-attachment" class="text-primary">
<i class="fa fa-file-{{ $deposit->attachment->aggregate_type }}-o"></i> {{ $deposit->attachment->basename }}
</span>
</a>
</span>
@endif
<div class="row">
	<div class="col-lg-6 col-md-6 col-sm-6 mt-2">
		{{ Form::textareaGroup('notes', trans_choice('general.notes', 2)) }}
	</div>
	<div class="col-lg-6 col-md-6 col-sm-6 mrg-top-5">
		{{ Form::saveButton('Update banking/deposit') }}
	</div>
	<!-- /.box-body -->
</div>
{!! Form::close() !!}
<div id='accounts_dropdown' style="display: none">
	{!! Cache::get('account_details_option') !!}
</div>
@include('accounts/common/models/chartofaccount')
<script  src="{{asset('accounts/chartofaccounts/accounting.js')}}">  </script>
<script type="text/javascript">
	var text_yes = '{{ trans('general.yes') }}';
	var text_no = '{{ trans('general.no') }}';
	
	 var deposite_row = '{{ $deposite_row }}';
	
	$(document).ready(function(){
	    $("#paid_at").inputmask('MM-DD-YYYY', { placeholder: 'MM-DD-YYYY' });
	    //Date picker
	    $('#paid_at').datepicker({
	        format: '{{ $date_format }}',
	        autoclose: true,
	    });
	});
	
	
	function adddeposite() {
	    html  = '<tr id="deposite-row-' + deposite_row + '">';
	    html += '  <td style="vertical-align: middle;">';
	    html += '      <button type="button" onclick="$(\'#deposite-row-' + deposite_row + '\').remove();" data-toggle="tooltip" title="{{ trans('general.delete') }}" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete</i></button>';
	    html += '  </td>';
	
	
	     html += '  <td>';
	     
	    html += '<select class="selectpicker" data-live-search="true"  name="deposite[' + deposite_row + '][person_id]"  id="deposite-id-' + deposite_row + '">';
	
	    html += '<option selected="selected" value="">{{  trans('general.form.select.field', ['field' => 'Name']) }}</option>';
	    html += $('#deposite-id-0').html();
	
	    html += '</select>';
	
	    html += '  </td>';
	
	    html += '  <td>';
	
	    html += '<select class="selectpicker" required="required"  data-live-search="true" required="required" name="deposite[' + deposite_row + '][chart_id]" onchange="addChartofAccount(event)"  id="deposite-id-account-' + deposite_row + '">';
	
	     
	    html += $('#accounts_dropdown').html();
	   
	    
	
	    html += '</select>';
	
	    html += '  </td>';
	    html += '  <td>';
	    html += ' <div class="form-group"><input class="form-control"  name="deposite[' + deposite_row + '][memo]" type="text" id="deposite-memo-' + deposite_row + '"><label class="form-label">Memo</label> <span class="form-controlBrd"></span></div>';
	    html += '  </td>';
	
	    html += '  <td >';
	    html += '<select class="selectpicker"  name="deposite[' + deposite_row + '][payment]"  id="payment-id-' + deposite_row + '">';
	
	    html += '<option selected="selected" value="">{{  trans('general.form.select.field', ['field' => 'Customer']) }}</option>';
	    @foreach($payment_methods as $key => $payment_method)
	    html += '         <option value="{{ $key }}">{{ $payment_method }}</option>';
	    @endforeach   
	    html += '</select>';
	    html += '  </td>';
	
	    html += '  <td style="vertical-align: middle;">';
	    html += '<div class="form-group"><input class="form-control price" required="required" name="deposite[' + deposite_row + '][price]" onchange="totalPrice()" onkeyup="totalPrice()" type="text" id="deposite-price-' + deposite_row + '"><label class="form-label">Price</label> <span class="form-controlBrd"></span></div>';
	    html += '  </td>';
	
	    $('#deposites tbody #adddeposite').before(html);
	
	   
	    $('#deposite-id-'+deposite_row).selectpicker('refresh');
	    $('#deposite-id-account-'+deposite_row).selectpicker('refresh');
	    $('#payment-id-'+deposite_row).selectpicker('refresh');
	
	    deposite_row++;
	}
	
	function totalPrice(){
	     //var total = 0;
	     $.ajax({
	        url: '{{ url("banking/deposit/totaldeposite") }}',
	        type: 'POST',
	        dataType: 'JSON',
	        data: $('#currency_code, #deposites input[type=\'text\'],#deposites input[type=\'hidden\'], #deposites textarea, #deposites select'),
	        headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
	        success: function(data) {
	            if (data) {
	                $('#grand-total').html(data.grand_total);
	                $('#totalprice').val(data.total);
	            }
	        }
	    });
	}
	
	
	$(document).on('click', '#button-account-create', function (e) { 
	$('#modal-account-create .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="{{ url('acs/custom/images/loader.gif') }}" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');    
	    $.ajax({
	        url: '{{ url("accounting/chartofaccounts_model_data") }}',
	        type: 'POST',
	        dataType: 'JSON',
	        data: $("#form-account-create").serialize(),
	        
	        success: function(data) {
	            $('#span-loader').remove(); 
	
	            $('#close-modal-create-account').trigger('click');
	            $("#"+ data.present_value_of_dropdown).append('<option value="' + data.id + '" selected="selected" data-subtext="'+ data.account_type_name +'">' + data.name + '</option>'); 
	            $("#"+ data.present_value_of_dropdown).selectpicker('refresh');
	
	        },
	        error: function(error, textStatus, errorThrown) {
	            $('#span-loader').remove();
	            // $('#close-modal-create-account').trigger('click'); 
	
	        }
	    }); 
	}); 
</script>
@endsection