@extends('layouts.default')

@section('title', 'New Deposit')

@section('header-links')
    @include('accounts.banking.header')
@endsection

@section('new_button')
<a href="{{ url('banking/deposit') }}"
    class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>Deposit List</a>    
@endsection

<style>
.bootstrap-select.btn-group .dropdown-menu.inner {
    max-height: 240px !important;}
.tabl-input .form-group {
      margin-bottom: 10px !important;
  } 
</style>

@section('content')
    {!! Form::open(['url' => 'banking/deposit', 'role' => 'form','enctype'=>"multipart/form-data"]) !!}
   
    <div class="card">
        <div class="row">
            <div class="col-lg-3 col-md-3">
                {{ Form::selectGroup('account_id', 'Deposit To', $accounts, setting('general.default_account') , ['data-live-search'=>'true','required'=>'required']) }}
            </div>
            <div class="col-lg-3 col-md-3">
                {{ Form::textGroup('paid_at', 'Date', date('y-m-d'), ['id' => 'paid_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'']) }}
            </div>
            <div class="col-lg-3 col-md-3">
                {{ Form::textGroup('memo', 'Memo', null, []) }}
            </div>
            {{ Form::hidden('currency_code', setting('general.default_currency') , ['id' => 'currency_code']) }}
        </div>
    </div>

    <h3 class="mb-3 mt-3">Bank Deposit</h3>
    <table class="table table-striped tabl-input" id="deposites" >        
        <thead>
            <tr style="background-color: #f9f9f9;">
                <th width="5%">Action</th>
                <th width="25%">Received From</th>
                <th width="25%">Account</th>
                <th width="15%">Memo</th>
                <th width="15%">Payment method</th>
                <th width="15%">Price</th>
            </tr>
        </thead>
        <tbody>
            <?php $deposite_row = 0; ?>
            <tr id="deposite-row-{{ $deposite_row }}">
                <td>
                    <button type="button" onclick="$('#deposite-row-{{ $deposite_row }}').remove(); " data-toggle="tooltip" title="{{ trans('general.delete') }}" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete</i></button>
                </td>
                    <td>
                    <select id="deposite-id-{{ $deposite_row }}"  
                    class="selectpicker" name="deposite[{{ $deposite_row }}][person_id]"data-live-search='true'>
                        <option value="" selected="selected"> Select Name </option>
                        @foreach($personname as $item)
                        <option value="{{ $item->id }}" data-subtext= ({{ $item->type }})> {{ $item->name }}</option>
                        @endforeach
                    </select>
                </td>
                <td>
                    <select  id="deposite-id-account-{{ $deposite_row }}" class="selectpicker " data-live-search='true' required="required"  name="deposite[{{ $deposite_row }}][chart_id]" tabindex="-1" aria-hidden="true" onchange="addChartofAccount(event)">
                        {!! Cache::get('account_details_option') !!}
                    </select>
                </td>
                <td>
                    <div class="form-group">
                        <input class="form-control" name="deposite[{{ $deposite_row }}][memo]" type="text" id="deposite-memo-{{ $deposite_row }}">
                        <label class="form-label">Memo</label>
                        <span class="form-controlBrd"></span>
                    </div>
                </td>
                <td >
                    {!! Form::select('deposite[' . $deposite_row . '][payment]', $payment_methods, config('accounts.payment_method'),['id'=> 'payment-id-'. $deposite_row, 'class' => 'selectpicker selectpayment', 'title' => 'Select Method']) !!} 
                </td>
                <td >
                    <div class="form-group">
                        <input class="form-control price" onchange="totalPrice()" onkeyup="totalPrice()" required="required" name="deposite[{{ $deposite_row }}][price]" type="text" id="deposite-price-{{ $deposite_row }}">
                        <label class="form-label">Price</label>
                        <span class="form-controlBrd"></span>
                    </div>
                    
                </td>
            </tr>
            <?php $deposite_row++; ?>
            <tr id="adddeposite">
                <td><button type="button" onclick="adddeposite();" data-toggle="tooltip" title="Add" class="btn btn-xs  btn-outline-info btn-circle-iconic btn34" data-original-title="Add"><i class="material-icons">add</i></button></td>
                <td class="text-right" colspan="5"></td>
            </tr>
            <tr>
                <td class="text-right" colspan="5"><strong>Total</strong></td>
                <td><span id="grand-total">0</span></td>
                <input type="hidden" name="totalprice" id="totalprice">
            </tr>
        </tbody>
    </table>

    <div class="row">        
        <div class="col-md-6">
            {{ Form::fileGroup('attachment', 'Attachment') }} 
        </div>
        <div class="col-lg-6 col-md-6 col-sm-6 mt-2"> 
            {{ Form::textareaGroup('notes', 'Notes', null, ['rows'=>'1']) }}
        </div>
    </div>

    <div class="col-lg-6 col-md-6 col-sm-6 mrg-top-5">  
        {{ Form::saveButton('Save') }}
    </div>

    {!! Form::close() !!}

@include('accounts.common.models.chartofaccount') 
@include('includes.datepicker')
<script  src="{{asset('accounts/chartofaccounts/accounting.js')}}">  </script>

<script type="text/javascript">
//Date picker
    $('#paid_at').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
    $('#paid_at').datepicker({
        format: 'yyyy-mm-dd',
        todayHighlight: true,
        clearBtn: true
    });
    
    var text_yes = '{{ trans('general.yes') }}';
    var text_no = '{{ trans('general.no') }}';

    var deposite_row = '{{ $deposite_row }}';
    
    function adddeposite() {
        html  = '<tr id="deposite-row-' + deposite_row + '">';
        html += '  <td style="vertical-align: middle;">';
        html += '      <button type="button" onclick=" $(\'#deposite-row-' + deposite_row + '\').remove();" title="{{ trans('general.delete') }}" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete</i></button>';
        html += '  </td>';

        html += '  <td>';
            
        html += '<select class="selectpicker"  data-live-search="true" name="deposite[' + deposite_row + '][person_id]"  id="deposite-id-' + deposite_row + '">';

        html += $('#deposite-id-0').html();

        html += '</select>';

        html += '  </td>';

        html += '  <td>';

        html += '<select class="selectpicker" required="required"  data-live-search="true" name="deposite[' + deposite_row + '][chart_id]"  id="deposite-id-account-' + deposite_row + '"  onchange="addChartofAccount(event)">';

        html += $('#deposite-id-account-0').html();

        html += '</select>';

        html += '  </td>';
        html += '  <td>';
        html += '  <div class="form-group"><input class="form-control"  name="deposite[' + deposite_row + '][memo]" type="text" id="deposite-memo-' + deposite_row + '"><label class="form-label">Memo</label> <span class="form-controlBrd"></span></div>';
        html += '  </td>';

        html += '  <td >';
        html += '<select  class="selectpicker selectpayment" name="deposite[' + deposite_row + '][payment]"  id="payment-id-' + deposite_row + '">';
        html += $('#payment-id-0').html();
        html += '</select>';
        html += '  </td>';

        html += '  <td style="vertical-align: middle;">';
        html += ' <div class="form-group"><input class="form-control price" required="required" onkeyup="totalPrice()" onchange="totalPrice()" name="deposite[' + deposite_row + '][price]" type="text" id="deposite-price-' + deposite_row + '"><label class="form-label">Price</label> <span class="form-controlBrd"></span></div>';
        html += '  </td>';

        $('#deposites tbody #adddeposite').before(html);
        $('#payment-id-' + deposite_row).selectpicker('refresh');
        $('#deposite-id-account-' + deposite_row).selectpicker('refresh');
        $('#deposite-id-' + deposite_row).selectpicker('refresh');

        deposite_row++;
    }

    function totalPrice(){
        $.ajax({
            url: '{{ url("/banking/deposit/totaldeposite") }}',
            type: 'POST',
            dataType: 'JSON',
            data: $('#currency_code, #deposites input[type=\'text\'],#deposites input[type=\'hidden\'], #deposites textarea, #deposites select'),
            headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
            success: function(data) {
                if (data) {
                    $('#grand-total').html(data.grand_total);
                    $('#totalprice').val(data.total);
                }
            }
        });
    }

    // Account Name Taken Form Dropdown Text.
    function nameofdeposite( id ){
        $('#account-price-'+id).prop('required',true);
        var account_id = $('#account-id-'+id +' option:selected').text();
        $('#account-name-'+id).val(account_id.split("---")[0]);
    } 

    $(document).on('click', '#button-account-create', function (e) { 
     $('#modal-account-create .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="{{ url('acs/custom/images/loader.gif') }}" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');    
        $.ajax({
            url: '{{ url("accounting/chartofaccounts_model_data") }}',
            type: 'POST',
            dataType: 'JSON',
            data: $("#form-account-create").serialize(),
             
            success: function(data) {
                $('#span-loader').remove(); 

                $('#close-modal-create-account').trigger('click');
                $("#"+ data.present_value_of_dropdown).append('<option value="' + data.id + '" selected="selected" data-subtext="'+ data.account_type_name +'">' + data.name + '</option>'); 
                $("#"+ data.present_value_of_dropdown).selectpicker('refresh');

            },
            error: function(error, textStatus, errorThrown) {
                $('#span-loader').remove();
                // $('#close-modal-create-account').trigger('click'); 

            }
        }); 
    }); 

</script>
@endsection