@extends('layouts.default')

@section('title', trans_choice('general.accounts', 2) .' For '.  $account->name_number)
@section('new_button')
<a href="{{ url('banking/accounts') }}"
    class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>{{ trans_choice('general.accounts', 1) .' List' }}
</a> 
<a href="{{ url('banking/accounts/create') }}" class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Bank And Credit Cards"><i class="material-icons left mr-0">add</i>{{ trans_choice('general.accounts', 2)  }}</a>
@endsection
@section('content')
<!-- Default box -->
<div class="box box-success">
    <!-- /.box-header -->
    <div class="">
      
            <table class="table table-show table-striped table-hover table-bordered" id="tbl-transactions">
                <thead>
                    <tr>
                        <th width="10%">{{ trans('general.date') }} </th>
                        <th width="15%">{{ trans('accounts.account_name') }}</th>
                        <th width="15%">{{ trans_choice('general.types', 1) }}</th>
                        <th width="10%">Number</th>
                        <th width="25%">{{  trans('general.description') }}</th>
                        <th width="15%">{{ trans_choice('general.deposits',1) }} </th>
                        <th width="10%">{{ trans_choice('general.credit',1) }} </th>
                       {{--  <th class="col-md-2">@sortablelink('closeblance', trans('Closebalance'))</th> --}}
                    </tr>
                </thead>

                <tbody>
                    @foreach($transactions as $item)
                        <tr>
                            <td width="10%">{{ Date::parse($item->created_at)->format($date_format) }}</td>
                            <td width="15%">{{ $item->name }}</td>
                            <td width="15%">{{ $item->transaction_type }}</td>
                            <td width="10%">{{ $item->number }}</td>
                            <td width="25%">{{ $item->description }}</td>
                            @if($item->amount_type == 'add') 
                                    <td width="15%">@money($item->amount, $item->currency_code, true)</td>
                                    <td>  </td>
                            @else
                                    <td>  </td>
                                    <td width="15%">@money($item->amount, $item->currency_code, true)</td>
                            @endif
                            {{-- <td></td> --}}
                        </tr>
                    @endforeach
                </tbody>
            </table>
       
    </div>
    <!-- /.box-body -->
    <div class="box-footer">
    </div>
    
    <!-- /.box-footer -->
</div>
<!-- /.box -->
@endsection
