 <!-- Tabs within a box -->         
@extends('layouts.default')

@section('header-links')
    @include('accounts.banking.header')
@endsection

@section('title', 'Bank and Credit Cards List')

@section('new_button')

<div class="searchBox mr-2"> 
   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => 'Search here']) !!}
   <span class="search-icn"><i class="material-icons">search</i></span>
   <span class="form-controlBrd"></span>
</div>
<a href="{{ url('banking/accounts/create') }}" class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Bank And Credit Cards"><i class="material-icons left mr-0">add</i>Bank and Credit Cards</a>

@endsection

@section('content')

<div class="" style="overflow-x:auto;">
   <table class="table table-show table-striped table-hover table-bordered table-filter">         
        <thead >
            <tr>
                <th>Name</th>
                <th>Bank Account Number</th>
                <th>Current Balance</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
            <tbody>
            @foreach($accounts as $item)
                <tr>
                    <td>
                        {{ $item->name  . '-' . substr($item->number,-4) }}
                        <sub>{{ (setting('general.default_account') == $item->id )?trans('accounts.default_account'):'' }}</sub>
                    </td>
                    <td class="hidden-xs">{{ $item->number  }}   </td>
                    <td>@money($item->balance, $item->currency_code, true)</td>
                    <td class="hidden-xs" style="display: inline;">
                        @php 
                            if ($item->enabled) {
                                $stsClass = 'success';
                                $type = 1;
                            } else {
                                $stsClass = 'danger';
                                $type = 0;
                            }
                        @endphp
                        {{ Form::open(['route'=>'account.status', 'onsubmit'=>'return confirm("Do you want to change status?")', 'class'=>'mb-0']) }}
                            {{ Form::hidden('account_id', $item->id) }}
                            {{ Form::hidden('type', $type) }}
                            <button type="submit" data-toggle="tooltip" class="btn btn-outline-{{ $stsClass }} btn-circle-iconic btn34"
                                title="Click to {{ ($type==1)?'De-activate':'Activate' }}"><i class="material-icons">{{ ($type==1)?'check':'close' }}</i></button>
                                <span class="badge badge-{{ $stsClass }}">{{ ($type==1)?'Active':'Inactive' }}</span>
                        {{ Form::close() }}  
                    </td>
                    <td>
                        <a  class="btn btn-outline-info btn-circle-iconic btn34" href="{{ url('banking/accounts/' . $item->id . '/edit') }}"><i class="material-icons">create</i></a>
                        <a   href="{{ url('banking/accounts/' . $item->id ) }}">Run Report</a>                              
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
  

<input type="hidden" id="page" value="1" />
<input type="hidden" id="max_page" value="{{ $accounts->lastPage()  }}" />

</div>

<script type="text/javascript">

    $(document).ready(function(){
        $('input[name=search]').on('keyup',function(){
            var search = $(this).val();
            if(search.length >= 3){
                searchData(search);
            }
        });
    });

 //Ajax call to get your new Customer
 function getTableData(current_page){
    $.ajax({
        type: "GET",
        url: "{{ url('banking/accounts?page=') }}"+current_page, // whatever your URL is
        beforeSend: function(){ //This is your loading message ADD AN ID
            $('#tbl-accounts').append('<div class="spinner"> <span class="">Loading...</span> </div>');
        },
        complete: function(){ //remove the loading message
          $('.spinner').remove();
        },
        success: function(html) { // success! YAY!! Add HTML to content container
            $('#tbl-accounts').append(html);
        }
    });
 }

 function searchData(search){
    $.ajax({
        type : "GET",
        url : "{{  url('banking/accounts/search/') }}"+'/'+search,
        beforeSend: function(){
            $('#tbl-accounts').append('<div class="spinner"> <span class="">Loading...</span> </div>');
        },
        complete: function(){ 
         $('.spinner').remove();
        },
        success: function(html) {
            $('#tbl-accounts tbody tr').remove();   
            $('#tbl-accounts').append(html);
        }
    });

 }
</script>
@endsection

