@extends('layouts.default')

@section('title', 'New Bank or Credit Card')
@section('new_button')
<a href="{{ url('/banking/accounts') }}"
    class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>{{ trans_choice('general.accounts', 2) .' List' }}
</a>
@endsection
@section('content') 
 <!-- Default box -->
<div class="card">
    {!! Form::open(['url' => '/banking/accounts', 'method'=>'POST']) !!}

    <div class="row">
        <div class="col-lg-3 col-md-3">
            {{ Form::textGroup('name', 'Bank Name', null, ['required' => 'required']) }} 
        </div>

        <div class="col-lg-3 col-md-3">
            {{ Form::textGroup('number', 'Account Number', null, ['required' => 'required']) }}
        </div>

        {{ Form::hidden('currency_code', 'USD' , ['id' => 'currency_code']) }}

        <div class="col-lg-3 col-md-3">
            {{ Form::textGroup('opening_balance', 'Opening Balance', null, ['required' => 'required', 'id'=>'opening'], 0) }}
        </div>

        <div class="col-lg-3 col-md-3">
            {{ Form::textGroup('balance_as_of', 'Balance as of', Date::now()->format('Y-m-d'), ['id' => 'balance_as_of', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'']) }}
        </div> 
        <div class="col-lg-3 col-md-3">
            {{ Form::textGroup('bank_name', 'Bank Representative Name', null, []) }}
        </div> 
        <div class="col-lg-3 col-md-3">
            {{ Form::textGroup('bank_phone', 'Representative phone', null, []) }}
        </div> 

        <div class="col-lg-12 col-md-12">
            {{ Form::textareaGroup('bank_address', 'Bank Address', null, ['rows'=>3]) }}
        </div>

        <div class="col-md-3">
            {{ Form::radioGroup('enabled', 'Status') }}
        </div>
        <div class="col-md-3">
            {{ Form::radioGroup('default_account', 'Default Account') }}
        </div>
    
        <div class="col-lg-12 col-md-12">
            <div class="col-lg-2 col-md-2 pl-0">
                {{ Form::saveButton('Save') }}
            </div>
        </div>
    </div>

    {!! Form::close() !!}
</div>
    
@include('includes.datepicker')

<script type="text/javascript">
    var text_yes = '{{ trans('general.yes') }}';
    var text_no = '{{ trans('general.no') }}';


    $(document).ready(function(){
        $('#enabled_1').prev().trigger('click');
        $('#name').focus();

        var today = new Date();

        $('#balance_as_of').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
        $('#balance_as_of').datepicker({
            format: 'yyyy-mm-dd',
            todayHighlight: true,
        });
    });
</script>
@endsection
