
<!-- Default box -->
<div class="box box-success">
    <!-- /.box-header -->
    <div class="box-body">

        <div class="">
            <table class="table table-striped table-hover" id="tbl-transactions">
                <thead>
                    <tr>
                        <th class="col-md-1">@sortablelink('paid_at', trans('general.date'))</th>
                        <th class="col-md-2">@sortablelink('type', trans_choice('general.transactionstype', 1))</th>
                        <th class="col-md-2">@sortablelink('number', trans('accounts.number'))</th>
                        <th class="col-md-2">@sortablelink('name', trans('general.name'))</th>
                        <th class="col-md-2">@sortablelink('description', trans('general.description'))</th>
                        <th class="col-md-2">@sortablelink('account_name', trans('accounts.account_name'))</th>
                        <th class="col-md-2">@sortablelink('amount', trans('general.amount'))</th>
                        <th>Balance</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $sum = 0; ?>
                    @if(count($chartofaccounts)>0)
                    @foreach($chartofaccounts as $item)

                    <tr>
                        <td>{{ Date::parse($item->created_at)->format($date_format) }}</td>
                        <td>{{ $item->transaction_type }}</td>
                        <td>{{ $item->number }} </td>
                        <td>{{ $item->name }} </td>
                        <td>{{ $item->description }}</td>
                        <td>{{ $item->detailtype->detail_type }}</td>
                        @if($item->amount_type == 'add')
                        <td>@money($item->amount, 'USD', true)</td>
                        <?php   $sum += $item->amount ;  ?>
                        <td>@money($sum,'USD',true)</td>
                        @else
                        <td> - @money($item->amount, 'USD', true)</td>
                        <?php $sum -= $item->amount; ?>
                        <td>@money($sum,'USD',true)</td>
                        @endif
                    </tr>
                    @endforeach
                    @else
                          <tr>
                            <td>No Data</td>
                          </tr>
                    @endif
                </tbody>
            </table>
             <hr>
          <div class="row">
            <div class="col-md-6" >Total</div>
            <div class="col-md-6"><span class="pull-right" style="margin-right:100px" id="total">@money($sum,'USD',true)</span></div>
          </div>
        </div>
    </div>

    <!-- Modal -->
    

    <!-- /.box-body -->
    
    
    <!-- /.box-footer -->
</div>
<script type="text/javascript">
    $(document).ready(function(){
        var val = $("table:first tr:last td:last").html();
        $('#total1').html(val);

        //Date picker
        $('#period_to').datepicker({
            format: '{{ $date_format }}',
            autoclose: true
        });
    });
</script>

