@extends('layouts.default')
@section('header-links')
    @include('accounts.accounting.header')
@endsection
@section('title', trans_choice('general.chartsofaccount', 2))


@section('new_button')
<div class="searchBox mr-2">
   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => trans('general.search_placeholder')]) !!}
   <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
<a href="{{ url('common/import/accounting/chartofaccounts') }}"  class="btn btn-default btn-Rcircle-iconic waves-effect waves-gray"><i class="material-icons left rotate90deg">
last_page
</i>{{ trans('import.import') }}</a>

<a href="{{ url('accounting/chartofaccounts/create') }}"  class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data toggle="tooltip" title="Create Charts of Account"><i class="material-icons left">add   </i> {{ trans_choice('general.chartsofaccount', 1)}} </a>

{{-- <span class="new-button"><a  class="btn btn-success btn-sm"><span class="fa fa-plus"></span> &nbsp;</a></span> --}}


{{-- <span><a  class="btn btn-success btn-sm"><span class="fa fa-download"></span> &nbsp;</a></span> --}}
@endsection

@section('content')
<!-- Default box -->
<div class="box box-success">
        <div class=" ">
            <table class="table table-invoice table-striped table-filter">
                <thead>
                    <tr>
                        <th width="25%"> {{ trans('general.name') }} </th>
                        <th width="15%">{{ trans_choice('accounting.type',1)}}</th>
                        <th width="25%"> {{ trans('accounting.detailtype') }}</th>
                        <th width="20%">{{ trans('accounting.balance')}}</th>
                        <th width="15%">{{ trans('general.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                      @include('accounts.common.charttable')
                </tbody>
            </table>
        </div>
    
    <!-- /.box-body -->

    <!-- /.box-footer -->
</div>
<!-- /.box -->

<!-- end -->
<script type="text/javascript">
$(function() {
  var minimized_elements = $('table tbody tr td.chartac-descr');
  minimized_elements.each(function() {
    var t = $(this).text();
    if (t.length < 50) return;

    $(this).html(
      t.slice(0, 50) + '<span>... </span><a href="#" class="more">Read More</a>' +
      '<span style="display:none;">' + t.slice(50, t.length) + ' <a href="#" class="less">Less</a></span>'
    );

  });

  $('a.more', minimized_elements).click(function(event) {
    event.preventDefault();
    $(this).hide().prev().hide();
    $(this).next().show();
  });

  $('a.less', minimized_elements).click(function(event) {
    event.preventDefault();
    $(this).parent().hide().prev().show().prev().show();
  });

});
</script>
@endsection

