@extends('layouts.default')

@section('title', trans('general.title.edit', ['type' => trans_choice('general.chartsofaccount', 1)]))
@section('new_button')
<a href="{{ url('accounting/chartofaccounts') }}" class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>{{ trans_choice('general.chartsofaccount', 1) . ' List'}} </a>

<a href="{{ url('accounting/chartofaccounts/create') }}"  class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data toggle="tooltip" title="Create Charts of Account"><i class="material-icons left">add   </i> {{ trans_choice('general.chartsofaccount', 1)}} </a>
@endsection
@section('content')
    <!-- Default box -->
    <div class="card">
        {!! Form::model($chartofaccounts, [
            'method' => 'PATCH',
            'files' => true,
            'url' => ['accounting/chartofaccounts', $chartofaccounts->id],
            'role' => 'form'
        ]) !!}

        <div class="row">
            <div class="col-md-3">
                {{ Form::selectGroup('account_type_id', trans_choice('general.types', 1), $types, config('general.types'),['data-live-search'=>'true']) }}
            </div>

            {{-- {{ Form::selectGroup('detail_type', trans_choice('general.detailtype', 1), 'bars',$detailtype, config('general.detailtype'),['data-live-search'=>'true']) }} --}}

            <div class="col-md-3">
                {{ Form::textGroup('name', trans('general.name'), null) }}
            </div>
    
            <div class="col-lg-3 col-md-4 col-sm-6">
                <small>Account Type</small>
                <select id="chart_parent_id" name="chart_parent_id"  class="selectpicker" data-live-search="true" {{ isset($chartofaccounts->chart_parent_id)?'':'disabled' }}>
                     @include('accounts.common.subloop_chart', ['account_details_name' => $account_details_name ,'chart_parent_id' => $chartofaccounts->chart_parent_id ,'name' => trans('general.form.select.field', ['field' => 'Account Type'])    ])
                </select> 
                <div class="help-block">
                    <div class="custom-controls-stacked d-block">
                        <label class="custom-control overflow-checkbox" >
                        <input type="checkbox" name="sub_chart" id="sub_chart" value="1" class="overflow-control-input" {{  ($chartofaccounts->chart_parent_id) ?'checked="checked"' : '' }}>
                        <span class="overflow-control-indicator"></span> <span class="overflow-control-description">Is Sub Account</span> </label>
                    </div> 
                </div>
            </div>

            {{ Form::hidden('currency_code', setting('general.default_currency') , ['id' => 'currency_code']) }}
            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="form-group  required" id="number_div" style="display: none">
                    {!! Form::text('number', isset($chartofaccounts->bank->number)?$chartofaccounts->bank->number:'', array_merge(['class' => 'form-control', 'placeholder' => trans('accounts.number')])) !!}
                   {!! Form::label('number', trans('accounts.number'), ['class' => 'control-label']) !!}
                    <span class="form-controlBrd"></span>
                </div>
            </div>

           <div class="col-lg-3 col-md-4 col-sm-6" >
                <div class="form-group required " id="balance_div"  style="display: none">
                    <input class="form-control" disabled value="{{ $chartofaccounts->balance }}" placeholder="Enter Balance"  name="balance" id="balance" type="text">
                    <label for="balance" class="control-label">Opening Balance</label>
                    <span class="form-controlBrd"></span>
                </div>
            </div>
            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="form-group  required" id="balance_as_of_div"  style="display: none">   
                    <input class="form-control" placeholder="Enter Balance as of" id="balance_as_of" data-inputmask="'alias': 'yyyy-mm-dd'" data-mask="" name="balance_as_of" value="{{ Date::parse($chartofaccounts->balance_as_of)->format($date_format) }}" type="text">
                    <label for="balance_as_of" class="control-label">Balance as of</label>
                     <span class="form-controlBrd"></span>
                </div>
            </div>

            <div class="col-md-12">
                {{ Form::textareaGroup('description', trans('general.description')) }}
            </div>

            <div class="col-md-3">
                {{ Form::radioGroup('enabled', trans('general.status')) }}
            </div>

            
        </div>
        <!-- /.box-body -->

        <div class="box-footer">
            {{ Form::saveButton('Save accounting/chartofaccounts') }}
        </div>
        <!-- /.box-footer -->

        {!! Form::close() !!}
    </div>
@endsection

@push('scripts')
    <script type="text/javascript">
        var text_yes = '{{ trans('general.yes') }}';
        var text_no = '{{ trans('general.no') }}';

        $(document).ready(function(){
            $('#enabled_1').prev().trigger('click');

            $('#name').focus();

           

            $('#category-color-picker').colorpicker();
        });
    </script>
    <script type="text/javascript">
        $(document).ready(function(){
            
            $(window).on("load", function(){
                if($('#sub_chart').is(':checked') == true){
                    $('#chart_parent_id').removeAttr('disabled');
                    $('#chart_parent_id').selectpicker('refresh');
                }
            });

            $("#sub_chart").change(function() {
                if(this.checked) {
                  $('#chart_parent_id').removeAttr('disabled'); 
                  $('#chart_parent_id').selectpicker('refresh');
                } 
                else{
                   $('#chart_parent_id').attr('disabled','disabled');
                   $('#chart_parent_id').selectpicker('refresh');
                }               
            });

            //Date picker
            $('#balance_as_of').datepicker({
                format: '{{ $date_format }}',
                autoclose: true
            });

            $('#account_type_id').on('change',function(){
                var account_type = $(this).val();
                if(account_type == 3 || account_type == 7){
                    $('#balance_div').show();
                    $('#balance').prop('required',true);
                    $('#balance_as_of').prop('required',true);
                    $('#balance_as_of_div').show();
                    $('#number_div').show();
                    $('#number').prop('required',true);
                }else{
                    $('#balance_div').hide();
                    $('#balance_as_of_div').hide();
                    $('#balance').prop('required',false);
                    $('#balance_as_of').prop('required',false); 
                    $('#number_div').hide();
                    $('#number').prop('required',false);
                }
                //Date picker
                $('#balance_as_of').datepicker({
                    format: '{{ $date_format }}',
                    autoclose: true
                });
            }); 

            var account_type = $('#account_type_id').val();
            accountdefalt(account_type);
        });

        function accountdefalt(account_type){ 
            if(account_type == 3 || account_type == 7){
                $('#balance_div').show();
                $('#balance').prop('required',true);
                $('#balance_as_of').prop('required',true);
                $('#balance_as_of_div').show();
                $('#number_div').show();
                $('#number').prop('required',true);
            }else{
                $('#balance_div').hide();
                $('#balance_as_of_div').hide();
                $('#number_div').hide();
                $('#balance').prop('required',false);
                $('#balance_as_of').prop('required',false); 
                $('#number').prop('required',false);
            }
            //Date picker
            $('#balance_as_of').datepicker({
                format: '{{ $date_format }}',
                autoclose: true
            });
        }
    </script>
@endpush
