@extends('layouts.default')

@section('title', trans('general.title.new', ['type' => trans_choice('general.chartsofaccount', 1)]))
@section('new_button')
<a href="{{ url('accounting/chartofaccounts') }}" class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>{{ trans_choice('general.chartsofaccount', 1) . ' List'}} </a>
@endsection
@section('content')
    <!-- Default box -->
    <div class="card">
        {!! Form::open(['url' => 'accounting/chartofaccounts', 'role' => 'form']) !!}

        <div class="row">
            {{ Form::selectGroup('account_type_id', trans_choice('general.types', 1), 'bars',$types, config('general.types'),['data-live-search'=>'true','required'=>'required']) }}
 
            {{ Form::textGroup('name', trans('general.name'), 'id-card-o') }}


            {{-- Sub Account Code --}}
            <div class="col-lg-3 col-md-4 col-sm-6" >  
                 <small>Select Parent Account</small>             
                <select id="chart_parent_id" name="chart_parent_id"  class="selectpicker" disabled="disabled" data-live-search='true'  >
                     @include('accounts.common.subloop_chart', ['account_details_name' => $account_details_name ,'customer_id' => '' ,'name' => trans('general.form.select.field', ['field' => 'Sub Account Type'])    ])
                </select>
                <div class="help-block">
                    <div class="custom-controls-stacked d-block">
                        <label class="custom-control overflow-checkbox" >
                        <input type="checkbox" name="sub_chart" id="sub_chart" value="1" class="overflow-control-input">
                        <span class="overflow-control-indicator"></span> <span class="overflow-control-description">Is Sub Account</span> </label>
                    </div> 
                </div>
            </div>

            {{-- Sub Account  Code --}}

            {{ Form::hidden('currency_code', setting('general.default_currency') , ['id' => 'currency_code']) }}
            <div  class="col-lg-3 col-md-4 col-sm-6" id="number_div" style="display: none">
            
                <div class="form-group required">
                    {!! Form::text('number', null, array_merge(['class' => 'form-control'])) !!}
                    {!! Form::label('number', trans('accounts.number') . ' *', ['class' => 'form-label']) !!}
                    <span class="form-controlBrd"></span>
                </div>
            </div>
            <div  class="col-lg-3 col-md-4 col-sm-6" id="balance_div" >
                <div class="form-group  required">
                     <input class="form-control"  name="balance" id="balance" type="text">
                     <label for="balance" class="form-label" id="balance_label">Opening Balance *</label>
                     <span class="form-controlBrd"></span>
                </div>
            </div>
            
            <div class="col-lg-3 col-md-4 col-sm-6" id="balance_as_of_div" style="display: none">
                <div class="form-group  required ">
                    <input class="form-control has-value " id="balance_as_of" data-inputmask="'alias': 'yyyy/mm/dd'" data-mask="" name="balance_as_of" type="text" value="{{Date::now()->format($date_format)}}">
                    <label for="balance_as_of" class="form-label">Balance as of *</label>
                    <span class="form-controlBrd"></span>
                    
                </div>
            </div>


            {{ Form::textareaGroup('description', trans('general.description')) }}

            {{ Form::radioGroup('enabled', trans('general.status')) }}

            
        </div>
        <!-- /.box-body -->

        <div class="box-footer">
            {{ Form::saveButtons('accounting/chartofaccounts') }}
        </div>
        <!-- /.box-footer -->

        {!! Form::close() !!}
    </div>
@endsection

@push('scripts')
    <script type="text/javascript">
        var text_yes = '{{ trans('general.yes') }}';
        var text_no = '{{ trans('general.no') }}';

        $(document).ready(function(){
            $('#enabled_1').prev().trigger('click');

            $('#name').focus();

            $("#sub_chart").change(function() {
                if(this.checked) {
                  $('#chart_parent_id').removeAttr('disabled'); 
                  $('#chart_parent_id').selectpicker('refresh');
                } 
                else{
                   $('#chart_parent_id').attr('disabled','disabled');
                   $('#chart_parent_id').selectpicker('refresh');
                }               
            });

        });


    </script>
    <script type="text/javascript">
        $(document).ready(function(){

            $('#balance_as_of').datepicker({
                format: '{{ $date_format }}',
                autoclose: true
            });
            var account_type = $('#account_type_id').val();
            accountdefalt(account_type);
            //Date picker

            $('#account_type_id').on('change',function(){
                var account_type = $(this).val();
                accountdefalt(account_type);
            }); 
        });
        function accountdefalt(account_type){
            if(account_type == 3 || account_type == 7){
                $('#balance_div').show();
                $('#balance').prop('required',true);
                $('#balance_as_of').prop('required',true);
                $('#balance_as_of_div').show();
                $('#number_div').show();
                $('#balance_label').html('Opening balance *');
                $('#number').prop('required',true);
            }
            else if(account_type == 2 || account_type == 4 || account_type == 5 || account_type == 10 )
            {
                $('#number_div').hide();
                $('#balance_div').show();
                $('#balance_label').html('Opening balance');
                $('#balance_as_of_div').show();
            }else if(account_type == 8 || account_type == 9|| account_type == 17){
                $('#number_div').hide();
                $('#balance_label').html('Unpaid balance');
                $('#balance_div').show();
                $('#balance_as_of_div').show();
            }
            else{
                $('#balance_div').hide();
                $('#balance_as_of_div').hide();
                $('#number_div').hide();
                $('#balance_label').html('Opening balance *');
                $('#balance').prop('required',false);
                $('#balance_as_of').prop('required',false); 
                $('#number').prop('required',false);
            }
            // if(account_type){
            // $.ajax({
            //     url: '/'+account_type,
            //     success:function(response){
            //         $('#detail_type').html(response);
            //         var skillsSelect = document.getElementById("detail_type");
            //         var selectedText = detail_type.options[detail_type.selectedIndex].text;
            //         $('#detail_type').selectpicker('refresh');
            //     },
            // });
            // }else{
            //     return false;
            // }
        }
    </script>
@endpush
