/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

require('./bootstrap');

window.Vue = require('vue').default;

import Vue from 'vue'
import VueChatScroll from 'vue-chat-scroll'

Vue.use(VueChatScroll)
Vue.use(require('vue-chat-scroll'));

// Importing jQuery
// window.$ = window.jQuery = require('jquery');

// Importin Pusher
import Pusher from 'pusher-js'
import axios from 'axios';

/**
 * The following block of code may be used to automatically register your
 * Vue components. It will recursively scan this directory for the Vue
 * components and automatically register them with their "basename".
 *
 * Eg. ./components/ExampleComponent.vue -> <example-component></example-component>
 */

// const files = require.context('./', true, /\.vue$/i)
// files.keys().map(key => Vue.component(key.split('/').pop().split('.')[0], files(key).default))

Vue.component('example-component', require('./components/ExampleComponent.vue').default);

// Group Chat
Vue.component('message', require('./components/GroupChat.vue').default);
// Personal Chat
Vue.component('chat-message', require('./components/ChatMessage.vue').default);
Vue.component('chat-log', require('./components/ChatLog.vue').default);
Vue.component('user-log', require('./components/UserLog.vue').default);
Vue.component('chat-composer', require('./components/ChatComposer.vue').default);
Vue.component('chat-users', require('./components/ChatUser.vue').default);
Vue.component('chat-messages', require('./components/ChatMessages.vue').default);

/**
 * Next, we will create a fresh Vue application instance and attach it to
 * the page. Then, you may begin adding components to this application
 * or customize the JavaScript scaffolding to fit your unique needs.
 */

/* Group Chat Start Here*/
const groupChat = new Vue({
    el: '#groupChat',
    data: {
        message: '',
        chat: {
            message: [],
            user: [],
            color: [],
            time: []
        },
        typing: '',
        numofusers: 0,
        auth_username: $('#myName').val()

    },
    methods: {
        /* get previous conversation */
        getPrivousMessage() {
            axios.get('/chat_olddata').then(response => {
                if (response.data != '') {
                    this.jsonSettings = response.data;
                    this.jsonSettings.map((item, i) => {
                        this.chat.message.push(item.message);
                        this.chat.time.push(item.time);
                        var authId = $("#myId").val();
                        if (authId == item.user) {
                            this.chat.color.push('success');
                            this.chat.user.push('you');
                        } else {
                            this.chat.color.push('warning');
                            var mname = item.name.toLowerCase().replace(/\b[a-z]/g, function (letter) {
                                return letter.toUpperCase();
                            });
                            this.chat.user.push(mname);
                        }
                    });

                }
            });
        },
        /* send  and save conversation */
        send() {
            if (this.message.length != 0) {
                this.chat.message.push(this.message);
                this.chat.color.push('success');
                this.chat.user.push('you');
                this.chat.time.push(this.getTime());
            }
            axios.post('/chat_send', {
                    message: this.message,
                })
                .then(response => {
                    //console.log(response);
                })
                .catch(error => {
                    // console.log(error);
                });

            this.message = ''
        },
        /* Time Taken now */
        getTime() {
            let time = new Date();
            return time.getHours() + ':' + time.getMinutes();
        }
    },
    mounted() {
        this.getPrivousMessage();
        
        Echo.join(`chat`)
            .here((users) => {
                //  console.log(users);
                this.numofusers = users.length;
            })
            .joining((user) => {
                this.numofusers += 1;
                // Toaster Messages
                //this.$toaster.success(user.name+' is joined the chat room'); 
            })
            .leaving((user) => {
                this.numofusers -= 1;
                // Toaster Messages
                // this.$toaster.warning(user.name+' is leaved the chat room');
            })
            .listen('ChatsEvent', (e) => {
                this.chat.message.push(e.message);
                this.chat.color.push('warning');
                var mname = e.user.toLowerCase().replace(/\b[a-z]/g, function (letter) {
                    return letter.toUpperCase();
                });
                this.chat.user.push(mname);
                this.chat.time.push(this.getTime());
            });
    }
});

/* Personal Chat Start Here*/
const personalChat = new Vue({
    el: '#personalChat',
    data: {
        message: '',
        users_data: [],
        chat: {
            message: [],
            user: [],
            type: [],
            time: [],
            reciever: '',
            chatcount: '',
        },
        conversation_id: '',
    },
    methods: {
        users() {
            // Get Only active users list
            axios.get('/chat_activeusers').then(response => {
                this.users_data = response.data;
            });            

            // Channel for users log
            Echo.channel('userlog')
                .listen('UserLog', (e) => {
                    let toparray = new Array();
                    let myarray = new Array();
                    if (e.user) {
                        $.each(this.users_data, function (i, item) {
                            if (item[0].id == e.user.id) {
                                item[0].last_activity = "now";
                                toparray.push(item[0]);
                            } else {
                                myarray.push(item);
                            }
                        });

                        myarray.unshift(toparray);
                        this.users_data = [];
                        this.users_data = myarray;
                    }
                });
        },

        /**
         * Get User previous messages
         * @param {} userId // Receiver Id
         */
        fetchMessages(userId) {
            if (this.conversation_id != '') {
                Echo.leaveChannel('chat.' + this.conversation_id);
            }

            if (userId) {
                axios.get('/chat/' + userId.userId).then(response => {
                    this.jsonSettings = response.data.message;
                    this.conversation_id = response.data.conversation_id;
                    this.chat.message = [];
                    this.chat.user = [];
                    this.chat.type = [];
                    this.chat.reciever = '';
                    this.chat.reciever = response.data.reciever;
                    this.jsonSettings.map((item, i) => {
                        this.chat.message.push(item.message);
                        this.chat.time.push(this.parseDate(item.created_at));
                        var authId = $("#authId").val();
                        if (authId == item.user.id) {
                            this.chat.type.push('warning');
                            this.chat.user.push(item.user.name);
                        } else {
                            this.chat.type.push('success');
                            this.chat.user.push(item.user.name);
                        }
                    });

                    Echo.channel('chat.' + this.conversation_id).listen('MessageSent', (e) => {
                        this.chat.message.push(e.message.message);
                        this.chat.user.push(e.user.name);
                        this.chat.chatcount++;
                        if (authId == e.user.id) {
                            this.chat.type.push('warning');
                        } else {
                            this.chat.type.push('success');
                        }
                        this.chat.time.push(this.getTime());
                    });
                });
            }
        },

        // Sending new message to receiver
        addMessage() {
            if (this.message.length != 0) {
                this.chat.message.push(this.message);
                this.chat.type.push('warning');
                this.chat.user.push('you');
                this.chat.time.push(this.getTime());
                axios.post('/chat', {
                    message: this.message,
                    conversation_id: this.conversation_id,
                }).then(response => {
                    // Something
                });
                this.message = '';
            }
        },

        /* Time Taken now */
        getTime() {
            let time = new Date();
            var hours = time.getHours();
            var minutes = time.getMinutes();
            var ampm = hours >= 12 ? 'pm' : 'am';
            hours = hours % 12;
            hours = hours ? hours : 12; // the hour '0' should be '12'
            minutes = minutes < 10 ? '0' + minutes : minutes;
            var strTime1 = hours + ':' + minutes + ' ' + ampm;
            return strTime1;
        },

        /* Time Taken now */
        parseDate(dte) {
            let time = new Date(dte);
            var hours = time.getHours();
            var minutes = time.getMinutes();
            var ampm = hours >= 12 ? 'pm' : 'am';
            hours = hours % 12;
            hours = hours ? hours : 12; // the hour '0' should be '12'
            minutes = minutes < 10 ? '0' + minutes : minutes;
            var strTime = hours + ':' + minutes + ' ' + ampm;
            return strTime;
        },
    },
    mounted() {
        this.users();
        this.fetchMessages();
    }
});

/* Meeting Info */
const meeting = new Vue({
    el : '#meetingCount',
    data: {
        meetingCount: 0,
        muserId: $("#myId").val()
    },
    mounted() {
            Echo.channel('meeting.' + this.muserId)
            .listen('MeetingCreated', (e) => {
                this.meetingCount = 1;
            });
    }
});

// OPT Live Cards
Vue.component('opt-live-cards', require('./components/charts/opt/optLiveCards.vue').default);

const optLiveCards = new Vue({
    el : '#opt-live-cards',
    data: {
        totalopt: 0,
        totalconsultants: 0,
        totaltraining: 0,
        totalmarketing: 0
    },
    mounted() {
        // Getting optdata on load
        axios.get('optlivecardsdata').then(response => {
            this.totalopt = response.data.opt;
            this.totalconsultants = response.data.consultants;
            this.totaltraining = response.data.training;
            this.totalmarketing = response.data.marketing;
        });

        // Listening optlivedata updations
        Echo.channel('optlivecards')
            .listen('UpdateOptLiveCards', (e) => {
                axios.get('optlivecardsdata').then(response => {
                    this.totalopt = response.data.opt;
                    this.totalconsultants = response.data.consultants;
                    this.totaltraining = response.data.training;
                    this.totalmarketing = response.data.marketing;
                });
            });
    }
});

// Polar Area
Vue.component('opt-polar-area', require('./components/charts/opt/optPolarArea.vue').default);

const optcharts = new Vue({
    el : '#opt-polararea',
    data: {
        width: 250,
        height: 250,
        labels: [
            'Consultants',
            'Enquiry',
            'Training',
            'Marketing',
            'In Job'
        ],
        chartdata: []
    },
    mounted() {
        // Getting data on load
        axios.get('optpolardata').then(response => {
            this.jsonSettings = response.data;
            this.jsonSettings.map((item, i) => {
                this.chartdata[i] = item;
            });
        });

        // Updating data on event
        // Listening optlivedata updations
        Echo.channel('optpolardata')
            .listen('UpdateOptPolar', (e) => {
                axios.get('optpolardata').then(response => {
                    this.jsonSettings = response.data;
                    this.jsonSettings.map((item, i) => {
                        this.chartdata[i] = item;
                    });
                });
            });
    }
});

Vue.component('opt-bar-charts', require('./components/charts/opt/optBarChart.vue').default);

const optbarChart = new Vue({
    el : '#opt-bar-charts',
    data: {
        width: 250,
        height: 250,
        labels: [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
        cdata: [
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        ]
    },
    mounted() {
        axios.get('optbardata').then(response => {
            console.log(response.data);
            this.enquiry = response.data[0];
            this.training = response.data[1];
            this.marketing = response.data[2];
            
            this.enquiry.map((item, i) => {
                this.cdata[0][i] = item;
            });
            
            this.training.map((item, i) => {
                this.cdata[1][i] = item;
            });
            
            this.marketing.map((item, i) => {
                this.cdata[2][i] = item;
            });
        });

        // Updating data on event
        // Listening optlivedata updations
        Echo.channel('optbardata')
            .listen('UpdateOptBar', (e) => {
                axios.get('optbardata').then(response => {
                    console.log(response.data);
                    this.enquiry = response.data[0];
                    this.training = response.data[1];
                    this.marketing = response.data[2];
                    
                    this.enquiry.map((item, i) => {
                        this.cdata[0][i] = item;
                    });
                    
                    this.training.map((item, i) => {
                        this.cdata[1][i] = item;
                    });
                    
                    this.marketing.map((item, i) => {
                        this.cdata[2][i] = item;
                    });
                });
            });
    }

});

Vue.component('opt-line-charts', require('./components/charts/opt/optLine.vue').default);

const optlineChart = new Vue({
    el : '#opt-line-charts',
    data: {
        width: 250,
        height: 250,
        labels: [
            '',
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
        cdata: [
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], 
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        ]
    },
    mounted() {
        axios.get('optlinedata').then(response => {
            console.log(response.data);
            this.enquiry = response.data[0];
            this.training = response.data[1];
            this.marketing = response.data[2];
            
            this.enquiry.map((item, i) => {
                this.cdata[0][i] = item;
            });
            
            this.training.map((item, i) => {
                this.cdata[1][i] = item;
            });
            
            this.marketing.map((item, i) => {
                this.cdata[2][i] = item;
            });
        });

        // Updating data on event
        // Listening optlivedata updations
        Echo.channel('optlinedata')
            .listen('UpdateOptLine', (e) => {
                axios.get('optlinedata').then(response => {
                    console.log(response.data);
                    this.enquiry = response.data[0];
                    this.training = response.data[1];
                    this.marketing = response.data[2];
                    
                    this.enquiry.map((item, i) => {
                        this.cdata[0][i] = item;
                    });
                    
                    this.training.map((item, i) => {
                        this.cdata[1][i] = item;
                    });
                    
                    this.marketing.map((item, i) => {
                        this.cdata[2][i] = item;
                    });
                });
            });
    }
});

// Bench Live Data
Vue.component('bench-live-cards', require('./components/charts/benchsales/BenchLiveCards.vue').default);

const benchLiveCards = new Vue({
    el : '#bench-live-cards',
    data: {
        totalbench: 0,
        totalinjob: 0,
        totalmarketing: 0,
        totalsubmissions: 0
    },
    mounted() {
        // Getting optdata on load
        axios.get('benchlivecardsdata').then(response => {
            this.totalbench = response.data.bench;
            this.totalmarketing = response.data.marketing;
            this.totalinjob = response.data.injob;
            this.totalsubmissions = response.data.submissions;
        });

        // Listening optlivedata updations
        Echo.channel('benchlivecards')
            .listen('UpdateBenchLiveCards', (e) => {
                axios.get('benchlivecardsdata').then(response => {
                    this.totalbench = response.data.bench;
                    this.totalmarketing = response.data.marketing;
                    this.totalinjob = response.data.injob;
                    this.totalsubmissions = response.data.submissions;
                });
            });
    }
});

// Bench Polar Area
Vue.component('bench-polar-area', require('./components/charts/benchsales/BenchPolarArea.vue').default);

const Benchcharts = new Vue({
    el : '#bench-polararea',
    data: {
        width: 250,
        height: 250,
        labels: [
            'Submissions',
            'Marketing',
            'In Job'
        ],
        chartdata: []
    },
    mounted() {
        // Getting data on load
        axios.get('benchpolardata').then(response => {
            this.jsonSettings = response.data;
            this.jsonSettings.map((item, i) => {
                this.chartdata[i] = item;
            });
        });

        // Updating data on event
        // Listening optlivedata updations
        Echo.channel('benchpolardata')
            .listen('UpdateBenchPolar', (e) => {
                axios.get('benchpolardata').then(response => {
                    this.jsonSettings = response.data;
                    this.jsonSettings.map((item, i) => {
                        this.chartdata[i] = item;
                    });
                });
            });
    }
});

// Bench Bar
Vue.component('bench-bar-charts', require('./components/charts/benchsales/BenchBarChart.vue').default);

const benchbarChart = new Vue({
    el : '#bench-bar-charts',
    data: {
        width: 250,
        height: 250,
        labels: [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
        cdata: [
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        ]
    },
    mounted() {
        axios.get('benchbardata').then(response => {
            console.log(response.data);
            this.submissions = response.data[0];
            this.marketing = response.data[1];
            this.injob = response.data[2];
            
            this.submissions.map((item, i) => {
                this.cdata[0][i] = item;
            });
            
            this.marketing.map((item, i) => {
                this.cdata[1][i] = item;
            });
            
            this.injob.map((item, i) => {
                this.cdata[2][i] = item;
            });
        });

        // Updating data on event
        // Listening optlivedata updations
        Echo.channel('benchbardata')
            .listen('UpdateBenchBar', (e) => {
                axios.get('benchbardata').then(response => {
                    console.log(response.data);
                    this.submissions = response.data[0];
                    this.marketing = response.data[1];
                    this.injob = response.data[2];
                    
                    this.submissions.map((item, i) => {
                        this.cdata[0][i] = item;
                    });
                    
                    this.marketing.map((item, i) => {
                        this.cdata[1][i] = item;
                    });
                    
                    this.injob.map((item, i) => {
                        this.cdata[2][i] = item;
                    });
                });
            });
    }

});

// BEnch Line
Vue.component('bench-line-charts', require('./components/charts/benchsales/BenchLine.vue').default);

const benchlineChart = new Vue({
    el : '#bench-line-charts',
    data: {
        width: 250,
        height: 250,
        labels: [
            '',
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
        cdata: [
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], 
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        ]
    },
    mounted() {
        axios.get('benchlinedata').then(response => {
            console.log(response.data);
            this.submissions = response.data[0];
            this.marketing = response.data[1];
            this.injob = response.data[2];
            
            this.submissions.map((item, i) => {
                this.cdata[0][i] = item;
            });
            
            this.marketing.map((item, i) => {
                this.cdata[1][i] = item;
            });
            
            this.injob.map((item, i) => {
                this.cdata[2][i] = item;
            });
        });

        // Updating data on event
        // Listening Benchlivedata updations
        Echo.channel('benchlinedata')
            .listen('UpdateBenchLine', (e) => {
                axios.get('benchlinedata').then(response => {
                    console.log(response.data);
                    this.submissions = response.data[0];
                    this.marketing = response.data[1];
                    this.injob = response.data[2];
                    
                    this.submissions.map((item, i) => {
                        this.cdata[0][i] = item;
                    });
                    
                    this.marketing.map((item, i) => {
                        this.cdata[1][i] = item;
                    });
                    
                    this.injob.map((item, i) => {
                        this.cdata[2][i] = item;
                    });
                });
            });
    }
});

// Accounts Live Data
// Bench Live Data
Vue.component('accounts-live-cards', require('./components/charts/accounts/AccountsLiveData.vue').default);

const accountsLiveCards = new Vue({
    el : '#accounts-live-cards',
    data: {
        invoices: 0,
        bills: 0,
        profit: 0
    },
    mounted() {
        // Getting optdata on load
        axios.get('accountslivecardsdata').then(response => {
            this.invoices = response.data.invoices;
            this.bills = response.data.bills;
            this.profit = response.data.profit;
        });

        // Listening optlivedata updations
        Echo.channel('accountslivecards')
            .listen('UpdateAccountsLiveCards', (e) => {
                axios.get('accountslivecardsdata').then(response => {
                    this.invoices = response.data.invoices;
                    this.bills = response.data.bills;
                    this.profit = response.data.profit;
                });
            });
    }
});

// Accounts Bar Chart
Vue.component('accounts-bar-charts', require('./components/charts/accounts/AccountsBarChart.vue').default);

const accountsbarChart = new Vue({
    el : '#accounts-bar-charts',
    data: {
        width: 250,
        height: 250,
        labels: [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
          ],
        cdata: [
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
        ]
    },
    mounted() {
        axios.get('accountsbardata').then(response => {
            this.invoices = response.data[0];
            this.bills = response.data[1];
            
            this.invoices.map((item, i) => {
                this.cdata[0][i] = item;
            });
            
            this.bills.map((item, i) => {
                this.cdata[1][i] = item;
            });
        });

        // Updating data on event
        // Listening optlivedata updations
        Echo.channel('accountsbardata')
            .listen('UpdateAccountsBar', (e) => {
                axios.get('accountsbardata').then(response => {
                    this.invoices = response.data[0];
                    this.bills = response.data[1];
                    
                    this.invoices.map((item, i) => {
                        this.cdata[0][i] = item;
                    });
                    
                    this.bills.map((item, i) => {
                        this.cdata[1][i] = item;
                    });
                });
            });
    }

});

// Accounts Polar
Vue.component('accounts-polar-area', require('./components/charts/accounts/AccountsPolar.vue').default);

const accountspolarcharts = new Vue({
    el : '#accounts-polararea',
    data: {
        width: 250,
        height: 250,
        labels: [],
        chartdata: []
    },
    mounted() {
        // Getting data on load
        axios.get('accountspolardata').then(response => {
            this.llabels = response.data[0];
            this.llabels.map((item, i) => {
                this.labels[i] = item;
            });

            this.jsonSettings = response.data[1];
            this.jsonSettings.map((item, i) => {
                this.chartdata[i] = item;
            });
        });

        // Updating data on event
        // Listening optlivedata updations
        Echo.channel('accountspolardata')
            .listen('UpdateAccountsPolar', (e) => {
                axios.get('accountspolardata').then(response => {
                    this.llabels = response.data[0];
                    this.llabels.map((item, i) => {
                        this.labels[i] = item;
                    });

                    this.jsonSettings = response.data[1];
                    this.jsonSettings.map((item, i) => {
                        this.chartdata[i] = item;
                    });
                });
            });
    }
});