/* Date Range */
var start = moment().startOf('month');
var end = moment().endOf('month');

$(function () {
    function dRange(start, end) {
        $('#dataRange1').val(start.format('L') + ' - ' + end.format('L'));
        consultants();
    }

    $('#data-range1').daterangepicker({
        startDate: start,
        endDate: end,
        ranges: {
            'This Week': [moment().startOf('isoWeek'), moment().endOf('isoWeek')],
            'Last Week': [moment().subtract('1', 'week').startOf('isoWeek'), moment().subtract('1', 'week').endOf('isoWeek')],
            'Last Two Weeks': [moment().subtract('2', 'week').startOf('isoWeek'), moment().subtract('1', 'week').endOf('isoWeek')],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Previous Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Quarter': [moment().subtract(2, 'months').startOf('month'), moment().endOf('month')],
            'Previous Quarter': [moment().subtract(5, 'months').startOf('month'), moment().subtract(3, 'months').endOf('month')],
            'Last 12 Months': [moment().subtract(11, 'months').startOf('month'), moment().endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Previous Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    }, dRange);

    dRange(start, end);
});
// Consultants Counts
function consultants() {
    var dates = $("#dataRange1").val();
    var type = 1;
    
    $.ajax({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        url: '/counts',
        type: 'POST',
        data: 'dates=' + dates + '&type=' + type,
        success: function (result) {
            $("#card"+result.cardId).html(result.count);
        }
    })
}