CKEDITOR.replace('resume', {
    toolbarGroups: [
		{ name: 'document',	   groups: [ 'mode', 'document' ] },
 		{ name: 'clipboard',   groups: [ 'clipboard', 'undo' ] },
 		{ name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },
 		{ name: 'links' }
	]
});
$("#mobile").mask("000 000-0000");
$("#ssn").mask("000-00-0000");
$("#supervisor_phone").mask("(000) 000-0000");
$(".emergency_mobile").mask("(000) 000-0000");
$(".supervisor_phone").mask("(000) 000-0000");

// ON LOAD Smart wizard
$(document).ready(function() {
    // Smart Wizard
    $('#wizard').smartWizard({
        onLeaveStep: leaveAStepCallback,
        onFinish: onFinishCallback
    });

    function leaveAStepCallback(obj, context) {
        return validateSteps(context.fromStep);
    }

    function onFinishCallback(objs, context) {
        if (validateAllSteps()) {
            $('#create_employee_form').submit();
        }
    }

    // Your Step validation logic
    function validateSteps(stepnumber) {
        var isValid = true; 
        // Validate Username
        var un = $('#name').val();
        if(un == ''){
            isValid = false;
            $('#name').siblings(".with-errors").show();
        }else{
            isValid = true;
            $('#name').siblings(".with-errors").hide();
        }

        // Validate Email
        var un = $('#email').val();
        if(un == ''){
            isValid = false;
            $('#email').siblings(".with-errors").show();
        }else{
            isValid = true;
            $('#email').siblings(".with-errors").hide();
        }
        
        // Validate mobile
        var un = $('#mobile').val();
        if(un == ''){
            isValid = false;
            $('#mobile').siblings(".with-errors").show();
        }else{
            isValid = true;
            $('#mobile').siblings(".with-errors").hide();
        }

        // Validate status
        var un = $('#status').val();
        if(un == ''){
            isValid = false;
            $('#status').parent().siblings(".with-errors").show();
        }else{
            isValid = true;
            $('#status').parent().siblings(".with-errors").hide();
        }

        // Validate Visa
        var un = $('#visa_status').val();
        if(un == ''){
            isValid = false;
            $('#visa_status').parent().siblings(".with-errors").show();
        }else{
            isValid = true;
            $('#visa_status').parent().siblings(".with-errors").hide();
        }

        // Validate US state 
        var un = $('#state_2').val();
        if(un == ''){
            isValid = false;
            $('#state_2').parent().siblings(".with-errors").show();
        }else{
            isValid = true;
            $('#state_2').parent().siblings(".with-errors").hide();
        }

        // Validate technologies 
        var un = $('#technolgies').val();
        if(un == ''){
            isValid = false;
            $('#technolgies').parent().siblings(".with-errors").show();
        }else{
            isValid = true;
            $('#technolgies').parent().siblings(".with-errors").hide();
        }

        // Validate reference 
        var un = $('#consultant_reference').val();
        if(un == ''){
            isValid = false;
            $('#consultant_reference').parent().siblings(".with-errors").show();
        }else{
            isValid = true;
            $('#consultant_reference').parent().siblings(".with-errors").hide();
        }

        // Validate Comments 
        var un = $('#comments').val();
        if(un == ''){
            isValid = false;
            $('#comments').siblings(".with-errors").show();
        }else{
            isValid = true;
            $('#comments').siblings(".with-errors").hide();
        }

        return isValid;
    }

    // Step 1 checking
    $('.step1Select').on('change', function(){
        var jc = $(this).val();
        if(jc == ''){
        $(this).parent().siblings(".with-errors").show();
        }else{
        $(this).parent().siblings(".with-errors").hide();
        }
    }); 

    $('.step1Text').on('keyup', function(){
    var jc = $(this).val();
    if(jc == ''){
        $(this).siblings(".with-errors").show();
    }else{
        $(this).siblings(".with-errors").hide();
    }
    }); 

    function validateAllSteps() {
        var isStepValid = true;
        // all step validation logic
        if (validateSteps(1)) {
            isStepValid = true;
        } else {
            isStepValid = false;
        }

        $('#create_employee_form').validate().settings.ignore = ':not(select:hidden, input:visible, textarea:visible)';

        $("#create_employee_form").validate({
            // Specify validation rules
            rules: {
                "technologies[]": "required",
            },
            // Specify validation error messages
            messages: {
                "technologies[]": "please select technology"
            },
            errorPlacement: function(error, element) {
                error.insertAfter("#technolgies");
            }
        });

        return isStepValid;
    }
});

// Validating Comments Field
$("#comments").on('keyup', function() {
    if ($("#comments").val() == '') {
        $("#comments_error").show();
    } else {
        $("#comments_error").hide();
    }
});

// On status change
$('#status').on('change', function() {
    var status = $(this).val();
    if (status == 'in_job') {
        $("#clientDetailsDiv").slideToggle("slow").show();

        $("#job_title").prop('required', true);
        $('#vendor_company_id').prop('required', true);
        $('#vendor_id').prop('required', true);
        $('#client_id').prop('required', true);
        $('#payrate').prop('required', true);
        $('#ot_payrate').prop('required', true);
        $('#join_date').prop('required', true);

        $("#selectBenchDiv").show();
        $("#tech_recruiter_id").prop('required', true);
    } else if ((status == 'on_bench') || (status == 'open_bench')) {
        $("#selectBenchDiv").show();

        $("#clientDetailsDiv").slideUp("slow").hide();
        $("#job_title").prop('required', false);
        $('#vendor_company_id').prop('required', false);
        $('#vendor_id').prop('required', false);
        $('#client_id').prop('required', false);
        $('#payrate').prop('required', false);
        $('#hourly_payrate').prop('required', false);
        $('#ot_payrate').prop('required', false);
        $('#join_date').prop('required', false);
    } else {
        $("#clientDetailsDiv").slideUp("slow").hide();

        $("#job_title").prop('required', false);
        $('#vendor_company_id').prop('required', false);
        $('#vendor_id').prop('required', false);
        $('#client_id').prop('required', false);
        $('#payrate').prop('required', false);
        $('#hourly_payrate').prop('required', false);
        $('#ot_payrate').prop('required', false);
        $('#join_date').prop('required', false);

        $("#selectBenchDiv").hide();
        $("#tech_recruiter_id").val('');
        $("#tech_recruiter_id").selectpicker('refresh');
        $("#tech_recruiter_id").prop('required', false);
    }
});

$("#consultant_reference").on('change', function() {
    var referType = $("#consultant_reference").val();

    if(referType == 'friend_refferal' || referType == 'manager_reffered') {
        $("#referer").show();
    } else {
        $("#referer").hide();
    }
})

// Get States By Country
function getStates(id) {
    var country = $("#country_" + id).val();
    $("#state_" + id).empty().selectpicker('refresh');
    $("#city_" + id).empty().selectpicker('refresh');
    $.ajax({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        url: '/get_states',
        data: 'country_id=' + country,
        success: function(result) {
            $("#state_" + id).append(result);
            $("#state_" + id).selectpicker('refresh');
        }
    });
}

// Get Citites By State
function getCities(id) {
    var state = $("#state_" + id).val();
    $("#city_" + id).empty().selectpicker('refresh');
    $.ajax({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        url: '/get_cities',
        data: 'state_id=' + state,
        success: function(result) {
            $("#city_" + id).append(result);
            $("#city_" + id).selectpicker('refresh');
        }
    });
}

// ON Vendor Company Name Change
$('select[id^=vendor_company_name]').on('change', function() {
    var company_id = $(this).val();
    $("#vendor_name").html('');
    $.ajax({
        url: '/getVendorNameList/' + company_id,
        success: function(result) {
            $("#vendor_name").html(result);
            $("#vendor_name").selectpicker('refresh');
        }
    });
});


// Travell Div
$("#home_visit").on('change', function() {
    if ($("#home_visit").val() == 'yes') {
        $("#visitTimesDiv").show();
    } else {
        $("#visitTimesDiv").hide();
    }
});