$(document).ready(function () {
    var today = new Date();
    $('#start_date').inputmask('MM-DD-YYYY', { placeholder: 'MM-DD-YYYY' });
    $('#start_date').datepicker({
        format: 'mm-dd-yyyy',
        todayHighlight: true,
        clearBtn: true,
        endDate: today
    });

    $('#end_date').inputmask('MM-DD-YYYY', { placeholder: 'MM-DD-YYYY' });
    $('#end_date').datepicker({
        format: 'mm-dd-yyyy',
        todayHighlight: true,
        clearBtn: true,
        endDate: today,
    });

    $("#country").change(function () {
        var country = $("#country").val();

        $("#state").empty();
        $("#city").empty();
        $.ajax({
            url: '/getStateAjax',
            data: 'country=' + country,
            success: function (result) {
                $("#state").append(result);
            }
        });
    });

    $("#state").change(function () {
        var state = $("#state").val();
        $("#city").empty();
        $.ajax({
            url: '/getCityAjax',
            data: 'state=' + state,
            success: function (result) {
                $("#city").append(result);
            }
        });
    });

    $("#create_batch_form").validate({
        rules: {
            batch_id: "required",
            batch_name: "required",
        },
        messages: {
            batch_id: "Please fillout this",
            batch_name: "Please fillout this",
        },
        submitHandler: function (form) {
            form.submit();
        }
    });
});